/*
 * Decompiled with CFR 0.152.
 */
package zone.rong.mixinbooter.fix.mixinextras;

import java.util.ListIterator;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;

public class MixinExtrasFixer
implements IClassTransformer,
Opcodes {
    public static Handle redirect(int tag, String owner, String name, String desc, boolean itf) {
        return new Handle(tag, owner, name, desc);
    }

    public byte[] transform(String name, String transformedName, byte[] classBytes) {
        switch (name) {
            case "com.llamalad7.mixinextras.utils.ASMUtils": 
            case "com.llamalad7.mixinextras.utils.OperationUtils": 
            case "com.llamalad7.mixinextras.utils.TypeUtils": 
            case "com.llamalad7.mixinextras.expression.impl.utils.ExpressionASMUtils": {
                return this.fixHandleInstantiation(classBytes);
            }
        }
        return classBytes;
    }

    private byte[] fixHandleInstantiation(byte[] classBytes) {
        ClassNode node = new ClassNode();
        ClassReader reader = new ClassReader(classBytes);
        reader.accept((ClassVisitor)node, 0);
        for (MethodNode method : node.methods) {
            ListIterator iterator = method.instructions.iterator();
            boolean foundNew = false;
            boolean foundDup = false;
            while (iterator.hasNext()) {
                AbstractInsnNode instruction = (AbstractInsnNode)iterator.next();
                if (!foundNew && !foundDup && instruction.getOpcode() == 187 && "org/objectweb/asm/Handle".equals(((TypeInsnNode)instruction).desc)) {
                    foundNew = true;
                    iterator.remove();
                    continue;
                }
                if (foundNew && instruction.getOpcode() == 89) {
                    foundNew = false;
                    foundDup = true;
                    iterator.remove();
                    continue;
                }
                if (foundNew || !foundDup || instruction.getOpcode() != 183 || !"org/objectweb/asm/Handle".equals(((MethodInsnNode)instruction).owner)) continue;
                iterator.set(new MethodInsnNode(184, "zone/rong/mixinbooter/fix/mixinextras/MixinExtrasFixer", "redirect", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;Z)Lorg/objectweb/asm/Handle;"));
            }
        }
        ClassWriter writer = new ClassWriter(0);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }
}

