/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.rewardtype;

import chanceCubes.rewards.rewardparts.MessagePart;
import chanceCubes.rewards.rewardtype.BaseRewardType;
import chanceCubes.util.Scheduler;
import chanceCubes.util.Task;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public class MessageRewardType
extends BaseRewardType<MessagePart> {
    public MessageRewardType(MessagePart ... messages) {
        super(messages);
    }

    public MessageRewardType(String ... messages) {
        super(MessageRewardType.convertToMessageParts(messages));
    }

    private static MessagePart[] convertToMessageParts(String ... messages) {
        MessagePart[] toReturn = new MessagePart[messages.length];
        for (int i = 0; i < messages.length; ++i) {
            toReturn[i] = new MessagePart(messages[i]);
        }
        return toReturn;
    }

    @Override
    public void trigger(final MessagePart message, final World world, final int x, final int y, final int z, final EntityPlayer player) {
        Scheduler.scheduleTask(new Task("Message Reward Delay", message.getDelay()){

            @Override
            public void callback() {
                for (int i = 0; i < world.field_73010_i.size(); ++i) {
                    EntityPlayer entityplayer = (EntityPlayer)world.field_73010_i.get(i);
                    if (entityplayer.equals((Object)player)) {
                        entityplayer.func_145747_a((ITextComponent)new TextComponentString(message.getMessage()));
                        continue;
                    }
                    double dist = Math.sqrt(Math.pow((double)x - entityplayer.field_70165_t, 2.0) + Math.pow((double)y - entityplayer.field_70163_u, 2.0) + Math.pow((double)z - entityplayer.field_70161_v, 2.0));
                    if (!(dist <= (double)message.getRange()) && !message.isServerWide()) continue;
                    entityplayer.func_145747_a((ITextComponent)new TextComponentString(message.getMessage()));
                }
            }
        });
    }
}

