/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.defaultRewards;

import chanceCubes.rewards.defaultRewards.BaseCustomReward;
import chanceCubes.util.CCubesDamageSource;
import chanceCubes.util.RewardBlockCache;
import chanceCubes.util.RewardsUtil;
import chanceCubes.util.Scheduler;
import chanceCubes.util.Task;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.network.play.server.SPacketTitle;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class MathReward
extends BaseCustomReward {
    private Map<EntityPlayer, RewardInfo> inQuestion = new HashMap<EntityPlayer, RewardInfo>();

    public MathReward() {
        super("chancecubes:math", -30);
    }

    @Override
    public void trigger(World world, BlockPos pos, final EntityPlayer player, Map<String, Object> settings) {
        if (this.inQuestion.containsKey(player)) {
            return;
        }
        int num1 = world.field_73012_v.nextInt(100);
        int num2 = world.field_73012_v.nextInt(100);
        player.func_145747_a((ITextComponent)new TextComponentString("Quick, what's " + num1 + "+" + num2 + "?"));
        BlockPos playerPos = new BlockPos(player.field_70165_t, player.field_70163_u, player.field_70161_v);
        RewardBlockCache cache = new RewardBlockCache(world, playerPos, player.func_180425_c());
        for (int xx = -2; xx < 3; ++xx) {
            for (int zz = -2; zz < 3; ++zz) {
                for (int yy = 1; yy < 5; ++yy) {
                    if (xx == -2 || xx == 2 || zz == -2 || zz == 2 || yy == 1 || yy == 4) {
                        cache.cacheBlock(new BlockPos(xx, yy, zz), Blocks.field_150357_h.func_176223_P());
                        continue;
                    }
                    if (xx != -1 && xx != 1 || zz != -1 && zz != 1 || yy != 2) continue;
                    cache.cacheBlock(new BlockPos(xx, yy, zz), Blocks.field_150426_aN.func_176223_P());
                }
            }
        }
        player.func_70634_a((double)((int)player.field_70165_t), (double)((int)player.field_70163_u + 2), (double)((int)player.field_70161_v));
        if (!world.field_72995_K) {
            ArrayList<Entity> tnt = new ArrayList<Entity>();
            for (int i = 0; i < 5; ++i) {
                EntityTNTPrimed entitytntprimed = new EntityTNTPrimed(world, player.field_70165_t, player.field_70163_u + 1.0, player.field_70161_v, (EntityLivingBase)player);
                world.func_72838_d((Entity)entitytntprimed);
                world.func_184148_a(player, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187904_gd, SoundCategory.BLOCKS, 1.0f, 1.0f);
                entitytntprimed.func_184534_a(140);
                tnt.add((Entity)entitytntprimed);
            }
            this.inQuestion.put(player, new RewardInfo(num1 + num2, tnt, cache));
        }
        int duration = super.getSettingAsInt(settings, "ans_duration", 100, 20, 2400);
        Scheduler.scheduleTask(new Task("Math", duration, 20){

            @Override
            public void callback() {
                MathReward.this.timeUp(player, false);
            }

            @Override
            public void update() {
                if (this.delayLeft % 20 == 0) {
                    this.showTimeLeft(player, SPacketTitle.Type.ACTIONBAR);
                }
            }
        });
    }

    private void timeUp(EntityPlayer player, boolean correct) {
        if (!this.inQuestion.containsKey(player)) {
            return;
        }
        if (!RewardsUtil.isPlayerOnline(player)) {
            return;
        }
        RewardInfo info = this.inQuestion.get(player);
        if (correct) {
            player.func_145747_a((ITextComponent)new TextComponentString("Correct!"));
            player.func_145747_a((ITextComponent)new TextComponentString("Here, have a item!"));
            player.field_70170_p.func_72838_d((Entity)new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, new ItemStack(RewardsUtil.getRandomItem(), 1)));
        } else {
            player.field_70170_p.func_72876_a((Entity)player, player.field_70165_t, player.field_70163_u, player.field_70161_v, 1.0f, false);
            player.func_70097_a((DamageSource)CCubesDamageSource.MATH_FAIL, Float.MAX_VALUE);
        }
        for (Entity tnt : info.tnt) {
            tnt.func_70106_y();
        }
        info.cache.restoreBlocks((Entity)player);
        this.inQuestion.remove(player);
    }

    @SubscribeEvent
    public void onMessage(ServerChatEvent event) {
        EntityPlayerMP player = event.getPlayer();
        if (this.inQuestion.containsKey(player)) {
            int answer = 0;
            try {
                answer = Integer.parseInt(event.getMessage());
            }
            catch (NumberFormatException e) {
                player.func_145747_a((ITextComponent)new TextComponentString("Incorrect!"));
            }
            if (this.inQuestion.get((Object)player).answer == answer) {
                this.timeUp((EntityPlayer)player, true);
            } else {
                player.func_145747_a((ITextComponent)new TextComponentString("Incorrect!"));
            }
            event.setCanceled(true);
        }
    }

    private static class RewardInfo {
        public int answer;
        public List<Entity> tnt;
        public RewardBlockCache cache;

        public RewardInfo(int answer, List<Entity> tnt, RewardBlockCache cache) {
            this.answer = answer;
            this.tnt = tnt;
            this.cache = cache;
        }
    }
}

