/*
 * Decompiled with CFR 0.152.
 */
package uk.kihira.tails.common.network;

import com.google.common.reflect.TypeToken;
import com.google.gson.JsonSyntaxException;
import io.netty.buffer.ByteBuf;
import java.util.Map;
import java.util.UUID;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import uk.kihira.tails.common.PartsData;
import uk.kihira.tails.common.Tails;

public class PlayerDataMapMessage
implements IMessage {
    private Map<UUID, PartsData> partsDataMap;

    public PlayerDataMapMessage() {
    }

    public PlayerDataMapMessage(Map partsDataMap) {
        this.partsDataMap = partsDataMap;
    }

    public void fromBytes(ByteBuf buf) {
        String tailInfoJson = ByteBufUtils.readUTF8String((ByteBuf)buf);
        try {
            this.partsDataMap = (Map)Tails.gson.fromJson(tailInfoJson, new TypeToken<Map<UUID, PartsData>>(){}.getType());
        }
        catch (JsonSyntaxException e) {
            Tails.logger.catching((Throwable)e);
        }
    }

    public void toBytes(ByteBuf buf) {
        String tailInfoJson = Tails.gson.toJson(this.partsDataMap);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)tailInfoJson);
    }

    public static class Handler
    implements IMessageHandler<PlayerDataMapMessage, IMessage> {
        public IMessage onMessage(PlayerDataMapMessage message, MessageContext ctx) {
            for (Map.Entry entry : message.partsDataMap.entrySet()) {
                Tails.proxy.addPartsData((UUID)entry.getKey(), (PartsData)entry.getValue());
            }
            return null;
        }
    }
}

