/*
 * Decompiled with CFR 0.152.
 */
package com.awesomehippo.customfpsdisplay;

import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod(modid="customfpsdisplay", version="2.0")
public class CustomFpsDisplay {
    public static final String MODID = "customfpsdisplay";
    public static final String VERSION = "2.0";
    private static final KeyBinding OPEN_GUI_KEY = new KeyBinding("Toggle FPS Position GUI", 50, "key.categories.misc");
    private static int posX = 10;
    private static int posY = 10;
    private static boolean isGuiOpen = false;

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        ClientRegistry.registerKeyBinding((KeyBinding)OPEN_GUI_KEY);
    }

    @SubscribeEvent
    public void onRenderGameOverlay(RenderGameOverlayEvent.Text event) {
        Minecraft mc = Minecraft.func_71410_x();
        int fps = Minecraft.func_175610_ah();
        long time = System.currentTimeMillis() % 3000L;
        float hue = (float)time / 3000.0f;
        Color rgbColor = Color.getHSBColor(hue, 1.0f, 1.0f);
        String fpsText = "FPS: " + fps;
        int textWidth = mc.field_71466_p.func_78256_a(fpsText);
        int textHeight = 8;
        Gui.func_73734_a((int)(posX - 2), (int)(posY - 2), (int)(posX + textWidth + 2), (int)(posY + textHeight + 2), (int)-1879048192);
        mc.field_71466_p.func_175063_a(fpsText, (float)posX, (float)posY, rgbColor.getRGB());
        if (OPEN_GUI_KEY.func_151468_f() && !isGuiOpen) {
            mc.func_147108_a((GuiScreen)new FpsPositionGui());
            isGuiOpen = true;
        }
    }

    public static class FpsPositionGui
    extends GuiScreen {
        public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
            this.func_146276_q_();
            this.func_73732_a(this.field_146289_q, "Customize FPS Position", this.field_146294_l / 2, this.field_146295_m / 4, 0xFFFFFF);
            this.func_73732_a(this.field_146289_q, "Use Arrow Keys to Adjust Position", this.field_146294_l / 2, this.field_146295_m / 2 - 10, 0xFFFFFF);
            super.func_73863_a(mouseX, mouseY, partialTicks);
        }

        protected void func_73869_a(char typedChar, int keyCode) {
            if (keyCode == 200) {
                posY = posY - 5;
            } else if (keyCode == 208) {
                posY = posY + 5;
            } else if (keyCode == 203) {
                posX = posX - 5;
            } else if (keyCode == 205) {
                posX = posX + 5;
            } else if (keyCode == 1) {
                this.field_146297_k.func_147108_a(null);
                isGuiOpen = false;
            }
        }

        public boolean func_73868_f() {
            return false;
        }
    }
}

