/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc.client.renderer.font;

import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import li.cil.oc.OpenComputers;
import li.cil.oc.Settings;
import li.cil.oc.client.renderer.font.IGlyphProvider;
import li.cil.oc.util.FontUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.BufferUtils;

public class FontParserHex
implements IGlyphProvider {
    private static final byte[] OPAQUE = new byte[]{-1, -1, -1, -1};
    private static final byte[] TRANSPARENT = new byte[]{0, 0, 0, 0};
    private final TIntObjectMap<byte[]> glyphs = new TIntObjectHashMap();

    private static int hex2int(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 55;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 87;
        }
        throw new RuntimeException("invalid char: " + c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize() {
        try {
            this.glyphs.clear();
            OpenComputers.log().info("Loading Unicode glyphs...");
            long time = System.currentTimeMillis();
            int glyphCount = 0;
            ResourceLocation loc = new ResourceLocation(Settings.resourceDomain(), "font.hex");
            for (IResource resource : Minecraft.func_71410_x().func_110442_L().func_135056_b(loc)) {
                InputStream font = resource.func_110527_b();
                try {
                    String line;
                    BufferedReader input = new BufferedReader(new InputStreamReader(font));
                    while ((line = input.readLine()) != null) {
                        String info = line.substring(0, line.indexOf(58));
                        int charCode = Integer.parseInt(info, 16);
                        if (charCode < 0 || charCode >= FontUtils.codepoint_limit()) {
                            OpenComputers.log().warn(String.format("Unicode font contained unexpected glyph: U+%04X, ignoring", charCode));
                            continue;
                        }
                        int expectedWidth = FontUtils.wcwidth(charCode);
                        if (expectedWidth < 1) continue;
                        int glyphStrOfs = info.length() + 1;
                        byte[] glyph = new byte[line.length() - glyphStrOfs >> 1];
                        int glyphWidth = glyph.length / this.getGlyphHeight();
                        if (expectedWidth == glyphWidth) {
                            int i = 0;
                            while (i < glyph.length) {
                                glyph[i] = (byte)(FontParserHex.hex2int(line.charAt(glyphStrOfs)) << 4 | FontParserHex.hex2int(line.charAt(glyphStrOfs + 1)));
                                ++i;
                                glyphStrOfs += 2;
                            }
                            if (!this.glyphs.containsKey(charCode)) {
                                ++glyphCount;
                            }
                            this.glyphs.put(charCode, (Object)glyph);
                            continue;
                        }
                        if (!Settings.get().logHexFontErrors()) continue;
                        OpenComputers.log().warn(String.format("Size of glyph for code point U+%04X (%s) in font (%d) does not match expected width (%d), ignoring.", charCode, String.valueOf((char)charCode), glyphWidth, expectedWidth));
                    }
                }
                finally {
                    try {
                        font.close();
                    }
                    catch (IOException ex) {
                        OpenComputers.log().warn("Error parsing font.", (Throwable)ex);
                    }
                }
            }
            OpenComputers.log().info("Loaded " + glyphCount + " glyphs in " + (System.currentTimeMillis() - time) + " milliseconds.");
        }
        catch (IOException ex) {
            OpenComputers.log().warn("Failed loading glyphs.", (Throwable)ex);
        }
    }

    @Override
    public ByteBuffer getGlyph(int charCode) {
        if (!this.glyphs.containsKey(charCode)) {
            return null;
        }
        byte[] glyph = (byte[])this.glyphs.get(charCode);
        if (glyph == null || glyph.length == 0) {
            return null;
        }
        ByteBuffer buffer = BufferUtils.createByteBuffer((int)(glyph.length * this.getGlyphWidth() * 4));
        for (byte aGlyph : glyph) {
            int c = aGlyph & 0xFF;
            for (int j = 0; j < 8; ++j) {
                boolean isBitSet;
                boolean bl = isBitSet = (c & 0x80) > 0;
                if (isBitSet) {
                    buffer.put(OPAQUE);
                } else {
                    buffer.put(TRANSPARENT);
                }
                c <<= 1;
            }
        }
        buffer.rewind();
        return buffer;
    }

    @Override
    public int getGlyphWidth() {
        return 8;
    }

    @Override
    public int getGlyphHeight() {
        return 16;
    }
}

