/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.resources.loader;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import mod.lucky.Lucky;
import mod.lucky.resources.BaseResource;
import mod.lucky.resources.loader.BaseLoader;

public class DefaultLoader
extends BaseLoader {
    private File resourceDir;

    public DefaultLoader(File minecraftDirectory) {
        this.resourceDir = new File(minecraftDirectory.getPath() + "/config/lucky_block/version-" + "7.6.0");
        Lucky.getInstance();
        Lucky.getInstance();
        Lucky.getInstance();
        Lucky.getInstance();
        this.setLuckyBlockItems(Lucky.lucky_block, Lucky.lucky_sword, Lucky.lucky_bow, Lucky.lucky_potion);
    }

    public void extractDefaultResources() {
        try {
            ZipEntry entry;
            InputStream stream = Lucky.class.getResourceAsStream("default_config.zip");
            ZipInputStream inputStream = new ZipInputStream(stream);
            while ((entry = inputStream.getNextEntry()) != null) {
                int data;
                FileOutputStream outputStream = null;
                File dest = new File(this.resourceDir.getPath() + "/" + entry.getName());
                if (!entry.isDirectory() && !dest.exists()) {
                    if (!dest.getParentFile().exists()) {
                        dest.getParentFile().mkdirs();
                    }
                    dest.createNewFile();
                    outputStream = new FileOutputStream(dest);
                }
                while ((data = inputStream.read()) != -1) {
                    if (outputStream == null) continue;
                    outputStream.write(data);
                }
                if (outputStream == null) continue;
                outputStream.close();
            }
            inputStream.close();
        }
        catch (Exception e) {
            System.err.println("Lucky Block: Error extracting default resources");
            e.printStackTrace();
        }
    }

    public File getFile(BaseResource resource) {
        File defaultFile = new File(this.resourceDir.getPath() + "/" + resource.getDirectory());
        return defaultFile;
    }

    @Override
    public InputStream getResourceStream(BaseResource resource) {
        try {
            File file = this.getFile(resource);
            if (file.isDirectory()) {
                return null;
            }
            return new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            System.err.println("Lucky Block: Error getting default resource '" + resource.getDirectory() + "'");
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void loadResource(BaseResource resource) {
        super.loadResource(resource);
    }

    public File getResourceDir() {
        return this.resourceDir;
    }
}

