/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.device.util;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.jab125.version.Version;
import com.jab125.version.VersionPredicate;
import com.mrcrayfish.device.MrCrayfishDeviceMod;
import com.mrcrayfish.device.api.ApplicationManager;
import com.mrcrayfish.device.api.app.Icons;
import com.mrcrayfish.device.core.Laptop;
import com.mrcrayfish.device.object.AppInfo;
import com.mrcrayfish.device.object.TrayItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;

public final class Vulnerability {
    @Nullable
    private final String reporter;
    private final String title;
    @Nullable
    private final String description;
    private final int severity;
    private final Collection<VersionPredicate> affectedVersions;
    private final Collection<VersionPredicate> fixVersion;
    private final boolean affectsCurrentVersion;

    public Vulnerability(@Nullable String reporter, String title, @Nullable String description, int severity, Collection<VersionPredicate> affectedVersions, Collection<VersionPredicate> fixVersion, boolean affectsCurrentVersion) {
        this.reporter = reporter;
        this.title = title;
        this.description = description;
        this.severity = severity;
        this.affectedVersions = affectedVersions;
        this.fixVersion = fixVersion;
        this.affectsCurrentVersion = affectsCurrentVersion;
    }

    public static List<Vulnerability> parseArray(JsonArray array) {
        ArrayList<Vulnerability> arraylist = new ArrayList<Vulnerability>(){

            @Override
            public boolean add(@Nullable Vulnerability vulnerability) {
                if (vulnerability != null) {
                    return super.add(vulnerability);
                }
                return false;
            }
        };
        for (JsonElement jsonElement : array) {
            if (!jsonElement.isJsonObject()) continue;
            arraylist.add(Vulnerability.parseObject(jsonElement.getAsJsonObject()));
        }
        return ImmutableList.copyOf((Collection)arraylist);
    }

    public static Vulnerability parseObject(JsonObject array) {
        boolean hasReporter = array.has("reporter");
        boolean hasDescription = array.has("description");
        boolean hasFixVersion = array.has("fixVersions");
        Collection<VersionPredicate> affectedVersions = Vulnerability.toStringList(array.getAsJsonArray("affectedVersions"));
        boolean d = false;
        for (VersionPredicate affectedVersion : affectedVersions) {
            try {
                d = affectedVersion.test(Version.parse("0.4.4"));
                if (!d) continue;
                break;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return new Vulnerability(hasReporter ? array.get("reporter").getAsString() : null, array.get("title").getAsString(), hasDescription ? array.get("description").getAsString() : null, array.get("severity").getAsInt(), affectedVersions, !hasFixVersion ? new ArrayList() : Vulnerability.toStringList(array.get("fixVersions").getAsJsonArray()), d);
    }

    private static Collection<VersionPredicate> toStringList(JsonArray array) {
        ArrayList<String> l = new ArrayList<String>();
        for (JsonElement jsonElement : array) {
            l.add(jsonElement.getAsString());
        }
        try {
            return VersionPredicate.parse(l);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<VersionPredicate>();
        }
    }

    public String toString() {
        return "Vulnerability{reporter='" + this.reporter + '\'' + ", title='" + this.title + '\'' + ", description='" + this.description + '\'' + ", severity=" + this.severity + ", affectedVersions=" + this.affectedVersions + ", fixVersion='" + this.fixVersion + '\'' + '}';
    }

    public int effectiveSeverity() {
        return this.affectsCurrentVersion ? this.severity : 0;
    }

    @Nullable
    public String reporter() {
        return this.reporter;
    }

    public String title() {
        return this.title;
    }

    @Nullable
    public String description() {
        return this.description;
    }

    public int severity() {
        return this.severity;
    }

    public Collection<VersionPredicate> affectedVersions() {
        return this.affectedVersions;
    }

    public Collection<VersionPredicate> fixVersion() {
        return this.fixVersion;
    }

    public boolean affectsCurrentVersion() {
        return this.affectsCurrentVersion;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Vulnerability that = (Vulnerability)obj;
        return Objects.equals(this.reporter, that.reporter) && Objects.equals(this.title, that.title) && Objects.equals(this.description, that.description) && this.severity == that.severity && Objects.equals(this.affectedVersions, that.affectedVersions) && Objects.equals(this.fixVersion, that.fixVersion) && this.affectsCurrentVersion == that.affectsCurrentVersion;
    }

    public int hashCode() {
        return Objects.hash(this.reporter, this.title, this.description, this.severity, this.affectedVersions, this.fixVersion, this.affectsCurrentVersion);
    }

    public static class VulnerabilityTrayItem
    extends TrayItem {
        private final boolean vulnerabilities = VulnerabilityTrayItem.vulnerabilitiesAffectUs();
        private int tick;
        private boolean stat = false;

        public VulnerabilityTrayItem() {
            super(VulnerabilityTrayItem.vulnerabilitiesAffectUs() ? Icons.WARNING : Icons.WARNING_GRAY);
        }

        private static boolean vulnerabilitiesAffectUs() {
            return MrCrayfishDeviceMod.getVulnerabilities().stream().anyMatch(Vulnerability::affectsCurrentVersion);
        }

        @Override
        public void tick() {
            super.tick();
            if (!this.vulnerabilities) {
                return;
            }
            if (this.tick >= 15) {
                this.tick = 0;
                this.setIcon(this.stat ? Icons.FLASHED_WARNING : Icons.WARNING);
                this.stat = !this.stat;
            }
            ++this.tick;
        }

        @Override
        public void handleClick(int mouseX, int mouseY, int mouseButton) {
            AppInfo info = ApplicationManager.getApplication(String.valueOf(new ResourceLocation("cdm", "vulnerability")));
            if (info != null) {
                Laptop.getSystem().openApplication(info);
            }
        }
    }
}

