/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.device.programs.gitweb.component.container;

import com.mrcrayfish.device.api.app.Component;
import com.mrcrayfish.device.api.utils.RenderUtil;
import com.mrcrayfish.device.core.Laptop;
import com.mrcrayfish.device.util.GuiHelper;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.config.GuiUtils;

public abstract class ContainerBox
extends Component {
    protected static final ResourceLocation CONTAINER_BOXES_TEXTURE = new ResourceLocation("cdm", "textures/gui/container_boxes.png");
    public static final int WIDTH = 128;
    protected List<Slot> slots = new ArrayList<Slot>();
    protected int boxU;
    protected int boxV;
    protected int height;
    protected ItemStack icon;
    protected String title;

    public ContainerBox(int left, int top, int boxU, int boxV, int height, ItemStack icon, String title) {
        super(left, top);
        this.boxU = boxU;
        this.boxV = boxV;
        this.height = height;
        this.icon = icon;
        this.title = title;
    }

    @Override
    protected void render(Laptop laptop, Minecraft mc, int x, int y, int mouseX, int mouseY, boolean windowActive, float partialTicks) {
        mc.func_110434_K().func_110577_a(CONTAINER_BOXES_TEXTURE);
        RenderUtil.drawRectWithTexture(x, y + 12, this.boxU, this.boxV, 128, this.height, 128.0f, this.height, 256, 256);
        int contentOffset = (128 - (Laptop.fontRenderer.func_78256_a(this.title) + 8 + 4)) / 2;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)(x + contentOffset), (float)y, (float)0.0f);
        GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)0.5);
        RenderUtil.renderItem(0, 0, this.icon, false);
        GlStateManager.func_179121_F();
        RenderUtil.drawStringClipped(this.title, x + contentOffset + 8 + 4, y, 110, Color.WHITE.getRGB(), true);
        this.slots.forEach(slot -> slot.render(x, y + 12));
    }

    @Override
    protected void renderOverlay(Laptop laptop, Minecraft mc, int mouseX, int mouseY, boolean windowActive) {
        this.slots.forEach(slot -> slot.renderOverlay(laptop, this.xPosition, this.yPosition + 12, mouseX, mouseY));
    }

    protected class Slot {
        private int slotX;
        private int slotY;
        private ItemStack stack;

        public Slot(int slotX, int slotY, ItemStack stack) {
            this.slotX = slotX;
            this.slotY = slotY;
            this.stack = stack;
        }

        public void render(int x, int y) {
            RenderUtil.renderItem(x + this.slotX, y + this.slotY, this.stack, true);
        }

        public void renderOverlay(Laptop laptop, int x, int y, int mouseX, int mouseY) {
            if (GuiHelper.isMouseWithin(mouseX, mouseY, x + this.slotX, y + this.slotY, 16, 16) && !this.stack.func_190926_b()) {
                GuiUtils.preItemToolTip((ItemStack)this.stack);
                laptop.func_146283_a(laptop.func_191927_a(this.stack), mouseX, mouseY);
                GuiUtils.postItemToolTip();
            }
            GlStateManager.func_179101_C();
            RenderHelper.func_74518_a();
            GlStateManager.func_179097_i();
        }

        public ItemStack getStack() {
            return this.stack;
        }
    }
}

