/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.device.programs;

import com.mrcrayfish.device.api.app.Application;
import com.mrcrayfish.device.api.app.Dialog;
import com.mrcrayfish.device.api.app.Layout;
import com.mrcrayfish.device.api.app.component.Button;
import com.mrcrayfish.device.api.app.component.ItemList;
import com.mrcrayfish.device.api.app.component.Label;
import com.mrcrayfish.device.api.app.component.Text;
import com.mrcrayfish.device.api.app.component.TextArea;
import com.mrcrayfish.device.api.app.component.TextField;
import com.mrcrayfish.device.api.io.File;
import com.mrcrayfish.device.core.io.FileSystem;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;

public class ApplicationNoteStash
extends Application {
    private static final Predicate<File> PREDICATE_FILE_NOTE = file -> !file.isFolder() && file.getData().func_150297_b("title", 8) && file.getData().func_150297_b("content", 8);
    private Layout layoutMain;
    private ItemList<Note> notes;
    private Button btnNew;
    private Button btnView;
    private Button btnDelete;
    private Layout layoutAddNote;
    private TextField title;
    private TextArea textArea;
    private Button btnSave;
    private Button btnCancel;
    private Layout layoutViewNote;
    private Label noteTitle;
    private Text noteContent;
    private Button btnBack;

    @Override
    public void init(@Nullable NBTTagCompound intent) {
        this.layoutMain = new Layout(180, 80);
        this.layoutMain.setInitListener(() -> {
            this.notes.getItems().clear();
            FileSystem.getApplicationFolder(this, (folder, success) -> {
                if (success) {
                    folder.search(file -> file.isForApplication(this)).forEach(file -> this.notes.addItem(Note.fromFile(file)));
                }
            });
        });
        this.notes = new ItemList(5, 5, 100, 5);
        this.notes.setItemClickListener((e, index, mouseButton) -> {
            this.btnView.setEnabled(true);
            this.btnDelete.setEnabled(true);
        });
        this.layoutMain.addComponent(this.notes);
        this.btnNew = new Button(124, 5, "New");
        this.btnNew.setSize(50, 20);
        this.btnNew.setClickListener((mouseX, mouseY, mouseButton) -> this.setCurrentLayout(this.layoutAddNote));
        this.layoutMain.addComponent(this.btnNew);
        this.btnView = new Button(124, 30, "View");
        this.btnView.setSize(50, 20);
        this.btnView.setEnabled(false);
        this.btnView.setClickListener((mouseX, mouseY, mouseButton) -> {
            if (this.notes.getSelectedIndex() != -1) {
                Note note = this.notes.getSelectedItem();
                this.noteTitle.setText(note.getTitle());
                this.noteContent.setText(note.getContent());
                this.setCurrentLayout(this.layoutViewNote);
            }
        });
        this.layoutMain.addComponent(this.btnView);
        this.btnDelete = new Button(124, 55, "Delete");
        this.btnDelete.setSize(50, 20);
        this.btnDelete.setEnabled(false);
        this.btnDelete.setClickListener((mouseX, mouseY, mouseButton) -> {
            Note note;
            File file;
            if (this.notes.getSelectedIndex() != -1 && this.notes.getSelectedIndex() != -1 && (file = (note = this.notes.getSelectedItem()).getSource()) != null) {
                file.delete((o, success) -> {
                    if (success) {
                        this.notes.removeItem(this.notes.getSelectedIndex());
                        this.btnView.setEnabled(false);
                        this.btnDelete.setEnabled(false);
                    }
                });
            }
        });
        this.layoutMain.addComponent(this.btnDelete);
        this.layoutAddNote = new Layout(180, 80);
        this.title = new TextField(5, 5, 114);
        this.layoutAddNote.addComponent(this.title);
        this.textArea = new TextArea(5, 25, 114, 50);
        this.textArea.setFocused(true);
        this.textArea.setPadding(2);
        this.layoutAddNote.addComponent(this.textArea);
        this.btnSave = new Button(124, 5, "Save");
        this.btnSave.setSize(50, 20);
        this.btnSave.setClickListener((mouseX, mouseY, mouseButton) -> {
            NBTTagCompound data = new NBTTagCompound();
            data.func_74778_a("title", this.title.getText());
            data.func_74778_a("content", this.textArea.getText());
            Dialog.SaveFile dialog = new Dialog.SaveFile((Application)this, data);
            dialog.setFolder(this.getApplicationFolderPath());
            dialog.setResponseHandler((success, file) -> {
                this.title.clear();
                this.textArea.clear();
                this.setCurrentLayout(this.layoutMain);
                return true;
            });
            this.openDialog(dialog);
        });
        this.layoutAddNote.addComponent(this.btnSave);
        this.btnCancel = new Button(124, 30, "Cancel");
        this.btnCancel.setSize(50, 20);
        this.btnCancel.setClickListener((mouseX, mouseY, mouseButton) -> {
            this.title.clear();
            this.textArea.clear();
            this.setCurrentLayout(this.layoutMain);
        });
        this.layoutAddNote.addComponent(this.btnCancel);
        this.layoutViewNote = new Layout(180, 80);
        this.noteTitle = new Label("", 5, 5);
        this.layoutViewNote.addComponent(this.noteTitle);
        this.noteContent = new Text("", 5, 18, 110);
        this.layoutViewNote.addComponent(this.noteContent);
        this.btnBack = new Button(124, 5, "Back");
        this.btnBack.setSize(50, 20);
        this.btnBack.setClickListener((mouseX, mouseY, mouseButton) -> this.setCurrentLayout(this.layoutMain));
        this.layoutViewNote.addComponent(this.btnBack);
        this.setCurrentLayout(this.layoutMain);
    }

    @Override
    public void load(NBTTagCompound tagCompound) {
    }

    @Override
    public void save(NBTTagCompound tagCompound) {
    }

    @Override
    public void onClose() {
        super.onClose();
        this.notes.removeAll();
    }

    @Override
    public boolean handleFile(File file) {
        if (!PREDICATE_FILE_NOTE.test(file)) {
            return false;
        }
        NBTTagCompound data = file.getData();
        this.noteTitle.setText(data.func_74779_i("title"));
        this.noteContent.setText(data.func_74779_i("content"));
        this.setCurrentLayout(this.layoutViewNote);
        return true;
    }

    private static class Note {
        private File source;
        private String title;
        private String content;

        public Note(String title, String content) {
            this.title = title;
            this.content = content;
        }

        public File getSource() {
            return this.source;
        }

        public String getTitle() {
            return this.title;
        }

        public String getContent() {
            return this.content;
        }

        public String toString() {
            return this.title;
        }

        public static Note fromFile(File file) {
            Note note = new Note(file.getData().func_74779_i("title"), file.getData().func_74779_i("content"));
            note.source = file;
            return note;
        }
    }
}

