/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.device.object;

import com.mrcrayfish.device.api.app.Component;
import com.mrcrayfish.device.api.app.component.Slider;
import com.mrcrayfish.device.core.Laptop;
import com.mrcrayfish.device.object.Canvas;
import com.mrcrayfish.device.util.GuiHelper;
import java.awt.Color;
import net.minecraft.client.Minecraft;

public class ColorGrid
extends Component {
    private static Color[] colors = new Color[]{Color.BLACK, Color.GRAY, Color.LIGHT_GRAY, Color.WHITE, Color.RED, Color.ORANGE, Color.YELLOW, Color.GREEN, new Color(0, 150, 0), new Color(0, 255, 255), new Color(0, 148, 255), Color.BLUE, new Color(72, 0, 255), Color.MAGENTA, new Color(255, 0, 110)};
    private int hoverColor = new Color(255, 255, 255, 100).getRGB();
    private Canvas canvas;
    private Slider redSlider;
    private Slider greenSlider;
    private Slider blueSlider;
    private int width;

    public ColorGrid(int left, int top, int width, Canvas canvas, Slider redSlider, Slider greenSlider, Slider blueSlider) {
        super(left, top);
        this.width = width;
        this.canvas = canvas;
        this.redSlider = redSlider;
        this.greenSlider = greenSlider;
        this.blueSlider = blueSlider;
    }

    @Override
    public void render(Laptop laptop, Minecraft mc, int x, int y, int mouseX, int mouseY, boolean windowActive, float partialTicks) {
        int endX = this.xPosition + this.width + 2;
        int endY = this.yPosition + colors.length / 5 * 10 + 2;
        ColorGrid.func_73734_a((int)this.xPosition, (int)this.yPosition, (int)endX, (int)endY, (int)Color.DARK_GRAY.getRGB());
        for (int i = 0; i < colors.length; ++i) {
            int startX = this.xPosition + i % 5 * 10 + 1;
            int startY = this.yPosition + i / 5 * 10 + 1;
            ColorGrid.func_73734_a((int)startX, (int)startY, (int)(startX + 10), (int)(startY + 10), (int)colors[i].getRGB());
        }
        if (GuiHelper.isMouseInside(mouseX, mouseY, this.xPosition + 1, this.yPosition + 1, endX - 2, endY - 2)) {
            int boxX = (mouseX - this.xPosition - 1) / 10;
            int boxY = (mouseY - this.yPosition - 1) / 10;
            ColorGrid.func_73734_a((int)(this.xPosition + boxX * 10 + 1), (int)(this.yPosition + boxY * 10 + 1), (int)(this.xPosition + boxX * 10 + 11), (int)(this.yPosition + boxY * 10 + 11), (int)this.hoverColor);
        }
    }

    @Override
    public void handleMouseClick(int mouseX, int mouseY, int mouseButton) {
        int endX = this.xPosition + this.width + 2;
        int endY = this.yPosition + colors.length / 5 * 10 + 2;
        if (GuiHelper.isMouseInside(mouseX, mouseY, this.xPosition + 1, this.yPosition + 1, endX - 2, endY - 2)) {
            int boxX = (mouseX - this.xPosition - 1) / 10;
            int boxY = (mouseY - this.yPosition - 1) / 10;
            int index = boxX + boxY * 5;
            this.redSlider.setPercentage((float)colors[index].getRed() / 255.0f);
            this.greenSlider.setPercentage((float)colors[index].getGreen() / 255.0f);
            this.blueSlider.setPercentage((float)colors[index].getBlue() / 255.0f);
            this.canvas.setRed(this.redSlider.getPercentage());
            this.canvas.setGreen(this.greenSlider.getPercentage());
            this.canvas.setBlue(this.blueSlider.getPercentage());
        }
    }
}

