/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.device.core.print.task;

import com.mrcrayfish.device.api.print.IPrint;
import com.mrcrayfish.device.api.task.Task;
import com.mrcrayfish.device.core.network.NetworkDevice;
import com.mrcrayfish.device.core.network.Router;
import com.mrcrayfish.device.tileentity.TileEntityNetworkDevice;
import com.mrcrayfish.device.tileentity.TileEntityPrinter;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TaskPrint
extends Task {
    private BlockPos devicePos;
    private UUID printerId;
    private IPrint print;

    private TaskPrint() {
        super("print");
    }

    public TaskPrint(BlockPos devicePos, NetworkDevice printer, IPrint print) {
        this();
        this.devicePos = devicePos;
        this.printerId = printer.getId();
        this.print = print;
    }

    @Override
    public void prepareRequest(NBTTagCompound nbt) {
        nbt.func_74772_a("devicePos", this.devicePos.func_177986_g());
        nbt.func_186854_a("printerId", this.printerId);
        nbt.func_74782_a("print", (NBTBase)IPrint.writeToTag(this.print));
    }

    @Override
    public void processRequest(NBTTagCompound nbt, World world, EntityPlayer player) {
        TileEntityNetworkDevice printer;
        TileEntityNetworkDevice device;
        Router router;
        TileEntity tileEntity = world.func_175625_s(BlockPos.func_177969_a((long)nbt.func_74763_f("devicePos")));
        if (tileEntity instanceof TileEntityNetworkDevice && (router = (device = (TileEntityNetworkDevice)tileEntity).getRouter()) != null && (printer = router.getDevice(world, nbt.func_186857_a("printerId"))) != null && printer instanceof TileEntityPrinter) {
            IPrint print = IPrint.loadFromTag(nbt.func_74775_l("print"));
            ((TileEntityPrinter)printer).addToQueue(print);
            this.setSuccessful();
        }
    }

    @Override
    public void prepareResponse(NBTTagCompound nbt) {
    }

    @Override
    public void processResponse(NBTTagCompound nbt) {
    }
}

