/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.device.core.network;

import com.mrcrayfish.device.DeviceConfig;
import com.mrcrayfish.device.api.app.Icons;
import com.mrcrayfish.device.api.app.Layout;
import com.mrcrayfish.device.api.app.component.Button;
import com.mrcrayfish.device.api.app.component.ItemList;
import com.mrcrayfish.device.api.app.renderer.ListItemRenderer;
import com.mrcrayfish.device.api.task.TaskManager;
import com.mrcrayfish.device.api.utils.RenderUtil;
import com.mrcrayfish.device.core.Device;
import com.mrcrayfish.device.core.Laptop;
import com.mrcrayfish.device.core.network.task.TaskConnect;
import com.mrcrayfish.device.core.network.task.TaskPing;
import com.mrcrayfish.device.object.TrayItem;
import com.mrcrayfish.device.tileentity.TileEntityDevice;
import com.mrcrayfish.device.tileentity.TileEntityRouter;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;

public class TrayItemWifi
extends TrayItem {
    private int pingTimer;

    public TrayItemWifi() {
        super(Icons.WIFI_NONE);
    }

    @Override
    public void init() {
        this.setClickListener((mouseX, mouseY, mouseButton) -> {
            if (Laptop.getSystem().hasContext()) {
                Laptop.getSystem().closeContext();
            } else {
                Laptop.getSystem().openContext(TrayItemWifi.createWifiMenu(this), mouseX - 100, mouseY - 100);
            }
        });
        this.runPingTask();
    }

    @Override
    public void tick() {
        if (++this.pingTimer >= DeviceConfig.getPingRate()) {
            this.runPingTask();
            this.pingTimer = 0;
        }
    }

    private void runPingTask() {
        TaskPing task = new TaskPing(Laptop.getPos());
        task.setCallback((tagCompound, success) -> {
            if (success) {
                int strength = tagCompound.func_74762_e("strength");
                switch (strength) {
                    case 2: {
                        this.setIcon(Icons.WIFI_LOW);
                        break;
                    }
                    case 1: {
                        this.setIcon(Icons.WIFI_MED);
                        break;
                    }
                    case 0: {
                        this.setIcon(Icons.WIFI_HIGH);
                        break;
                    }
                    default: {
                        this.setIcon(Icons.WIFI_NONE);
                        break;
                    }
                }
            } else {
                this.setIcon(Icons.WIFI_NONE);
            }
        });
        TaskManager.sendTask(task);
    }

    private static Layout createWifiMenu(TrayItem item) {
        Layout.Context layout = new Layout.Context(100, 100);
        layout.setBackground((gui, mc, x, y, width, height, mouseX, mouseY, windowActive) -> Gui.func_73734_a((int)x, (int)y, (int)(x + width), (int)(y + height), (int)new Color(0.65f, 0.65f, 0.65f, 0.9f).getRGB()));
        ItemList<Device> itemListRouters = new ItemList<Device>(5, 5, 90, 4);
        itemListRouters.setItems(TrayItemWifi.getRouters());
        itemListRouters.setListItemRenderer(new ListItemRenderer<Device>(16){

            @Override
            public void render(Device device, Gui gui, Minecraft mc, int x, int y, int width, int height, boolean selected) {
                Gui.func_73734_a((int)x, (int)y, (int)(x + width), (int)(y + height), (int)(selected ? Color.DARK_GRAY.getRGB() : Color.GRAY.getRGB()));
                RenderUtil.drawStringClipped(device.getName(), x + 16, y + 4, 70, Color.WHITE.getRGB(), false);
                if (device.getPos() == null) {
                    return;
                }
                BlockPos laptopPos = Laptop.getPos();
                double distance = Math.sqrt(device.getPos().func_177957_d((double)laptopPos.func_177958_n() + 0.5, (double)laptopPos.func_177956_o() + 0.5, (double)laptopPos.func_177952_p() + 0.5));
                if (distance > 20.0) {
                    Icons.WIFI_LOW.draw(mc, x + 3, y + 3);
                } else if (distance > 10.0) {
                    Icons.WIFI_MED.draw(mc, x + 3, y + 3);
                } else {
                    Icons.WIFI_HIGH.draw(mc, x + 3, y + 3);
                }
            }
        });
        itemListRouters.sortBy((o1, o2) -> {
            double distance2;
            BlockPos laptopPos = Laptop.getPos();
            double distance1 = Math.sqrt(o1.getPos().func_177957_d((double)laptopPos.func_177958_n() + 0.5, (double)laptopPos.func_177956_o() + 0.5, (double)laptopPos.func_177952_p() + 0.5));
            return distance1 == (distance2 = Math.sqrt(o2.getPos().func_177957_d((double)laptopPos.func_177958_n() + 0.5, (double)laptopPos.func_177956_o() + 0.5, (double)laptopPos.func_177952_p() + 0.5))) ? 0 : (distance1 > distance2 ? 1 : -1);
        });
        layout.addComponent(itemListRouters);
        Button buttonConnect = new Button(79, 79, Icons.CHECK);
        buttonConnect.setClickListener((mouseX, mouseY, mouseButton) -> {
            if (mouseButton == 0 && itemListRouters.getSelectedItem() != null) {
                TaskConnect connect = new TaskConnect(Laptop.getPos(), ((Device)itemListRouters.getSelectedItem()).getPos());
                connect.setCallback((tagCompound, success) -> {
                    if (success) {
                        item.setIcon(Icons.WIFI_HIGH);
                        Laptop.getSystem().closeContext();
                    }
                });
                TaskManager.sendTask(connect);
            }
        });
        layout.addComponent(buttonConnect);
        return layout;
    }

    private static List<Device> getRouters() {
        ArrayList<Device> routers = new ArrayList<Device>();
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        BlockPos laptopPos = Laptop.getPos();
        int range = DeviceConfig.getSignalRange();
        for (int y = -range; y < range + 1; ++y) {
            for (int z = -range; z < range + 1; ++z) {
                for (int x = -range; x < range + 1; ++x) {
                    BlockPos pos = new BlockPos(laptopPos.func_177958_n() + x, laptopPos.func_177956_o() + y, laptopPos.func_177952_p() + z);
                    TileEntity tileEntity = world.func_175625_s(pos);
                    if (!(tileEntity instanceof TileEntityRouter)) continue;
                    routers.add(new Device((TileEntityDevice)tileEntity));
                }
            }
        }
        return routers;
    }
}

