/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.device.core.network;

import com.mrcrayfish.device.core.network.Router;
import com.mrcrayfish.device.tileentity.TileEntityNetworkDevice;
import com.mrcrayfish.device.tileentity.TileEntityRouter;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class Connection {
    private UUID routerId;
    private BlockPos routerPos;

    private Connection() {
    }

    public Connection(Router router) {
        this.routerId = router.getId();
        this.routerPos = router.getPos();
    }

    public UUID getRouterId() {
        return this.routerId;
    }

    @Nullable
    public BlockPos getRouterPos() {
        return this.routerPos;
    }

    public void setRouterPos(BlockPos routerPos) {
        this.routerPos = routerPos;
    }

    @Nullable
    public Router getRouter(World world) {
        TileEntityRouter router;
        if (this.routerPos == null) {
            return null;
        }
        TileEntity tileEntity = world.func_175625_s(this.routerPos);
        if (tileEntity instanceof TileEntityRouter && (router = (TileEntityRouter)tileEntity).getRouter().getId().equals(this.routerId)) {
            return router.getRouter();
        }
        return null;
    }

    public boolean isConnected() {
        return this.routerPos != null;
    }

    public NBTTagCompound toTag() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("id", this.routerId.toString());
        return tag;
    }

    public static Connection fromTag(TileEntityNetworkDevice device, NBTTagCompound tag) {
        Connection connection = new Connection();
        connection.routerId = UUID.fromString(tag.func_74779_i("id"));
        return connection;
    }
}

