/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.device.core;

import com.mrcrayfish.device.api.app.Application;
import com.mrcrayfish.device.api.app.Dialog;
import com.mrcrayfish.device.api.utils.RenderUtil;
import com.mrcrayfish.device.core.Laptop;
import com.mrcrayfish.device.core.Wrappable;
import com.mrcrayfish.device.gui.GuiButtonClose;
import java.awt.Color;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class Window<T extends Wrappable> {
    public static final ResourceLocation WINDOW_GUI = new ResourceLocation("cdm:textures/gui/application.png");
    public static final int Color_WINDOW_DARK = new Color(0.0f, 0.0f, 0.0f, 0.25f).getRGB();
    T content;
    int width;
    int height;
    int offsetX;
    int offsetY;
    final Laptop laptop;
    Window<Dialog> dialogWindow = null;
    Window<? extends Wrappable> parent = null;
    protected GuiButton btnClose;

    public Window(T wrappable, Laptop laptop) {
        this.content = wrappable;
        this.laptop = laptop;
        ((Wrappable)wrappable).setWindow(this);
    }

    void setWidth(int width) {
        this.width = width + 2;
        if (this.width > 364) {
            this.width = 364;
        }
    }

    void setHeight(int height) {
        this.height = height + 14;
        if (this.height > 178) {
            this.height = 178;
        }
    }

    void init(int x, int y, @Nullable NBTTagCompound intent) {
        this.btnClose = new GuiButtonClose(0, x + this.offsetX + this.width - 12, y + this.offsetY + 1);
        ((Wrappable)this.content).init(intent);
    }

    public void onTick() {
        if (this.dialogWindow != null) {
            this.dialogWindow.onTick();
        }
        ((Wrappable)this.content).onTick();
    }

    public void render(Laptop gui, Minecraft mc, int x, int y, int mouseX, int mouseY, boolean active, float partialTicks) {
        if (((Wrappable)this.content).isPendingLayoutUpdate()) {
            this.setWidth(((Wrappable)this.content).getWidth());
            this.setHeight(((Wrappable)this.content).getHeight());
            this.offsetX = (364 - this.width) / 2;
            this.offsetY = (178 - this.height) / 2;
            this.updateComponents(x, y);
            ((Wrappable)this.content).clearPendingLayout();
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179147_l();
        mc.func_110434_K().func_110577_a(WINDOW_GUI);
        gui.func_73729_b(x + this.offsetX, y + this.offsetY, 0, 0, 1, 13);
        gui.func_73729_b(x + this.offsetX + this.width - 13, y + this.offsetY, 2, 0, 13, 13);
        gui.func_73729_b(x + this.offsetX + this.width - 1, y + this.offsetY + this.height - 1, 14, 14, 1, 1);
        gui.func_73729_b(x + this.offsetX, y + this.offsetY + this.height - 1, 0, 14, 1, 1);
        RenderUtil.drawRectWithTexture(x + this.offsetX + 1, y + this.offsetY, 1.0f, 0.0f, this.width - 14, 13, 1.0f, 13.0f);
        RenderUtil.drawRectWithTexture(x + this.offsetX + this.width - 1, y + this.offsetY + 13, 14.0f, 13.0f, 1, this.height - 14, 1.0f, 1.0f);
        RenderUtil.drawRectWithTexture(x + this.offsetX + 1, y + this.offsetY + this.height - 1, 1.0f, 14.0f, this.width - 2, 1, 13.0f, 1.0f);
        RenderUtil.drawRectWithTexture(x + this.offsetX, y + this.offsetY + 13, 0.0f, 13.0f, 1, this.height - 14, 1.0f, 1.0f);
        RenderUtil.drawRectWithTexture(x + this.offsetX + 1, y + this.offsetY + 13, 1.0f, 13.0f, this.width - 2, this.height - 14, 13.0f, 1.0f);
        String windowTitle = ((Wrappable)this.content).getWindowTitle();
        if (mc.field_71466_p.func_78256_a(windowTitle) > this.width - 2 - 13 - 3) {
            windowTitle = mc.field_71466_p.func_78269_a(windowTitle, this.width - 2 - 13 - 3);
        }
        mc.field_71466_p.func_175065_a(windowTitle, (float)(x + this.offsetX + 3), (float)(y + this.offsetY + 3), Color.WHITE.getRGB(), true);
        this.btnClose.func_191745_a(mc, mouseX, mouseY, partialTicks);
        GlStateManager.func_179084_k();
        ((Wrappable)this.content).render(gui, mc, x + this.offsetX + 1, y + this.offsetY + 13, mouseX, mouseY, active && this.dialogWindow == null, partialTicks);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.dialogWindow != null) {
            Gui.func_73734_a((int)(x + this.offsetX), (int)(y + this.offsetY), (int)(x + this.offsetX + this.width), (int)(y + this.offsetY + this.height), (int)Color_WINDOW_DARK);
            this.dialogWindow.render(gui, mc, x, y, mouseX, mouseY, active, partialTicks);
        }
    }

    public void handleKeyTyped(char character, int code) {
        if (this.dialogWindow != null) {
            this.dialogWindow.handleKeyTyped(character, code);
            return;
        }
        ((Wrappable)this.content).handleKeyTyped(character, code);
    }

    public void handleKeyReleased(char character, int code) {
        if (this.dialogWindow != null) {
            this.dialogWindow.handleKeyReleased(character, code);
            return;
        }
        ((Wrappable)this.content).handleKeyReleased(character, code);
    }

    public void handleWindowMove(int screenStartX, int screenStartY, int mouseDX, int mouseDY) {
        int newX = this.offsetX + mouseDX;
        int newY = this.offsetY + mouseDY;
        this.offsetX = newX >= 0 && newX <= 364 - this.width ? newX : (newX < 0 ? 0 : 364 - this.width);
        this.offsetY = newY >= 0 && newY <= 178 - this.height ? newY : (newY < 0 ? 0 : 178 - this.height);
        this.updateComponents(screenStartX, screenStartY);
    }

    void handleMouseClick(Laptop gui, int x, int y, int mouseX, int mouseY, int mouseButton) {
        if (this.btnClose.func_146115_a()) {
            if (this.content instanceof Application) {
                gui.closeApplication(((Application)this.content).getInfo());
                return;
            }
            if (this.parent != null) {
                this.parent.closeDialog();
            }
        }
        if (this.dialogWindow != null) {
            this.dialogWindow.handleMouseClick(gui, x, y, mouseX, mouseY, mouseButton);
            return;
        }
        ((Wrappable)this.content).handleMouseClick(mouseX, mouseY, mouseButton);
    }

    void handleMouseDrag(int mouseX, int mouseY, int mouseButton) {
        if (this.dialogWindow != null) {
            this.dialogWindow.handleMouseDrag(mouseX, mouseY, mouseButton);
            return;
        }
        ((Wrappable)this.content).handleMouseDrag(mouseX, mouseY, mouseButton);
    }

    void handleMouseRelease(int mouseX, int mouseY, int mouseButton) {
        if (this.dialogWindow != null) {
            this.dialogWindow.handleMouseRelease(mouseX, mouseY, mouseButton);
            return;
        }
        ((Wrappable)this.content).handleMouseRelease(mouseX, mouseY, mouseButton);
    }

    void handleMouseScroll(int mouseX, int mouseY, boolean direction) {
        if (this.dialogWindow != null) {
            this.dialogWindow.handleMouseScroll(mouseX, mouseY, direction);
            return;
        }
        ((Wrappable)this.content).handleMouseScroll(mouseX, mouseY, direction);
    }

    public void handleClose() {
        ((Wrappable)this.content).onClose();
    }

    private void updateComponents(int x, int y) {
        ((Wrappable)this.content).updateComponents(x + this.offsetX + 1, y + this.offsetY + 13);
        this.btnClose.field_146128_h = x + this.offsetX + this.width - 12;
        this.btnClose.field_146129_i = y + this.offsetY + 1;
    }

    public void openDialog(Dialog dialog) {
        if (this.dialogWindow != null) {
            this.dialogWindow.openDialog(dialog);
        } else {
            this.dialogWindow = new Window<Dialog>(dialog, null);
            this.dialogWindow.init(0, 0, null);
            this.dialogWindow.setParent(this);
        }
    }

    public void closeDialog() {
        if (this.dialogWindow != null) {
            this.dialogWindow.handleClose();
            this.dialogWindow = null;
        }
    }

    public Window<Dialog> getDialogWindow() {
        return this.dialogWindow;
    }

    public void close() {
        if (this.content instanceof Application) {
            this.laptop.closeApplication(((Application)this.content).getInfo());
            return;
        }
        if (this.parent != null) {
            this.parent.closeDialog();
        }
    }

    public void setParent(Window parent) {
        this.parent = parent;
    }

    public Window getParent() {
        return this.parent;
    }

    public T getContent() {
        return this.content;
    }
}

