/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.device.api.utils;

import com.mrcrayfish.device.core.Laptop;
import com.mrcrayfish.device.object.AppInfo;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;

public class RenderUtil {
    public static void renderItem(int x, int y, ItemStack stack, boolean overlay) {
        GlStateManager.func_179097_i();
        GlStateManager.func_179145_e();
        RenderHelper.func_74520_c();
        Minecraft.func_71410_x().func_175599_af().func_180450_b(stack, x, y);
        if (overlay) {
            Minecraft.func_71410_x().func_175599_af().func_175030_a(Minecraft.func_71410_x().field_71466_p, stack, x, y);
        }
        GlStateManager.func_179141_d();
        GlStateManager.func_179140_f();
    }

    public static void drawRectWithTexture(double x, double y, float u, float v, int width, int height, float textureWidth, float textureHeight) {
        RenderUtil.drawRectWithTexture(x, y, 0.0, u, v, width, height, textureWidth, textureHeight);
    }

    public static void drawRectWithTexture(double x, double y, double z, float u, float v, int width, int height, float textureWidth, float textureHeight) {
        float scale = 0.00390625f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b(x, y + (double)height, z).func_187315_a((double)(u * scale), (double)(v + textureHeight) * (double)scale).func_181675_d();
        buffer.func_181662_b(x + (double)width, y + (double)height, z).func_187315_a((double)(u + textureWidth) * (double)scale, (double)(v + textureHeight) * (double)scale).func_181675_d();
        buffer.func_181662_b(x + (double)width, y, z).func_187315_a((double)(u + textureWidth) * (double)scale, (double)(v * scale)).func_181675_d();
        buffer.func_181662_b(x, y, z).func_187315_a((double)(u * scale), (double)(v * scale)).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawRectWithFullTexture(double x, double y, float u, float v, int width, int height) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b(x, y + (double)height, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        buffer.func_181662_b(x + (double)width, y + (double)height, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        buffer.func_181662_b(x + (double)width, y, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        buffer.func_181662_b(x, y, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawRectWithTexture(double x, double y, float u, float v, int width, int height, float textureWidth, float textureHeight, int sourceWidth, int sourceHeight) {
        float scaleWidth = 1.0f / (float)sourceWidth;
        float scaleHeight = 1.0f / (float)sourceHeight;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b(x, y + (double)height, 0.0).func_187315_a((double)(u * scaleWidth), (double)(v + textureHeight) * (double)scaleHeight).func_181675_d();
        buffer.func_181662_b(x + (double)width, y + (double)height, 0.0).func_187315_a((double)(u + textureWidth) * (double)scaleWidth, (double)(v + textureHeight) * (double)scaleHeight).func_181675_d();
        buffer.func_181662_b(x + (double)width, y, 0.0).func_187315_a((double)(u + textureWidth) * (double)scaleWidth, (double)(v * scaleHeight)).func_181675_d();
        buffer.func_181662_b(x, y, 0.0).func_187315_a((double)(u * scaleWidth), (double)(v * scaleHeight)).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawApplicationIcon(@Nullable AppInfo info, double x, double y) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(Laptop.ICON_TEXTURES);
        if (info != null) {
            RenderUtil.drawRectWithTexture(x, y, info.getIconU(), info.getIconV(), 14, 14, 14.0f, 14.0f, 224, 224);
        } else {
            RenderUtil.drawRectWithTexture(x, y, 0.0f, 0.0f, 14, 14, 14.0f, 14.0f, 224, 224);
        }
    }

    public static void drawStringClipped(String text, int x, int y, int width, int color, boolean shadow) {
        Laptop.fontRenderer.func_175065_a(RenderUtil.clipStringToWidth(text, width) + TextFormatting.RESET, (float)x, (float)y, color, shadow);
    }

    public static String clipStringToWidth(String text, int width) {
        FontRenderer fontRenderer = Laptop.fontRenderer;
        String clipped = text;
        if (fontRenderer.func_78256_a(clipped) > width) {
            clipped = fontRenderer.func_78269_a(clipped, width - 8) + "...";
        }
        return clipped;
    }

    public static boolean isMouseInside(int mouseX, int mouseY, int x1, int y1, int x2, int y2) {
        return mouseX >= x1 && mouseX <= x2 && mouseY >= y1 && mouseY <= y2;
    }

    public static int color(int color, int defaultColor) {
        return color != -1 && color > 0 ? color : defaultColor;
    }
}

