/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.device.api.task;

import com.mrcrayfish.device.api.task.Callback;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public abstract class Task {
    private String name;
    private Callback<NBTTagCompound> callback = null;
    private boolean success = false;

    public Task(String name) {
        this.name = name;
    }

    public final Task setCallback(Callback<NBTTagCompound> callback) {
        this.callback = callback;
        return this;
    }

    public final void callback(NBTTagCompound nbt) {
        if (this.callback != null) {
            this.callback.execute(nbt, this.success);
        }
    }

    public final void setSuccessful() {
        this.success = true;
    }

    public final boolean isSucessful() {
        return this.success;
    }

    public final void complete() {
        this.success = false;
    }

    public final String getName() {
        return this.name;
    }

    public abstract void prepareRequest(NBTTagCompound var1);

    public abstract void processRequest(NBTTagCompound var1, World var2, EntityPlayer var3);

    public abstract void prepareResponse(NBTTagCompound var1);

    public abstract void processResponse(NBTTagCompound var1);
}

