/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.device.api.app.component;

import com.mrcrayfish.device.api.app.Component;
import com.mrcrayfish.device.api.app.component.RadioGroup;
import com.mrcrayfish.device.api.app.listener.ClickListener;
import com.mrcrayfish.device.core.Laptop;
import com.mrcrayfish.device.util.GuiHelper;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL11;

public class CheckBox
extends Component
implements RadioGroup.Item {
    protected String name;
    protected boolean checked = false;
    protected RadioGroup group = null;
    protected ClickListener listener = null;
    protected int textColor = Color.WHITE.getRGB();
    protected int backgroundColor = Color.GRAY.getRGB();
    protected int borderColor = Color.BLACK.getRGB();
    protected int checkedColor = Color.DARK_GRAY.getRGB();

    public CheckBox(String name, int left, int top) {
        super(left, top);
        this.name = name;
    }

    public void setRadioGroup(RadioGroup group) {
        this.group = group;
        this.group.add(this);
    }

    public void setClickListener(ClickListener listener) {
        this.listener = listener;
    }

    @Override
    public void render(Laptop laptop, Minecraft mc, int x, int y, int mouseX, int mouseY, boolean windowActive, float partialTicks) {
        if (this.visible) {
            if (this.group == null) {
                Color bgColor = new Color(this.getColorScheme().getBackgroundColor());
                CheckBox.func_73734_a((int)this.xPosition, (int)this.yPosition, (int)(this.xPosition + 10), (int)(this.yPosition + 10), (int)CheckBox.color(this.borderColor, bgColor.darker().darker().getRGB()));
                CheckBox.func_73734_a((int)(this.xPosition + 1), (int)(this.yPosition + 1), (int)(this.xPosition + 9), (int)(this.yPosition + 9), (int)CheckBox.color(this.backgroundColor, bgColor.getRGB()));
                if (this.checked) {
                    CheckBox.func_73734_a((int)(this.xPosition + 2), (int)(this.yPosition + 2), (int)(this.xPosition + 8), (int)(this.yPosition + 8), (int)CheckBox.color(this.checkedColor, bgColor.brighter().brighter().getRGB()));
                }
            } else {
                Color bgColor = new Color(this.getColorScheme().getBackgroundColor()).brighter().brighter();
                float[] hsb = Color.RGBtoHSB(bgColor.getRed(), bgColor.getGreen(), bgColor.getBlue(), null);
                bgColor = new Color(Color.HSBtoRGB(hsb[0], hsb[1], 1.0f));
                GL11.glColor4f((float)((float)bgColor.getRed() / 255.0f), (float)((float)bgColor.getGreen() / 255.0f), (float)((float)bgColor.getBlue() / 255.0f), (float)1.0f);
                mc.func_110434_K().func_110577_a(COMPONENTS_GUI);
                this.func_73729_b(this.xPosition, this.yPosition, this.checked ? 10 : 0, 60, 10, 10);
            }
            this.func_73731_b(mc.field_71466_p, this.name, this.xPosition + 12, this.yPosition + 1, CheckBox.color(this.textColor, this.getColorScheme().getTextColor()));
        }
    }

    @Override
    public void handleMouseClick(int mouseX, int mouseY, int mouseButton) {
        if (!this.visible || !this.enabled) {
            return;
        }
        if (GuiHelper.isMouseInside(mouseX, mouseY, this.xPosition, this.yPosition, this.xPosition + 10, this.yPosition + 10)) {
            if (this.group != null) {
                this.group.deselect();
            }
            boolean bl = this.checked = !this.checked;
            if (this.listener != null) {
                this.listener.onClick(mouseX, mouseY, mouseButton);
            }
        }
    }

    @Override
    public boolean isSelected() {
        return this.checked;
    }

    @Override
    public void setSelected(boolean enabled) {
        this.checked = enabled;
    }

    public void setTextColor(Color color) {
        this.textColor = color.getRGB();
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color.getRGB();
    }

    public void setBorderColor(Color color) {
        this.borderColor = color.getRGB();
    }

    public void setCheckedColor(Color color) {
        this.checkedColor = color.getRGB();
    }
}

