/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.block;

import biomesoplenty.api.enums.BOPTrees;
import biomesoplenty.api.item.BOPItems;
import biomesoplenty.common.block.BlockBOPSapling;
import biomesoplenty.common.block.BlockColoring;
import biomesoplenty.common.block.IBOPBlock;
import biomesoplenty.common.item.ItemBOPBlock;
import biomesoplenty.common.util.block.VariantPagingHelper;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.ColorizerFoliage;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeColorHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBOPLeaves
extends BlockLeaves
implements IBOPBlock {
    public static VariantPagingHelper<BlockBOPLeaves, BOPTrees> paging = new VariantPagingHelper(4, BOPTrees.class);
    private static IProperty currentVariantProperty;
    public IProperty variantProperty;

    public static void createAllPages() {
        int numPages = paging.getNumPages();
        for (int i = 0; i < numPages; ++i) {
            currentVariantProperty = paging.getVariantProperty(i);
            paging.addBlock(i, new BlockBOPLeaves());
        }
    }

    protected BlockStateContainer func_180661_e() {
        this.variantProperty = currentVariantProperty;
        return new BlockStateContainer((Block)this, new IProperty[]{field_176236_b, field_176237_a, this.variantProperty});
    }

    @Override
    public Class<? extends ItemBlock> getItemClass() {
        return ItemBOPBlock.class;
    }

    @Override
    public IProperty[] getPresetProperties() {
        return new IProperty[]{this.variantProperty};
    }

    @Override
    public IProperty[] getNonRenderingProperties() {
        return new IProperty[]{field_176236_b, field_176237_a};
    }

    @Override
    public String getStateName(IBlockState state) {
        BOPTrees tree = (BOPTrees)((Object)state.func_177229_b(this.variantProperty));
        switch (tree) {
            case RED_BIG_FLOWER: 
            case YELLOW_BIG_FLOWER: {
                return tree.func_176610_l() + "_petal";
            }
        }
        return tree.func_176610_l() + "_leaves";
    }

    public static ColoringType getColoringType(BOPTrees tree) {
        switch (tree) {
            case RED_BIG_FLOWER: 
            case YELLOW_BIG_FLOWER: 
            case BAMBOO: 
            case UMBRAN: 
            case DEAD: 
            case ETHEREAL: 
            case FIR: 
            case HELLBARK: 
            case JACARANDA: 
            case MAGIC: 
            case MAPLE: 
            case ORANGE_AUTUMN: 
            case ORIGIN: 
            case PINK_CHERRY: 
            case REDWOOD: 
            case WHITE_CHERRY: 
            case YELLOW_AUTUMN: {
                return ColoringType.PLAIN;
            }
            case FLOWERING: {
                return ColoringType.OVERLAY;
            }
        }
        return ColoringType.TINTED;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IBlockColor getBlockColor() {
        return new IBlockColor(){

            public int func_186720_a(IBlockState state, IBlockAccess world, BlockPos pos, int tintIndex) {
                boolean inWorld = world != null && pos != null;
                switch (BlockBOPLeaves.getColoringType((BOPTrees)((Object)state.func_177229_b(BlockBOPLeaves.this.variantProperty)))) {
                    case TINTED: {
                        return inWorld ? BiomeColorHelper.func_180287_b((IBlockAccess)world, (BlockPos)pos) : ColorizerFoliage.func_77468_c();
                    }
                    case OVERLAY: {
                        if (tintIndex != 0) break;
                        return inWorld ? BiomeColorHelper.func_180287_b((IBlockAccess)world, (BlockPos)pos) : ColorizerFoliage.func_77468_c();
                    }
                }
                return 0xFFFFFF;
            }
        };
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IItemColor getItemColor() {
        return BlockColoring.BLOCK_ITEM_COLORING;
    }

    private BlockBOPLeaves() {
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_176236_b, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)field_176237_a, (Comparable)Boolean.valueOf(true)));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(this.variantProperty, (Comparable)((Object)paging.getVariant(this, meta & 3))).func_177226_a((IProperty)field_176237_a, (Comparable)Boolean.valueOf((meta & 4) == 0)).func_177226_a((IProperty)field_176236_b, (Comparable)Boolean.valueOf((meta & 8) > 0));
    }

    public int func_176201_c(IBlockState state) {
        BOPTrees tree = (BOPTrees)((Object)state.func_177229_b(this.variantProperty));
        int meta = paging.getIndex(tree);
        if (!((Boolean)state.func_177229_b((IProperty)field_176237_a)).booleanValue()) {
            meta |= 4;
        }
        if (((Boolean)state.func_177229_b((IProperty)field_176236_b)).booleanValue()) {
            meta |= 8;
        }
        return meta;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176203_a(meta).func_177226_a((IProperty)field_176236_b, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)field_176237_a, (Comparable)Boolean.valueOf(false));
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)this, 1, this.func_176201_c(this.func_176223_P().func_177226_a(this.variantProperty, state.func_177229_b(this.variantProperty))));
    }

    protected ItemStack func_180643_i(IBlockState state) {
        IBlockState newState = state.func_177226_a((IProperty)field_176236_b, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)field_176237_a, (Comparable)Boolean.valueOf(false));
        return super.func_180643_i(newState);
    }

    protected int func_176232_d(IBlockState state) {
        return 20;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        BOPTrees treeType = (BOPTrees)((Object)state.func_177229_b(this.variantProperty));
        return treeType.hasSapling() ? Item.func_150898_a((Block)BlockBOPSapling.paging.getBlock(treeType)) : null;
    }

    public int func_180651_a(IBlockState state) {
        BOPTrees treeType = (BOPTrees)((Object)state.func_177229_b(this.variantProperty));
        return treeType.hasSapling() ? BlockBOPSapling.paging.getVariantItem(treeType).func_77952_i() : 0;
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        switch ((BOPTrees)((Object)state.func_177229_b(this.variantProperty))) {
            case YELLOW_AUTUMN: {
                return MapColor.field_151673_t;
            }
            case ORANGE_AUTUMN: {
                return MapColor.field_151676_q;
            }
            case MAGIC: {
                return MapColor.field_151674_s;
            }
            case UMBRAN: {
                return MapColor.field_193572_X;
            }
            case DEAD: {
                return MapColor.field_151650_B;
            }
            case PINK_CHERRY: {
                return MapColor.field_151671_v;
            }
            case WHITE_CHERRY: {
                return MapColor.field_193561_M;
            }
            case MAPLE: {
                return MapColor.field_193567_S;
            }
            case RED_BIG_FLOWER: {
                return MapColor.field_151645_D;
            }
            case YELLOW_BIG_FLOWER: {
                return MapColor.field_151673_t;
            }
            case JACARANDA: {
                return MapColor.field_151678_z;
            }
        }
        return this.field_181083_K;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        BOPTrees treeType = (BOPTrees)((Object)state.func_177229_b(this.variantProperty));
        if (treeType.hasSapling()) {
            return super.getDrops(world, pos, state, fortune);
        }
        return Lists.newArrayList();
    }

    protected void func_176234_a(World worldIn, BlockPos pos, IBlockState state, int chance) {
        ItemStack fruit = null;
        BOPTrees tree = (BOPTrees)((Object)state.func_177229_b(this.variantProperty));
        switch (tree) {
            case JACARANDA: 
            case FLOWERING: 
            case MAHOGANY: {
                if (worldIn.field_73012_v.nextInt(chance) != 0) break;
                fruit = new ItemStack(BOPItems.peach, 1, 0);
                break;
            }
            case MANGROVE: 
            case WILLOW: {
                if (worldIn.field_73012_v.nextInt(chance) != 0) break;
                fruit = new ItemStack(BOPItems.pear, 1, 0);
                break;
            }
            case DEAD: 
            case MAPLE: 
            case ORANGE_AUTUMN: 
            case YELLOW_AUTUMN: {
                if (worldIn.field_73012_v.nextInt(chance) != 0) break;
                fruit = new ItemStack(BOPItems.persimmon, 1, 0);
                break;
            }
            case ORIGIN: {
                if (worldIn.field_73012_v.nextInt(chance) != 0) break;
                fruit = new ItemStack(Items.field_151034_e, 1, 0);
                break;
            }
        }
        if (fruit != null) {
            BlockBOPLeaves.func_180635_a((World)worldIn, (BlockPos)pos, fruit);
        }
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, @Nullable ItemStack stack) {
        if (!worldIn.field_72995_K && stack != null && stack.func_77973_b() == Items.field_151097_aZ) {
            player.func_71029_a(StatList.func_188055_a((Block)this));
        } else {
            super.func_180657_a(worldIn, player, pos, state, te, stack);
        }
    }

    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == this) {
            BOPTrees tree = (BOPTrees)((Object)state.func_177229_b(this.variantProperty));
            int meta = this.func_176201_c(this.func_176223_P().func_177226_a(this.variantProperty, (Comparable)((Object)tree)));
            ret.add(new ItemStack((Block)this, 1, meta));
        }
        return ret;
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        BOPTrees tree = (BOPTrees)((Object)world.func_180495_p(pos).func_177229_b(this.variantProperty));
        switch (tree) {
            case HELLBARK: {
                return 0;
            }
        }
        return Blocks.field_150362_t.getFlammability(world, pos, face);
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        BOPTrees tree = (BOPTrees)((Object)world.func_180495_p(pos).func_177229_b(this.variantProperty));
        switch (tree) {
            case HELLBARK: {
                return 0;
            }
        }
        return Blocks.field_150362_t.getFireSpreadSpeed(world, pos, face);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return Blocks.field_150362_t.func_180664_k();
    }

    public boolean func_149662_c(IBlockState state) {
        return Blocks.field_150362_t.func_149662_c(state);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return Blocks.field_150362_t.func_176225_a(state, world, pos, side);
    }

    public BlockPlanks.EnumType func_176233_b(int meta) {
        return null;
    }

    public static enum ColoringType {
        PLAIN,
        TINTED,
        OVERLAY;

    }
}

