/*
 * Decompiled with CFR 0.152.
 */
package superhb.arcademod.client.gui;

import java.awt.Color;
import java.awt.Point;
import java.io.IOException;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import superhb.arcademod.api.gui.GuiArcade;
import superhb.arcademod.client.ArcadeItems;
import superhb.arcademod.client.audio.ArcadeSounds;
import superhb.arcademod.client.tileentity.TileEntityArcade;
import superhb.arcademod.util.KeyHandler;

public class GuiPacMan
extends GuiArcade {
    private static final ResourceLocation texture = new ResourceLocation("arcademod:textures/gui/pacman.png");
    private static final int GUI_X = 234;
    private static final int GUI_Y = 284;
    private static final int MAZE_X = 224;
    private static final int MAZE_Y = 248;
    private static final int GHOST = 14;
    private static final int PUPIL = 2;
    private static final int EYE_X = 4;
    private static final int EYE_Y = 5;
    private static final int MOUTH_X = 12;
    private static final int MOUTH_Y = 2;
    private static final int BONUS = 14;
    private static final int PACMAN = 15;
    private static final int DOT = 2;
    private static final int ENERGIZER = 8;
    private float volume = 1.0f;
    private int waka;
    private boolean playSiren = true;
    private int boardX;
    private int boardY;
    private int score;
    private Tile[][] tiles = new Tile[31][28];
    private int ENERGIZER_STATE = 0;
    private byte level;
    private boolean gameOver;
    private boolean mazeBlink;
    private boolean nextLevel;
    private int mazeBlinkTick = 0;
    private int mazeBlinks = 0;
    private boolean playing;
    private boolean updatePos;
    private int startTick = 0;
    private EnumBonus bonus;
    private int bonusTick;
    private int bonusTime;
    private boolean showBonus;
    private int backTick;
    private Player pacman;
    private Ghost[] ghosts = new Ghost[4];
    private int deathTick = 0;
    private int gameOverTick = 0;
    private int energizerTick = 0;
    private int scatterTick = 0;
    private int scaredTime = 0;
    private int scaredFlash = 0;
    private ArrayList<Integer> houseQueue = new ArrayList();
    private boolean useGlobalCounter;
    private int globalCounter;
    private int dotTick;
    private int dotTimeLimit = 80;

    public GuiPacMan(World world, TileEntityArcade tile, @Nullable BlockPos pos, EntityPlayer player) {
        super(world, tile, pos, player);
        this.setGuiSize(234, 284, 0.8f);
        this.setTexture(texture, 512, 512);
        this.setCost(4);
        this.setOffset(0, 0);
        this.setButtonPos(117 - this.buttonWidth / 2, 254);
        this.setStartMenu(0);
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        if (this.inMenu) {
            if (this.menu == 3 && this.tickCounter - this.backTick == 60) {
                this.level = 0;
                this.scaredFlash = 0;
                this.scaredTime = 0;
                this.scatterTick = 0;
                this.energizerTick = 0;
                this.gameOverTick = 0;
                this.deathTick = 0;
                this.mazeBlinkTick = 0;
                this.mazeBlinks = 0;
                this.ENERGIZER_STATE = 0;
                this.score = 0;
                this.tickCounter = 0;
                this.checkMenuAfterGameOver();
            }
        } else if (this.playing) {
            int i;
            for (i = 0; i < 3; ++i) {
                this.pacman.move().updatePosition(this.boardX, this.boardY);
            }
            this.pacman.update();
            for (i = 0; i < this.ghosts.length; ++i) {
                for (int j = 0; j < (this.ghosts[i].eaten ? 6 : 3); ++j) {
                    this.ghosts[i].ai().move().updatePosition(this.boardX, this.boardY);
                }
                this.ghosts[i].update();
            }
            this.collisionDetection();
            if (this.tickCounter - this.energizerTick >= 10) {
                this.energizerTick = this.tickCounter;
                this.ENERGIZER_STATE = this.ENERGIZER_STATE == 0 ? 1 : 0;
            }
            if (this.pacman.foodEaten == 244 + 244 * this.level) {
                if (!this.nextLevel) {
                    this.pacman.canMove = false;
                    for (i = 0; i < this.ghosts.length; ++i) {
                        this.ghosts[i].canMove = false;
                    }
                    this.nextLevel = true;
                    this.mazeBlinkTick = this.tickCounter;
                }
                if (this.tickCounter - this.mazeBlinkTick == 40 && this.mazeBlinks == 0 || this.tickCounter - this.mazeBlinkTick == 5 && this.mazeBlinks < 5) {
                    this.mazeBlinkTick = this.tickCounter;
                    this.mazeBlink = !this.mazeBlink;
                    ++this.mazeBlinks;
                }
                if (this.mazeBlinks == 5) {
                    this.level = (byte)(this.level + 1);
                    this.mazeBlink = false;
                    this.mazeBlinks = 0;
                    this.waka = 0;
                    this.mazeBlinkTick = 0;
                    this.gameOverTick = 0;
                    this.scatterTick = 0;
                    this.energizerTick = 0;
                    this.deathTick = 0;
                    this.tickCounter = 0;
                    this.pacman.reset();
                    this.setupTiles();
                    this.setupGame();
                }
            }
            if (this.pacman.foodEaten == 70 || this.pacman.foodEaten == 170) {
                this.bonusTime = (int)(this.rand(9, 10) * 20.0);
                this.bonusTick = this.tickCounter;
                this.showBonus = true;
            }
            if (this.showBonus && this.tickCounter - this.bonusTick == this.bonusTime) {
                this.showBonus = false;
            }
        } else {
            int i;
            if (this.tickCounter - this.startTick == 35) {
                this.playing = true;
                this.pacman.canMove = true;
                for (i = 0; i < this.ghosts.length; ++i) {
                    this.ghosts[i].canMove = true;
                }
                this.dotTick = this.tickCounter;
            }
            if (!this.updatePos) {
                this.updatePos = true;
                this.pacman.updatePosition(this.boardX, this.boardY);
                for (i = 0; i < this.ghosts.length; ++i) {
                    this.ghosts[i].updatePosition(this.boardX, this.boardY);
                }
            }
        }
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTick) {
        this.boardX = this.xScaled - 117 + 5;
        this.boardY = this.yScaled - 142 + 14;
        super.func_73863_a(mouseX, mouseY, partialTick);
        int controlWidth = this.field_146289_q.func_78256_a(I18n.func_135052_a((String)"option.arcademod:control.locale", (Object[])new Object[0]));
        int settingWidth = this.field_146289_q.func_78256_a(I18n.func_135052_a((String)"option.arcademod:setting.locale", (Object[])new Object[0]));
        if (this.inMenu) {
            switch (this.menu) {
                case 0: {
                    int titleWidth = this.field_146289_q.func_78256_a(I18n.func_135052_a((String)"game.arcademod:pacman.name", (Object[])new Object[0]));
                    int startWidth = this.field_146289_q.func_78256_a(I18n.func_135052_a((String)"option.arcademod:start.locale", (Object[])new Object[0]));
                    this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"game.arcademod:pacman.name", (Object[])new Object[0]), this.boardX + 117 - titleWidth / 2, this.boardY + 2, Color.WHITE.getRGB());
                    this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"option.arcademod:start.locale", (Object[])new Object[0]), this.boardX + 117 - startWidth / 2, this.boardY + 142 - 30, Color.WHITE.getRGB());
                    this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"option.arcademod:control.locale", (Object[])new Object[0]), this.boardX + 117 - controlWidth / 2, this.boardY + 142 - 20, Color.WHITE.getRGB());
                    this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"option.arcademod:setting.locale", (Object[])new Object[0]), this.boardX + 117 - settingWidth / 2, this.boardY + 142 - 10, Color.WHITE.getRGB());
                    if (this.menuOption == 0) {
                        this.drawRightArrow(this.boardX + 117 - 30, this.boardY + 142 - 32, true);
                        break;
                    }
                    if (this.menuOption == 1) {
                        this.drawRightArrow(this.boardX + 117 - 30, this.boardY + 142 - 22, true);
                        break;
                    }
                    if (this.menuOption != 2) break;
                    this.drawRightArrow(this.boardX + 117 - 30, this.boardY + 142 - 12, true);
                    break;
                }
                case 1: {
                    this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"option.arcademod:control.locale", (Object[])new Object[0]), this.boardX + 117 - controlWidth / 2, this.boardY + 2, Color.WHITE.getRGB());
                    this.field_146289_q.func_78276_b("[" + KeyHandler.up.getDisplayName() + "] " + I18n.func_135052_a((String)"control.arcademod:up.name", (Object[])new Object[0]), this.boardX + 117 - 30, this.boardY + 142 - 20, Color.WHITE.getRGB());
                    this.field_146289_q.func_78276_b("[" + KeyHandler.down.getDisplayName() + "] " + I18n.func_135052_a((String)"control.arcademod:down.name", (Object[])new Object[0]), this.boardX + 117 - 30, this.boardY + 142 - 10, Color.WHITE.getRGB());
                    this.field_146289_q.func_78276_b("[" + KeyHandler.left.getDisplayName() + "] " + I18n.func_135052_a((String)"control.arcademod:left.name", (Object[])new Object[0]), this.boardX + 117 - 30, this.boardY + 142, Color.WHITE.getRGB());
                    this.field_146289_q.func_78276_b("[" + KeyHandler.right.getDisplayName() + "] " + I18n.func_135052_a((String)"control.arcademod:right.name", (Object[])new Object[0]), this.boardX + 117 - 30, this.boardY + 142 + 10, Color.WHITE.getRGB());
                    this.field_146289_q.func_78276_b("[" + KeyHandler.left.getDisplayName() + "] " + I18n.func_135052_a((String)"option.arcademod:back.name", (Object[])new Object[0]), this.boardX + 2, this.boardY + 284 - 30, Color.white.getRGB());
                    break;
                }
                case 2: {
                    this.field_146289_q.func_78276_b("[" + KeyHandler.left.getDisplayName() + "] " + I18n.func_135052_a((String)"option.arcademod:back.name", (Object[])new Object[0]), this.boardX + 2, this.boardY + 284 - 30, Color.white.getRGB());
                    break;
                }
                case 3: {
                    this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"text.arcademod:gameover.locale", (Object[])new Object[0]), this.boardX + 117 - this.field_146289_q.func_78256_a(I18n.func_135052_a((String)"text.arcademod:gameover.locale", (Object[])new Object[0])) / 2, this.boardY + 142 - 20, Color.WHITE.getRGB());
                    this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"text.arcademod:score.locale", (Object[])new Object[0]) + ": " + this.score, this.boardX + 117 - this.field_146289_q.func_78256_a(I18n.func_135052_a((String)"text.arcademod:score.locale=Score", (Object[])new Object[0]) + ": " + this.score), this.boardY + 142, Color.WHITE.getRGB());
                }
            }
        } else {
            this.drawMaze();
            for (int y = 0; y < 31; ++y) {
                for (int x = 0; x < 28; ++x) {
                    if (this.tiles[y][x] == null) continue;
                    this.tiles[y][x].updatePosition(this.boardX, this.boardY).drawTile();
                }
            }
            for (int i = 0; i < this.ghosts.length; ++i) {
                this.ghosts[i].drawGhost();
            }
            this.pacman.drawPlayer().drawLives();
            this.drawBonus();
            if (!this.playing) {
                this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"text.arcademod:ready.pacman.locale", (Object[])new Object[0]), this.boardX + 112 - this.field_146289_q.func_78256_a(I18n.func_135052_a((String)"text.arcademod:ready.pacman.locale", (Object[])new Object[0])) / 2, this.boardY + 124 + 13, Color.yellow.getRGB());
            }
            this.field_146289_q.func_78276_b(String.format("%d", this.score), this.boardX + 30, this.boardY - 8, Color.white.getRGB());
        }
    }

    private void drawBonus() {
        if (this.showBonus) {
            this.glColor(Color.WHITE);
            GuiPacMan.func_146110_a((int)(this.boardX + 104 + 2), (int)(this.boardY + 136 - 3), (float)(272 + 14 * this.bonus.getId()), (float)248.0f, (int)14, (int)14, (float)512.0f, (float)512.0f);
        }
    }

    private void drawMaze() {
        if (this.mazeBlink) {
            this.glColor(Color.WHITE);
        } else {
            this.glColor(new Color(33, 33, 222));
        }
        GuiPacMan.func_146110_a((int)this.boardX, (int)this.boardY, (float)234.0f, (float)0.0f, (int)224, (int)248, (float)512.0f, (float)512.0f);
        this.glColor(Color.WHITE);
        GuiPacMan.func_146110_a((int)(this.boardX + 104), (int)(this.boardY + 101), (float)242.0f, (float)264.0f, (int)16, (int)2, (float)512.0f, (float)512.0f);
    }

    private void collisionDetection() {
        for (int i = 0; i < this.ghosts.length; ++i) {
            if (this.pacman.getTile() != this.ghosts[i].getTile() || this.ghosts[i].scared || this.ghosts[i].eaten) continue;
            this.endGame();
        }
    }

    private void pause() {
        this.pacman.canMove = false;
        for (int i = 0; i < this.ghosts.length; ++i) {
            this.ghosts[i].canMove = false;
        }
    }

    private void unpause() {
        this.pacman.canMove = true;
        for (int i = 0; i < this.ghosts.length; ++i) {
            this.ghosts[i].canMove = true;
        }
    }

    private void endGame() {
        if (!this.gameOver) {
            this.gameOver = true;
            this.pacman.canMove = false;
            for (int i = 0; i < this.ghosts.length; ++i) {
                this.ghosts[i].canMove = false;
            }
            this.pacman.kill();
        }
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"text.arcademod:gameover.locale", (Object[])new Object[0]), this.boardX + 112 - this.field_146289_q.func_78256_a(I18n.func_135052_a((String)"text.arcademod:gameover.locale", (Object[])new Object[0])) / 2, this.boardY + 124 + 13, Color.red.getRGB());
    }

    private void setupGame() {
        this.getLevelData();
        this.resetGame();
        if (this.gameOver) {
            this.pacman.reset();
            this.waka = 0;
            this.gameOverTick = 0;
            this.scatterTick = 0;
            this.energizerTick = 0;
            this.deathTick = 0;
            this.tickCounter = 0;
            this.gameOver = false;
        }
        this.startTick = this.tickCounter;
        this.playing = false;
    }

    private void resetGame() {
        this.ghosts[0] = new Ghost(EnumGhost.BLINKY);
        this.ghosts[1] = new Ghost(EnumGhost.PINKY);
        this.ghosts[2] = new Ghost(EnumGhost.INKY);
        this.ghosts[3] = new Ghost(EnumGhost.CLYDE);
    }

    private void startGame() {
        this.score = 0;
        this.level = 0;
        this.inMenu = false;
        this.pacman = new Player();
        this.canGetCoinBack = false;
        this.setupTiles();
        this.setupGame();
    }

    @Override
    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (this.inMenu) {
            if (this.menu == 0) {
                if (keyCode == KeyHandler.down.func_151463_i()) {
                    this.menuOption = this.menuOption == 2 ? 0 : ++this.menuOption;
                }
                if (keyCode == KeyHandler.up.func_151463_i()) {
                    this.menuOption = this.menuOption == 0 ? 2 : --this.menuOption;
                }
                if (keyCode == KeyHandler.select.func_151463_i()) {
                    if (this.menuOption == 0) {
                        this.startGame();
                    } else {
                        this.menu = this.menuOption;
                    }
                }
            }
            if (keyCode == KeyHandler.left.func_151463_i()) {
                this.menu = 0;
            }
        } else {
            if (keyCode == KeyHandler.left.func_151463_i()) {
                this.pacman.desired = Direction.LEFT;
            } else if (keyCode == KeyHandler.right.func_151463_i()) {
                this.pacman.desired = Direction.RIGHT;
            } else if (keyCode == KeyHandler.down.func_151463_i()) {
                this.pacman.desired = Direction.DOWN;
            } else if (keyCode == KeyHandler.up.func_151463_i()) {
                this.pacman.desired = Direction.UP;
            }
            if (keyCode == 1) {
                this.giveReward(ArcadeItems.TICKET, this.score / 200);
            }
        }
        super.func_73869_a(typedChar, keyCode);
    }

    private void getLevelData() {
        this.dotTimeLimit = this.level < 4 ? 80 : 60;
        if (this.level == 0) {
            this.bonus = EnumBonus.CHERRY;
        }
        if (this.level == 1) {
            this.bonus = EnumBonus.STRAWBERRY;
        }
        if (this.level == 2 || this.level == 3) {
            this.bonus = EnumBonus.PEACH;
        }
        if (this.level == 4 || this.level == 5) {
            this.bonus = EnumBonus.APPLE;
        }
        if (this.level == 6 || this.level == 7) {
            this.bonus = EnumBonus.GRAPES;
        }
        if (this.level == 8 || this.level == 9) {
            this.bonus = EnumBonus.GALAXIAN;
        }
        if (this.level == 10 || this.level == 11) {
            this.bonus = EnumBonus.BELL;
        }
        if (this.level > 11) {
            this.bonus = EnumBonus.KEY;
        }
        if (this.level == 0) {
            this.scaredTime = 6;
            this.scaredFlash = 5;
        }
        if (this.level == 1) {
            this.scaredTime = 5;
            this.scaredFlash = 5;
        }
        if (this.level == 2) {
            this.scaredTime = 4;
            this.scaredFlash = 5;
        }
        if (this.level == 3) {
            this.scaredTime = 3;
            this.scaredFlash = 5;
        }
        if (this.level == 4) {
            this.scaredTime = 2;
            this.scaredFlash = 5;
        }
        if (this.level == 5) {
            this.scaredTime = 5;
            this.scaredFlash = 5;
        }
        if (this.level == 6) {
            this.scaredTime = 2;
            this.scaredFlash = 5;
        }
        if (this.level == 7) {
            this.scaredTime = 2;
            this.scaredFlash = 5;
        }
        if (this.level == 8) {
            this.scaredTime = 1;
            this.scaredFlash = 3;
        }
        if (this.level == 9) {
            this.scaredTime = 5;
            this.scaredFlash = 5;
        }
        if (this.level == 10) {
            this.scaredTime = 2;
            this.scaredFlash = 5;
        }
        if (this.level == 11) {
            this.scaredTime = 1;
            this.scaredFlash = 3;
        }
        if (this.level == 12) {
            this.scaredTime = 1;
            this.scaredFlash = 3;
        }
        if (this.level == 13) {
            this.scaredTime = 3;
            this.scaredFlash = 5;
        }
        if (this.level == 14) {
            this.scaredTime = 1;
            this.scaredFlash = 3;
        }
        if (this.level == 15) {
            this.scaredTime = 1;
            this.scaredFlash = 3;
        }
        if (this.level == 16) {
            this.scaredTime = 0;
            this.scaredFlash = 0;
        }
        if (this.level == 17) {
            this.scaredTime = 1;
            this.scaredFlash = 3;
        }
        if (this.level == 18) {
            this.scaredTime = 0;
            this.scaredFlash = 0;
        }
        if (this.level == 19) {
            this.scaredTime = 0;
            this.scaredFlash = 0;
        }
        if (this.level >= 20) {
            this.scaredTime = 0;
            this.scaredFlash = 0;
        }
    }

    private void setupTiles() {
        int i;
        for (i = 0; i < 28; ++i) {
            this.tiles[0][i] = new Tile(i, 0, EnumTile.WALL);
        }
        for (i = 0; i < 28; ++i) {
            this.tiles[1][i] = i == 0 || i > 12 && i < 15 || i == 27 ? new Tile(i, 1, EnumTile.WALL) : new Tile(i, 1);
        }
        for (i = 0; i < 28; ++i) {
            this.tiles[2][i] = i == 0 || i > 1 && i < 6 || i > 6 && i < 12 || i > 12 && i < 15 || i > 15 && i < 21 || i > 21 && i < 26 || i == 27 ? new Tile(i, 2, EnumTile.WALL) : new Tile(i, 2);
        }
        for (i = 0; i < 28; ++i) {
            this.tiles[3][i] = i == 0 || i > 1 && i < 6 || i > 6 && i < 12 || i > 12 && i < 15 || i > 15 && i < 21 || i > 21 && i < 26 || i == 27 ? new Tile(i, 3, EnumTile.WALL) : (i == 1 || i == 26 ? new Tile(i, 3, 2) : new Tile(i, 3));
        }
        for (i = 0; i < 28; ++i) {
            this.tiles[4][i] = i == 0 || i > 1 && i < 6 || i > 6 && i < 12 || i > 12 && i < 15 || i > 15 && i < 21 || i > 21 && i < 26 || i == 27 ? new Tile(i, 4, EnumTile.WALL) : new Tile(i, 4);
        }
        for (i = 0; i < 28; ++i) {
            this.tiles[5][i] = i == 0 || i == 27 ? new Tile(i, 5, EnumTile.WALL) : new Tile(i, 5);
        }
        for (i = 0; i < 28; ++i) {
            this.tiles[6][i] = i == 0 || i > 1 && i < 6 || i > 6 && i < 9 || i > 9 && i < 18 || i > 18 && i < 21 || i > 21 && i < 26 || i == 27 ? new Tile(i, 6, EnumTile.WALL) : new Tile(i, 6);
        }
        for (i = 0; i < 28; ++i) {
            this.tiles[7][i] = i == 0 || i > 1 && i < 6 || i > 6 && i < 9 || i > 9 && i < 18 || i > 18 && i < 21 || i > 21 && i < 26 || i == 27 ? new Tile(i, 7, EnumTile.WALL) : new Tile(i, 7);
        }
        for (i = 0; i < 28; ++i) {
            this.tiles[8][i] = i == 0 || i > 6 && i < 9 || i > 12 && i < 15 || i > 18 && i < 21 || i == 27 ? new Tile(i, 8, EnumTile.WALL) : new Tile(i, 8);
        }
        for (i = 0; i < 28; ++i) {
            this.tiles[9][i] = i >= 0 && i < 6 || i > 6 && i < 12 || i > 12 && i < 15 || i > 15 && i < 21 || i > 21 && i < 28 ? new Tile(i, 9, EnumTile.WALL) : (i == 12 || i == 15 ? new Tile(i, 9, 0) : new Tile(i, 9));
        }
        for (i = 0; i < 28; ++i) {
            this.tiles[10][i] = i >= 0 && i < 6 || i > 6 && i < 12 || i > 12 && i < 15 || i > 15 && i < 21 || i > 21 && i < 28 ? new Tile(i, 10, EnumTile.WALL) : (i == 12 || i == 15 ? new Tile(i, 10, 0) : new Tile(i, 10));
        }
        for (i = 0; i < 28; ++i) {
            this.tiles[11][i] = i >= 0 && i < 6 || i > 6 && i < 9 || i > 18 && i < 21 || i > 21 && i < 28 ? new Tile(i, 11, EnumTile.WALL) : (i == 9 || i == 18 ? new Tile(i, 11, 0) : (i > 9 && i < 18 ? new Tile(i, 11, EnumTile.GHOST_LIMIT) : new Tile(i, 11)));
        }
        for (i = 0; i < 28; ++i) {
            this.tiles[12][i] = i >= 0 && i < 6 || i > 6 && i < 9 || i > 9 && i < 13 || i > 14 && i < 18 || i > 18 && i < 21 || i > 21 && i < 28 ? new Tile(i, 12, EnumTile.WALL) : (i == 9 || i == 18 ? new Tile(i, 12, 0) : (i == 13 || i == 14 ? new Tile(i, 12, EnumTile.GHOST_ONLY) : new Tile(i, 12)));
        }
        for (i = 0; i < 28; ++i) {
            this.tiles[13][i] = i >= 0 && i < 6 || i > 6 && i < 9 || i == 10 || i == 17 || i > 18 && i < 21 || i > 21 && i < 28 ? new Tile(i, 13, EnumTile.WALL) : (i == 9 || i == 18 ? new Tile(i, 13, 0) : (i > 10 && i < 17 ? new Tile(i, 13, EnumTile.GHOST_ONLY) : new Tile(i, 13)));
        }
        for (i = 0; i < 28; ++i) {
            this.tiles[14][i] = i == 0 || i == 27 ? new Tile(i, 14, EnumTile.TELE) : (i > 0 && i < 6 || i > 21 && i < 27 ? new Tile(i, 14, EnumTile.TELE_ZONE) : (i == 10 || i == 17 ? new Tile(i, 14, EnumTile.WALL) : (i > 10 && i < 17 ? new Tile(i, 14, EnumTile.GHOST_ONLY) : (i == 5 || i > 6 && i < 10 || i > 17 && i < 21 || i == 22 ? new Tile(i, 14, 0) : new Tile(i, 14)))));
        }
        for (i = 0; i < 28; ++i) {
            this.tiles[15][i] = i >= 0 && i < 6 || i > 6 && i < 9 || i == 10 || i == 17 || i > 18 && i < 21 || i > 21 && i < 28 ? new Tile(i, 15, EnumTile.WALL) : (i == 9 || i == 18 ? new Tile(i, 15, 0) : (i > 10 && i < 17 ? new Tile(i, 15, EnumTile.GHOST_ONLY) : new Tile(i, 15)));
        }
        for (i = 0; i < 28; ++i) {
            this.tiles[16][i] = i >= 0 && i < 6 || i > 6 && i < 9 || i > 9 && i < 18 || i > 18 && i < 21 || i > 21 && i < 28 ? new Tile(i, 16, EnumTile.WALL) : (i == 9 || i == 18 ? new Tile(i, 16, 0) : new Tile(i, 16));
        }
        for (i = 0; i < 28; ++i) {
            this.tiles[17][i] = i >= 0 && i < 6 || i > 6 && i < 9 || i > 18 && i < 21 || i > 21 && i < 28 ? new Tile(i, 17, EnumTile.WALL) : (i > 8 && i < 19 ? new Tile(i, 17, 0) : new Tile(i, 17));
        }
        for (i = 0; i < 28; ++i) {
            this.tiles[18][i] = i >= 0 && i < 6 || i > 6 && i < 9 || i > 9 && i < 18 || i > 18 && i < 21 || i > 21 && i < 28 ? new Tile(i, 18, EnumTile.WALL) : (i == 9 || i == 18 ? new Tile(i, 18, 0) : new Tile(i, 18));
        }
        for (i = 0; i < 28; ++i) {
            this.tiles[19][i] = i >= 0 && i < 6 || i > 6 && i < 9 || i > 9 && i < 18 || i > 18 && i < 21 || i > 21 && i < 28 ? new Tile(i, 19, EnumTile.WALL) : (i == 9 || i == 18 ? new Tile(i, 19, 0) : new Tile(i, 19));
        }
        for (i = 0; i < 28; ++i) {
            this.tiles[20][i] = i == 0 || i > 12 && i < 15 || i == 27 ? new Tile(i, 20, EnumTile.WALL) : new Tile(i, 20);
        }
        for (i = 0; i < 28; ++i) {
            this.tiles[21][i] = i == 0 || i > 1 && i < 6 || i > 6 && i < 12 || i > 12 && i < 15 || i > 15 && i < 21 || i > 21 && i < 26 || i == 27 ? new Tile(i, 21, EnumTile.WALL) : new Tile(i, 21);
        }
        for (i = 0; i < 28; ++i) {
            this.tiles[22][i] = i == 0 || i > 1 && i < 6 || i > 6 && i < 12 || i > 12 && i < 15 || i > 15 && i < 21 || i > 21 && i < 26 || i == 27 ? new Tile(i, 22, EnumTile.WALL) : new Tile(i, 22);
        }
        for (i = 0; i < 28; ++i) {
            this.tiles[23][i] = i == 0 || i > 3 && i < 6 || i > 21 && i < 24 || i == 27 ? new Tile(i, 23, EnumTile.WALL) : (i == 1 || i == 26 ? new Tile(i, 23, 2) : (i > 9 && i < 13 || i > 14 & i < 18 ? new Tile(i, 23, EnumTile.GHOST_LIMIT, 1) : (i > 12 && i < 15 ? new Tile(i, 23, EnumTile.GHOST_LIMIT) : (i == 13 || i == 14 ? new Tile(i, 23, 0) : new Tile(i, 23)))));
        }
        for (i = 0; i < 28; ++i) {
            this.tiles[24][i] = i >= 0 && i < 3 || i > 3 && i < 6 || i > 6 && i < 9 || i > 9 && i < 18 || i > 18 && i < 21 || i > 21 && i < 24 || i > 24 ? new Tile(i, 24, EnumTile.WALL) : new Tile(i, 24);
        }
        for (i = 0; i < 28; ++i) {
            this.tiles[25][i] = i >= 0 && i < 3 || i > 3 && i < 6 || i > 6 && i < 9 || i > 9 && i < 18 || i > 18 && i < 21 || i > 21 && i < 24 || i > 24 ? new Tile(i, 25, EnumTile.WALL) : new Tile(i, 25);
        }
        for (i = 0; i < 28; ++i) {
            this.tiles[26][i] = i == 0 || i > 6 && i < 9 || i > 12 && i < 15 || i > 18 && i < 21 || i == 27 ? new Tile(i, 26, EnumTile.WALL) : new Tile(i, 26);
        }
        for (i = 0; i < 28; ++i) {
            this.tiles[27][i] = i == 0 || i > 1 && i < 12 || i > 12 && i < 15 || i > 15 && i < 26 || i == 27 ? new Tile(i, 27, EnumTile.WALL) : new Tile(i, 27);
        }
        for (i = 0; i < 28; ++i) {
            this.tiles[28][i] = i == 0 || i > 1 && i < 12 || i > 12 && i < 15 || i > 15 && i < 26 || i == 27 ? new Tile(i, 28, EnumTile.WALL) : new Tile(i, 28);
        }
        for (i = 0; i < 28; ++i) {
            this.tiles[29][i] = i == 0 || i == 27 ? new Tile(i, 29, EnumTile.WALL) : new Tile(i, 29);
        }
        for (i = 0; i < 28; ++i) {
            this.tiles[30][i] = new Tile(i, 30, EnumTile.WALL);
        }
    }

    private class Mover {
        Direction current;
        Direction desired;
        int x;
        int y;
        int x1;
        int y1;
        float moveX;
        float moveY;
        int extendedX;
        int extendedY;
        int offsetX;
        int offsetY;
        public boolean canMove;

        private Mover(int x, int y) {
            this.setStartPos(x, y);
        }

        public Mover updatePosition(int x, int y) {
            this.extendedX = (int)((float)(this.x1 + x) + this.moveX);
            this.extendedY = (int)((float)(this.y1 + y) + this.moveY);
            this.offsetX = x;
            this.offsetY = y;
            if ((this.extendedX - x) % 8 == 0) {
                this.x = (this.extendedX - x) / 8;
            }
            if ((this.extendedY - y) % 8 == 0) {
                this.y = (this.extendedY - y) / 8;
            }
            return this;
        }

        public void setStartPos(int x, int y) {
            this.x1 = x * 8 - 4;
            this.y1 = y * 8;
            this.x = x;
            this.y = y;
        }

        public boolean isBlocked() {
            return ((GuiPacMan)GuiPacMan.this).tiles[Math.max((int)0, (int)(this.y - 1))][this.x].type == EnumTile.WALL;
        }

        public boolean isBlockedDown() {
            return ((GuiPacMan)GuiPacMan.this).tiles[this.y + 1][this.x].type == EnumTile.WALL || ((GuiPacMan)GuiPacMan.this).tiles[this.y + 1][this.x].type == EnumTile.GHOST_ONLY;
        }

        boolean isBlockedLeft() {
            return ((GuiPacMan)GuiPacMan.this).tiles[this.y][Math.max((int)0, (int)(this.x - 1))].type == EnumTile.WALL;
        }

        boolean isBlockedRight() {
            return ((GuiPacMan)GuiPacMan.this).tiles[this.y][Math.min((int)27, (int)(this.x + 1))].type == EnumTile.WALL;
        }

        boolean onTile() {
            return (this.extendedX - this.offsetX) % 8 == 0 && (this.extendedY - this.offsetY) % 8 == 0;
        }

        EnumTile checkTile() {
            return ((GuiPacMan)GuiPacMan.this).tiles[this.y][this.x].type;
        }

        public Point getPosition() {
            return new Point(this.x, this.y);
        }

        public Tile getTile() {
            return GuiPacMan.this.tiles[this.y][this.x];
        }

        public void update() {
        }
    }

    private class Ghost
    extends Mover {
        EnumGhost info;
        boolean scared;
        boolean eaten;
        boolean scatter;
        boolean inHouse;
        boolean blink;
        boolean beScared;
        boolean isScared;
        int SCARED_STATE;
        int BODY_STATE;
        int modeTime;
        int mode;
        int blinks;
        int scaredTick;
        int pauseTick;
        int scaredDuration;
        int dotCounter;
        boolean remove;
        boolean beRemoved;

        public Ghost(EnumGhost ghost) {
            super(ghost.getX(), ghost.getY());
            this.scared = false;
            this.eaten = false;
            this.scatter = true;
            this.SCARED_STATE = 0;
            this.BODY_STATE = 0;
            this.dotCounter = 0;
            this.info = ghost;
            if (ghost != EnumGhost.BLINKY) {
                this.inHouse = true;
                this.current = this.desired = Direction.UP;
                GuiPacMan.this.houseQueue.add(this.info.id);
            } else {
                this.current = this.desired = Direction.LEFT;
            }
        }

        private boolean isEven(int n) {
            return n % 2 == 0;
        }

        private Mover move() {
            if (this.inHouse) {
                if (this.current == Direction.UP) {
                    this.moveY -= 0.5f;
                }
                if (this.current == Direction.DOWN) {
                    this.moveY += 0.5f;
                }
                if (this.extendedY == this.offsetY + 104 + 4) {
                    this.current = Direction.DOWN;
                }
                if (this.extendedY == this.offsetY + 120 - 4) {
                    this.current = Direction.UP;
                }
            } else if (this.beRemoved) {
                if (this.current == Direction.RIGHT) {
                    this.moveX += 0.5f;
                }
                if (this.current == Direction.LEFT) {
                    this.moveX -= 0.5f;
                }
                if (this.current == Direction.UP) {
                    this.moveY -= 0.5f;
                }
                if (this.extendedX == this.offsetX + 88 + 4) {
                    this.current = Direction.RIGHT;
                }
                if (this.extendedX == this.offsetX + 120 + 4) {
                    this.current = Direction.LEFT;
                }
                if (this.extendedX == this.offsetX + 112 - 4) {
                    this.current = Direction.UP;
                }
                if (this.extendedY == this.offsetY + 88) {
                    this.beRemoved = false;
                    this.remove = true;
                    this.current = this.info == EnumGhost.BLINKY || this.info == EnumGhost.INKY ? Direction.RIGHT : Direction.LEFT;
                }
            } else {
                if (this.desired != this.current) {
                    this.changeDirection(this.desired);
                }
                if (this.checkTile() == EnumTile.TELE_ZONE || this.checkTile() == EnumTile.TELE) {
                    if (this.info == EnumGhost.BLINKY || this.info == EnumGhost.PINKY) {
                        if (this.extendedX <= this.offsetX + 2 && this.y == 14) {
                            this.moveX = 100.0f;
                        }
                        if (this.extendedX >= this.offsetX + 208 && this.y == 14) {
                            this.moveX = -103.0f;
                        }
                    } else if (this.info == EnumGhost.INKY) {
                        if (this.extendedX <= this.offsetX + 2 && this.y == 14) {
                            this.moveX = 116.0f;
                        }
                        if (this.extendedX >= this.offsetX + 208 && this.y == 14) {
                            this.moveX = -85.0f;
                        }
                    } else if (this.info == EnumGhost.CLYDE) {
                        if (this.extendedX <= this.offsetX + 2 && this.y == 14) {
                            this.moveX = 84.0f;
                        }
                        if (this.extendedX >= this.offsetX + 208 && this.y == 14) {
                            this.moveX = -120.0f;
                        }
                    }
                }
                if (this.beScared) {
                    this.beScared = false;
                    this.isScared = true;
                    if (!this.eaten) {
                        switch (this.current) {
                            case LEFT: {
                                if (!this.isBlockedRight()) {
                                    this.desired = this.current = Direction.RIGHT;
                                    break;
                                }
                                if (!this.isBlocked()) {
                                    this.desired = this.current = Direction.UP;
                                }
                                if (!this.isBlockedDown()) {
                                    this.desired = this.current = Direction.DOWN;
                                }
                                if (this.isBlockedLeft()) break;
                                this.desired = this.current = Direction.LEFT;
                                break;
                            }
                            case RIGHT: {
                                if (!this.isBlockedLeft()) {
                                    this.desired = this.current = Direction.LEFT;
                                    break;
                                }
                                if (!this.isBlocked()) {
                                    this.desired = this.current = Direction.UP;
                                }
                                if (!this.isBlockedDown()) {
                                    this.desired = this.current = Direction.DOWN;
                                }
                                if (this.isBlockedRight()) break;
                                this.desired = this.current = Direction.RIGHT;
                                break;
                            }
                            case UP: {
                                if (!this.isBlockedDown()) {
                                    this.desired = this.current = Direction.DOWN;
                                    break;
                                }
                                if (!this.isBlockedLeft()) {
                                    this.desired = this.current = Direction.LEFT;
                                }
                                if (!this.isBlockedRight()) {
                                    this.desired = this.current = Direction.RIGHT;
                                }
                                if (this.isBlocked()) break;
                                this.desired = this.current = Direction.UP;
                                break;
                            }
                            case DOWN: {
                                if (!this.isBlocked()) {
                                    this.desired = this.current = Direction.UP;
                                    break;
                                }
                                if (!this.isBlockedLeft()) {
                                    this.desired = this.current = Direction.LEFT;
                                }
                                if (!this.isBlockedRight()) {
                                    this.desired = this.current = Direction.RIGHT;
                                }
                                if (this.isBlockedDown()) break;
                                this.desired = this.current = Direction.DOWN;
                            }
                        }
                    }
                }
                if (this.canMove) {
                    switch (this.current) {
                        case LEFT: {
                            if (!this.isBlockedLeft()) {
                                this.moveX -= this.getSpeed();
                            }
                            return this;
                        }
                        case RIGHT: {
                            if (!this.isBlockedRight()) {
                                this.moveX += this.getSpeed();
                            }
                            return this;
                        }
                        case UP: {
                            if (!this.isBlocked()) {
                                this.moveY -= this.getSpeed();
                            }
                            return this;
                        }
                        case DOWN: {
                            if (!this.isBlockedDown()) {
                                this.moveY += this.getSpeed();
                            }
                            return this;
                        }
                    }
                }
            }
            return this;
        }

        private float getSpeed() {
            if (GuiPacMan.this.level == 0) {
                if (!this.eaten) {
                    if (this.scared) {
                        if (((GuiPacMan)GuiPacMan.this).tiles[this.y][this.x].type == EnumTile.TELE_ZONE) {
                            return 0.4f;
                        }
                        return 0.5f;
                    }
                    if (((GuiPacMan)GuiPacMan.this).tiles[this.y][this.x].type == EnumTile.TELE_ZONE) {
                        return 0.4f;
                    }
                    return 0.75f;
                }
                return 1.0f;
            }
            if (GuiPacMan.this.level >= 1 && GuiPacMan.this.level <= 3) {
                if (!this.eaten) {
                    if (this.scared) {
                        if (((GuiPacMan)GuiPacMan.this).tiles[this.y][this.x].type == EnumTile.TELE_ZONE) {
                            return 0.45f;
                        }
                        return 0.55f;
                    }
                    if (((GuiPacMan)GuiPacMan.this).tiles[this.y][this.x].type == EnumTile.TELE_ZONE) {
                        return 0.45f;
                    }
                    return 0.85f;
                }
                return 1.0f;
            }
            if (GuiPacMan.this.level >= 4 && GuiPacMan.this.level <= 15 || GuiPacMan.this.level == 17) {
                if (!this.eaten) {
                    if (this.scared) {
                        if (((GuiPacMan)GuiPacMan.this).tiles[this.y][this.x].type == EnumTile.TELE_ZONE) {
                            return 0.5f;
                        }
                        return 0.6f;
                    }
                    if (((GuiPacMan)GuiPacMan.this).tiles[this.y][this.x].type == EnumTile.TELE_ZONE) {
                        return 0.5f;
                    }
                    return 0.95f;
                }
                return 1.0f;
            }
            if (GuiPacMan.this.level == 16 || GuiPacMan.this.level >= 18) {
                if (((GuiPacMan)GuiPacMan.this).tiles[this.y][this.x].type == EnumTile.TELE_ZONE) {
                    return 0.5f;
                }
                return 0.95f;
            }
            return 0.75f;
        }

        @Override
        public void update() {
            if ((this.extendedX - this.offsetX) / 8 == (((GuiPacMan)GuiPacMan.this).pacman.extendedX - this.offsetX) / 8 && (this.extendedY - this.offsetY) / 8 == (((GuiPacMan)GuiPacMan.this).pacman.extendedY - this.offsetY) / 8) {
                if (this.isScared) {
                    this.isScared = false;
                    this.pauseTick = GuiPacMan.this.tickCounter;
                    this.scaredDuration = GuiPacMan.this.tickCounter - this.scaredTick;
                    this.eaten = true;
                    GuiPacMan.this.pause();
                }
                if (this.scared && GuiPacMan.this.tickCounter - this.pauseTick == 20) {
                    GuiPacMan.this.unpause();
                    this.pauseTick = 0;
                    this.scaredTick = GuiPacMan.this.tickCounter + this.scaredDuration;
                    this.scared = false;
                    switch (((GuiPacMan)GuiPacMan.this).pacman.ghostsEaten) {
                        case 0: {
                            GuiPacMan.this.score = GuiPacMan.this.score + 200;
                            break;
                        }
                        case 1: {
                            GuiPacMan.this.score = GuiPacMan.this.score + 400;
                            break;
                        }
                        case 2: {
                            GuiPacMan.this.score = GuiPacMan.this.score + 800;
                            break;
                        }
                        case 3: {
                            GuiPacMan.this.score = GuiPacMan.this.score + 1600;
                        }
                    }
                    ++((GuiPacMan)GuiPacMan.this).pacman.ghostsEaten;
                }
            }
            if (this.eaten && this.x == 13 && this.y == 15) {
                this.isScared = false;
                this.scared = false;
                this.eaten = false;
                this.remove = true;
            }
            if (this.inHouse) {
                if (GuiPacMan.this.useGlobalCounter) {
                    if (GuiPacMan.this.globalCounter == this.info.getGlobalLimit()) {
                        this.inHouse = false;
                        this.beRemoved = true;
                        if ((Integer)GuiPacMan.this.houseQueue.get(0) == 3) {
                            GuiPacMan.this.useGlobalCounter = false;
                        }
                        GuiPacMan.this.houseQueue.remove(0);
                    }
                } else if (this.dotCounter == this.info.getDotLimit(GuiPacMan.this.level)) {
                    this.inHouse = false;
                    this.beRemoved = true;
                    GuiPacMan.this.houseQueue.remove(0);
                }
                if (GuiPacMan.this.tickCounter - GuiPacMan.this.dotTick == GuiPacMan.this.dotTimeLimit) {
                    GuiPacMan.this.dotTick = GuiPacMan.this.tickCounter;
                    this.inHouse = false;
                    this.beRemoved = true;
                    GuiPacMan.this.houseQueue.remove(0);
                }
            }
            if (this.remove && (this.x == 13 || this.x == 14) && this.y == 11) {
                this.remove = false;
            }
            if (GuiPacMan.this.level == 0) {
                if (this.mode == 0) {
                    this.modeTime = 7;
                } else if (this.mode == 1) {
                    this.modeTime = 20;
                } else if (this.mode == 2) {
                    this.modeTime = 7;
                } else if (this.mode == 3) {
                    this.modeTime = 20;
                } else if (this.mode == 4) {
                    this.modeTime = 5;
                } else if (this.mode == 5) {
                    this.modeTime = 20;
                } else if (this.mode == 6) {
                    this.modeTime = 5;
                } else if (this.mode >= 7) {
                    this.modeTime = 0;
                }
            }
            if (this.modeTime == 0) {
                this.scatter = false;
            } else if (GuiPacMan.this.tickCounter - GuiPacMan.this.scatterTick == this.modeTime * 20) {
                GuiPacMan.this.scatterTick = GuiPacMan.this.tickCounter;
                ++this.mode;
                boolean bl = this.scatter = !this.scatter;
            }
            if (!this.eaten) {
                if (((GuiPacMan)GuiPacMan.this).pacman.energizerMode && !this.scared || ((GuiPacMan)GuiPacMan.this).pacman.energizerMode && this.isScared) {
                    this.scared = true;
                    if (this.info == EnumGhost.CLYDE) {
                        ((GuiPacMan)GuiPacMan.this).pacman.energizerMode = false;
                    }
                    this.scaredTick = GuiPacMan.this.tickCounter;
                }
                if (this.scared && GuiPacMan.this.tickCounter - this.scaredTick == Math.max(GuiPacMan.this.scaredTime - 1, 0) * 20) {
                    this.scaredTick = GuiPacMan.this.tickCounter;
                    this.blink = true;
                }
                if (this.blink) {
                    if (GuiPacMan.this.tickCounter - this.scaredTick == 20 / GuiPacMan.this.scaredFlash) {
                        this.scaredTick = GuiPacMan.this.tickCounter;
                        this.SCARED_STATE = this.SCARED_STATE == 0 ? 1 : 0;
                        ++this.blinks;
                    }
                    if (this.blinks == GuiPacMan.this.scaredFlash) {
                        this.scaredTick = 0;
                        ((GuiPacMan)GuiPacMan.this).pacman.ghostsEaten = 0;
                        this.blinks = 0;
                        this.SCARED_STATE = 0;
                        this.isScared = false;
                        this.blink = false;
                        ((GuiPacMan)GuiPacMan.this).pacman.canEatGhost = false;
                        this.scared = false;
                    }
                }
            }
            if ((this.extendedX - this.offsetX) % 4 == 0 && (this.extendedY - this.offsetY) % 4 == 0) {
                this.BODY_STATE = this.BODY_STATE == 0 ? 1 : 0;
            }
        }

        private Mover changeDirection(Direction newDirection) {
            switch (newDirection) {
                case LEFT: {
                    if (this.current.getAxis() != newDirection.getAxis() && this.onTile() && !this.isBlockedLeft()) {
                        this.current = newDirection;
                    }
                    return this;
                }
                case RIGHT: {
                    if (this.current.getAxis() != newDirection.getAxis() && this.onTile() && !this.isBlockedRight()) {
                        this.current = newDirection;
                    }
                    return this;
                }
                case UP: {
                    if (this.current.getAxis() != newDirection.getAxis() && this.onTile() && !this.isBlocked()) {
                        this.current = newDirection;
                    }
                    return this;
                }
                case DOWN: {
                    if (this.current.getAxis() != newDirection.getAxis() && this.onTile() && !this.isBlockedDown()) {
                        this.current = newDirection;
                    }
                    return this;
                }
            }
            return this;
        }

        private double calculateDistance(int x, int y) {
            return Math.sqrt(Math.pow((double)x - this.getTarget().getX(), 2.0) + Math.pow((double)y - this.getTarget().getY(), 2.0));
        }

        private Ghost ai() {
            if (this.current == Direction.LEFT) {
                if (this.isBlockedLeft(this.x - 1, this.y)) {
                    if (!this.isBlockedDown(this.x - 1, this.y) && !this.isBlocked(this.x - 1, this.y)) {
                        this.desired = this.calculateDistance(this.extendedX - 8, this.extendedY - 8) < this.calculateDistance(this.extendedX - 8, this.extendedY + 8) ? Direction.UP : Direction.DOWN;
                    }
                    if (!this.isBlocked(this.x - 1, this.y) && this.isBlockedDown(this.x - 1, this.y)) {
                        this.desired = Direction.UP;
                    }
                    if (!this.isBlockedDown(this.x - 1, this.y) && this.isBlocked(this.x - 1, this.y)) {
                        this.desired = Direction.DOWN;
                    }
                } else {
                    if (!this.isBlockedDown(this.x - 1, this.y) && !this.isBlocked(this.x - 1, this.y)) {
                        if (this.calculateDistance(this.extendedX - 16, this.extendedY) < this.calculateDistance(this.extendedX - 8, this.extendedY - 8) && this.calculateDistance(this.extendedX - 16, this.extendedY) < this.calculateDistance(this.extendedX - 8, this.extendedY + 8)) {
                            this.desired = Direction.LEFT;
                        } else if (this.calculateDistance(this.extendedX - 8, this.extendedY - 8) < this.calculateDistance(this.extendedX - 8, this.extendedY + 8) && this.calculateDistance(this.extendedX - 8, this.extendedY - 8) < this.calculateDistance(this.extendedX - 16, this.extendedY)) {
                            this.desired = Direction.UP;
                        } else if (this.calculateDistance(this.extendedX - 8, this.extendedY + 8) < this.calculateDistance(this.extendedX - 16, this.extendedY) && this.calculateDistance(this.extendedX - 8, this.extendedY + 8) < this.calculateDistance(this.extendedX - 8, this.extendedY - 8)) {
                            this.desired = Direction.DOWN;
                        } else if (this.calculateDistance(this.extendedX - 8, this.extendedY + 8) == this.calculateDistance(this.extendedX - 16, this.extendedY) && this.calculateDistance(this.extendedX - 16, this.extendedY) == this.calculateDistance(this.extendedX - 8, this.extendedY - 8)) {
                            this.desired = Direction.DOWN;
                        }
                    }
                    if (!this.isBlocked(this.x - 1, this.y) && this.calculateDistance(this.extendedX - 8, this.extendedY - 8) < this.calculateDistance(this.extendedX - 16, this.extendedY)) {
                        this.desired = Direction.UP;
                    }
                    if (!this.isBlockedDown(this.x - 1, this.y) && this.calculateDistance(this.extendedX - 8, this.extendedY + 8) < this.calculateDistance(this.extendedX - 16, this.extendedY)) {
                        this.desired = Direction.DOWN;
                    }
                }
            }
            if (this.current == Direction.RIGHT) {
                if (this.isBlockedRight(this.x + 1, this.y)) {
                    if (!this.isBlockedDown(this.x + 1, this.y) && !this.isBlocked(this.x + 1, this.y)) {
                        this.desired = this.calculateDistance(this.extendedX + 8, this.extendedY - 8) < this.calculateDistance(this.extendedX + 8, this.extendedY + 8) ? Direction.UP : Direction.DOWN;
                    }
                    if (!this.isBlocked(this.x + 1, this.y) && this.isBlockedDown(this.x + 1, this.y)) {
                        this.desired = Direction.UP;
                    }
                    if (!this.isBlockedDown(this.x + 1, this.y) && this.isBlocked(this.x + 1, this.y)) {
                        this.desired = Direction.DOWN;
                    }
                } else {
                    if (!this.isBlockedDown(this.x + 1, this.y) && !this.isBlocked(this.x + 1, this.y)) {
                        if (this.calculateDistance(this.extendedX + 8, this.extendedY - 8) < this.calculateDistance(this.extendedX + 8, this.extendedY + 8) && this.calculateDistance(this.extendedX + 8, this.extendedY - 8) < this.calculateDistance(this.extendedX + 16, this.extendedY)) {
                            this.desired = Direction.UP;
                        } else if (this.calculateDistance(this.extendedX + 8, this.extendedY + 8) < this.calculateDistance(this.extendedX + 8, this.extendedY - 8) && this.calculateDistance(this.extendedX + 8, this.extendedY + 8) < this.calculateDistance(this.extendedX + 16, this.extendedY)) {
                            this.desired = Direction.DOWN;
                        } else if (this.calculateDistance(this.extendedX + 16, this.extendedY) < this.calculateDistance(this.extendedX + 8, this.extendedY + 8) && this.calculateDistance(this.extendedX + 16, this.extendedY) < this.calculateDistance(this.extendedX + 8, this.extendedY - 8)) {
                            this.desired = Direction.RIGHT;
                        } else if (this.calculateDistance(this.extendedX + 16, this.extendedY) == this.calculateDistance(this.extendedX + 8, this.extendedY + 8) && this.calculateDistance(this.extendedX + 8, this.extendedY + 8) == this.calculateDistance(this.extendedX + 8, this.extendedY - 8)) {
                            this.desired = Direction.UP;
                        }
                    }
                    if (!this.isBlocked(this.x + 1, this.y) && this.calculateDistance(this.extendedX + 8, this.extendedY - 8) < this.calculateDistance(this.extendedX + 16, this.extendedY)) {
                        this.desired = Direction.UP;
                    }
                    if (!this.isBlockedDown(this.x + 1, this.y) && this.calculateDistance(this.extendedX + 8, this.extendedY + 8) < this.calculateDistance(this.extendedX + 16, this.extendedY)) {
                        this.desired = Direction.DOWN;
                    }
                }
            }
            if (this.current == Direction.UP) {
                if (this.isBlocked(this.x, this.y - 1)) {
                    if (!this.isBlockedLeft(this.x, this.y - 1) && !this.isBlockedRight(this.x, this.y - 1)) {
                        this.desired = ((GuiPacMan)GuiPacMan.this).tiles[this.y - 1][this.x - 1].type == EnumTile.GHOST_LIMIT ? Direction.RIGHT : (((GuiPacMan)GuiPacMan.this).tiles[this.y - 1][this.x + 1].type == EnumTile.GHOST_LIMIT ? Direction.LEFT : (this.calculateDistance(this.extendedX - 8, this.extendedY - 8) < this.calculateDistance(this.extendedX + 8, this.extendedY - 8) ? Direction.LEFT : Direction.RIGHT));
                    }
                    if (!this.isBlockedLeft(this.x, this.y - 1) && this.isBlockedRight(this.x, this.y - 1)) {
                        this.desired = Direction.LEFT;
                    }
                    if (!this.isBlockedRight(this.x, this.y - 1) && this.isBlockedLeft(this.x, this.y - 1)) {
                        this.desired = Direction.RIGHT;
                    }
                } else {
                    if (!this.isBlockedRight(this.x, this.y - 1) && !this.isBlockedLeft(this.x, this.y - 1)) {
                        if (this.calculateDistance(this.extendedX - 8, this.extendedY - 8) < this.calculateDistance(this.extendedX + 8, this.extendedY - 8) && this.calculateDistance(this.extendedX - 8, this.extendedY - 8) < this.calculateDistance(this.extendedX, this.extendedY - 16)) {
                            this.desired = Direction.LEFT;
                        } else if (this.calculateDistance(this.extendedX + 8, this.extendedY - 8) < this.calculateDistance(this.extendedX - 8, this.extendedY - 8) && this.calculateDistance(this.extendedX + 8, this.extendedY - 8) < this.calculateDistance(this.extendedX, this.extendedY - 16)) {
                            this.desired = Direction.RIGHT;
                        } else if (this.calculateDistance(this.extendedX, this.extendedY - 16) < this.calculateDistance(this.extendedX - 8, this.extendedY - 8) && this.calculateDistance(this.extendedX, this.extendedY - 16) < this.calculateDistance(this.extendedX + 8, this.extendedY - 8)) {
                            this.desired = Direction.UP;
                        } else if (this.calculateDistance(this.extendedX - 8, this.extendedY - 8) == this.calculateDistance(this.extendedX + 8, this.extendedY - 8) && this.calculateDistance(this.extendedX + 8, this.extendedY - 8) == this.calculateDistance(this.extendedX, this.extendedY - 16)) {
                            this.desired = Direction.LEFT;
                        }
                    }
                    if (!this.isBlockedLeft(this.x, this.y - 1) && this.calculateDistance(this.extendedX - 8, this.extendedY - 8) < this.calculateDistance(this.extendedX, this.extendedY - 16)) {
                        this.desired = Direction.LEFT;
                    }
                    if (!this.isBlockedRight(this.x, this.y - 1) && this.calculateDistance(this.extendedX + 8, this.extendedY - 8) < this.calculateDistance(this.extendedX, this.extendedY - 16)) {
                        this.desired = Direction.RIGHT;
                    }
                }
            }
            if (this.current == Direction.DOWN) {
                if (this.isBlockedDown(this.x, this.y + 1)) {
                    if (!this.isBlockedLeft(this.x, this.y + 1) && !this.isBlockedRight(this.x, this.y + 1)) {
                        this.desired = this.calculateDistance(this.extendedX - 8, this.extendedY + 8) < this.calculateDistance(this.extendedX + 8, this.extendedY + 8) ? Direction.LEFT : Direction.RIGHT;
                    }
                    if (!this.isBlockedRight(this.x, this.y + 1) && this.isBlockedLeft(this.x, this.y + 1)) {
                        this.desired = Direction.RIGHT;
                    }
                    if (!this.isBlockedLeft(this.x, this.y + 1) && this.isBlockedRight(this.x, this.y + 1)) {
                        this.desired = Direction.LEFT;
                    }
                } else {
                    if (!this.isBlockedLeft(this.x, this.y + 1) && !this.isBlockedRight(this.x, this.y + 1)) {
                        if (this.calculateDistance(this.extendedX - 8, this.extendedY + 8) < this.calculateDistance(this.extendedX + 8, this.extendedY + 8) && this.calculateDistance(this.extendedX - 8, this.extendedY + 8) < this.calculateDistance(this.extendedX, this.extendedY + 16)) {
                            this.desired = Direction.LEFT;
                        } else if (this.calculateDistance(this.extendedX + 8, this.extendedY + 8) < this.calculateDistance(this.extendedX - 8, this.extendedY + 8) && this.calculateDistance(this.extendedX + 8, this.extendedY + 8) < this.calculateDistance(this.extendedX, this.extendedY + 16)) {
                            this.desired = Direction.RIGHT;
                        } else if (this.calculateDistance(this.extendedX, this.extendedY + 16) < this.calculateDistance(this.extendedX - 8, this.extendedY + 8) && this.calculateDistance(this.extendedX, this.extendedY + 16) < this.calculateDistance(this.extendedX + 8, this.extendedY + 8)) {
                            this.desired = Direction.DOWN;
                        } else if (this.calculateDistance(this.extendedX, this.extendedY + 16) == this.calculateDistance(this.extendedX - 8, this.extendedY + 8) && this.calculateDistance(this.extendedX - 8, this.extendedY + 8) == this.calculateDistance(this.extendedX + 8, this.extendedY + 8)) {
                            this.desired = Direction.RIGHT;
                        }
                    }
                    if (!this.isBlockedLeft(this.x, this.y + 1) && this.calculateDistance(this.extendedX - 8, this.extendedY + 8) < this.calculateDistance(this.extendedX, this.extendedY + 16)) {
                        this.desired = Direction.LEFT;
                    }
                    if (!this.isBlockedRight(this.x, this.y + 1) && this.calculateDistance(this.extendedX + 8, this.extendedY + 8) < this.calculateDistance(this.extendedX, this.extendedY + 16)) {
                        this.desired = Direction.RIGHT;
                    }
                }
            }
            return this;
        }

        private boolean isBlocked(int x, int y) {
            return ((GuiPacMan)GuiPacMan.this).tiles[Math.max((int)0, (int)(y - 1))][Math.max((int)0, (int)x)].type == EnumTile.WALL;
        }

        private boolean isBlockedDown(int x, int y) {
            return this.eaten || this.inHouse ? ((GuiPacMan)GuiPacMan.this).tiles[Math.min((int)30, (int)(y + 1))][Math.max((int)0, (int)x)].type == EnumTile.WALL : ((GuiPacMan)GuiPacMan.this).tiles[Math.min((int)30, (int)(y + 1))][Math.max((int)0, (int)x)].type == EnumTile.WALL || ((GuiPacMan)GuiPacMan.this).tiles[Math.min((int)30, (int)(y + 1))][x].type == EnumTile.GHOST_ONLY;
        }

        private boolean isBlockedLeft(int x, int y) {
            return ((GuiPacMan)GuiPacMan.this).tiles[y][Math.max((int)0, (int)(x - 1))].type == EnumTile.WALL;
        }

        private boolean isBlockedRight(int x, int y) {
            return ((GuiPacMan)GuiPacMan.this).tiles[y][Math.min((int)27, (int)(x + 1))].type == EnumTile.WALL;
        }

        @Override
        public boolean isBlockedDown() {
            return this.isBlockedDown(this.x, this.y);
        }

        private Point getTarget() {
            if (this.scared) {
                if (this.inHouse) {
                    return new Point(104 + this.offsetX, 120 + this.offsetY);
                }
                return new Point((int)(Math.random() * 28.0) * 8 + this.offsetX, (int)(Math.random() * 30.0) * 8 + this.offsetY);
            }
            if (this.eaten) {
                return new Point(104 + this.offsetX, 120 + this.offsetY);
            }
            if (this.inHouse) {
                return new Point(104 + this.offsetX, 120 + this.offsetY);
            }
            if (this.remove) {
                return new Point(104 + this.offsetX, 88 + this.offsetY);
            }
            switch (this.info) {
                case BLINKY: {
                    return this.scatter ? new Point(184 + this.offsetX, this.offsetY) : new Point(((GuiPacMan)GuiPacMan.this).pacman.getPosition().x * 8 + this.offsetX, ((GuiPacMan)GuiPacMan.this).pacman.getPosition().y * 8 + this.offsetY);
                }
                case INKY: {
                    switch (((GuiPacMan)GuiPacMan.this).pacman.current) {
                        case STAND: {
                            return this.scatter ? new Point(216 + this.offsetX, 240 + this.offsetY) : new Point(((GuiPacMan)GuiPacMan.this).pacman.getPosition().x * 8 + this.offsetX, ((GuiPacMan)GuiPacMan.this).pacman.getPosition().y * 8 + this.offsetY);
                        }
                        case LEFT: {
                            return this.scatter ? new Point(216 + this.offsetX, 240 + this.offsetY) : new Point((((GuiPacMan)GuiPacMan.this).pacman.getPosition().x - 3) * 8 + this.offsetX, (((GuiPacMan)GuiPacMan.this).pacman.getPosition().y + 1) * 8 + this.offsetY);
                        }
                        case RIGHT: {
                            return this.scatter ? new Point(216 + this.offsetX, 240 + this.offsetY) : new Point((((GuiPacMan)GuiPacMan.this).pacman.getPosition().x + 3) * 8 + this.offsetX, (((GuiPacMan)GuiPacMan.this).pacman.getPosition().y - 1) * 8 + this.offsetY);
                        }
                        case UP: {
                            return this.scatter ? new Point(216 + this.offsetX, 240 + this.offsetY) : new Point((((GuiPacMan)GuiPacMan.this).pacman.getPosition().x - 1) * 8 + this.offsetX, (((GuiPacMan)GuiPacMan.this).pacman.getPosition().y - 7) * 8 + this.offsetY);
                        }
                        case DOWN: {
                            return this.scatter ? new Point(216 + this.offsetX, 240 + this.offsetY) : new Point((((GuiPacMan)GuiPacMan.this).pacman.getPosition().x - 4) * 8 + this.offsetX, (((GuiPacMan)GuiPacMan.this).pacman.getPosition().y + 2) * 8 + this.offsetY);
                        }
                    }
                }
                case PINKY: {
                    switch (((GuiPacMan)GuiPacMan.this).pacman.current) {
                        case STAND: {
                            return this.scatter ? new Point(32 + this.offsetX, this.offsetY) : new Point(((GuiPacMan)GuiPacMan.this).pacman.getPosition().x * 8 + this.offsetX, ((GuiPacMan)GuiPacMan.this).pacman.getPosition().y * 8 + this.offsetY);
                        }
                        case LEFT: {
                            return this.scatter ? new Point(32 + this.offsetX, this.offsetY) : new Point(((GuiPacMan)GuiPacMan.this).pacman.getPosition().x * 8 + this.offsetX - 32, ((GuiPacMan)GuiPacMan.this).pacman.getPosition().y * 8 + this.offsetY);
                        }
                        case RIGHT: {
                            return this.scatter ? new Point(32 + this.offsetX, this.offsetY) : new Point(((GuiPacMan)GuiPacMan.this).pacman.getPosition().x * 8 + this.offsetX + 32, ((GuiPacMan)GuiPacMan.this).pacman.getPosition().y * 8 + this.offsetY);
                        }
                        case UP: {
                            return this.scatter ? new Point(32 + this.offsetX, this.offsetY) : new Point(((GuiPacMan)GuiPacMan.this).pacman.getPosition().x * 8 + this.offsetX - 32, ((GuiPacMan)GuiPacMan.this).pacman.getPosition().y * 8 + this.offsetY - 32);
                        }
                        case DOWN: {
                            return this.scatter ? new Point(32 + this.offsetX, this.offsetY) : new Point(((GuiPacMan)GuiPacMan.this).pacman.getPosition().x * 8 + this.offsetX, ((GuiPacMan)GuiPacMan.this).pacman.getPosition().y * 8 + this.offsetY + 32);
                        }
                    }
                }
                case CLYDE: {
                    int i;
                    if (this.scatter) {
                        return new Point(this.offsetX, 240 + this.offsetY);
                    }
                    for (i = 0; i < 4; ++i) {
                        if (this.extendedX > ((GuiPacMan)GuiPacMan.this).pacman.extendedX + 64 || this.extendedX < ((GuiPacMan)GuiPacMan.this).pacman.extendedX - 64 || this.extendedY > ((GuiPacMan)GuiPacMan.this).pacman.extendedY - 8 * i) continue;
                        return new Point(this.offsetX, 240 + this.offsetY);
                    }
                    for (i = 1; i < 4; ++i) {
                        if (this.extendedX > ((GuiPacMan)GuiPacMan.this).pacman.extendedX + 64 || this.extendedX < ((GuiPacMan)GuiPacMan.this).pacman.extendedX - 64 || this.extendedY > ((GuiPacMan)GuiPacMan.this).pacman.extendedY + 8 * i) continue;
                        return new Point(this.offsetX, 240 + this.offsetY);
                    }
                    for (i = 4; i < 6; ++i) {
                        if (this.extendedX > ((GuiPacMan)GuiPacMan.this).pacman.extendedX + 56 || this.extendedX < ((GuiPacMan)GuiPacMan.this).pacman.extendedX - 56 || this.extendedY > ((GuiPacMan)GuiPacMan.this).pacman.extendedY - 8 * i) continue;
                        return new Point(this.offsetX, 240 + this.offsetY);
                    }
                    for (i = 4; i < 6; ++i) {
                        if (this.extendedX > ((GuiPacMan)GuiPacMan.this).pacman.extendedX + 56 || this.extendedX < ((GuiPacMan)GuiPacMan.this).pacman.extendedX - 56 || this.extendedY > ((GuiPacMan)GuiPacMan.this).pacman.extendedY + 8 * i) continue;
                        return new Point(this.offsetX, 240 + this.offsetY);
                    }
                    if (this.extendedX <= ((GuiPacMan)GuiPacMan.this).pacman.extendedX + 48 && this.extendedX >= ((GuiPacMan)GuiPacMan.this).pacman.extendedX - 48 && this.extendedY <= ((GuiPacMan)GuiPacMan.this).pacman.extendedY - 48) {
                        return new Point(this.offsetX, 240 + this.offsetY);
                    }
                    if (this.extendedX <= ((GuiPacMan)GuiPacMan.this).pacman.extendedX + 48 && this.extendedX >= ((GuiPacMan)GuiPacMan.this).pacman.extendedX - 48 && this.extendedY <= ((GuiPacMan)GuiPacMan.this).pacman.extendedY + 48) {
                        return new Point(this.offsetX, 240 + this.offsetY);
                    }
                    if (this.extendedX <= ((GuiPacMan)GuiPacMan.this).pacman.extendedX + 40 && this.extendedX >= ((GuiPacMan)GuiPacMan.this).pacman.extendedX - 40 && this.extendedY <= ((GuiPacMan)GuiPacMan.this).pacman.extendedY - 56) {
                        return new Point(this.offsetX, 240 + this.offsetY);
                    }
                    if (this.extendedX <= ((GuiPacMan)GuiPacMan.this).pacman.extendedX + 40 && this.extendedX >= ((GuiPacMan)GuiPacMan.this).pacman.extendedX - 40 && this.extendedY <= ((GuiPacMan)GuiPacMan.this).pacman.extendedY + 56) {
                        return new Point(this.offsetX, 240 + this.offsetY);
                    }
                    if (this.extendedX <= ((GuiPacMan)GuiPacMan.this).pacman.extendedX + 24 && this.extendedX >= ((GuiPacMan)GuiPacMan.this).pacman.extendedX - 24 && this.extendedY <= ((GuiPacMan)GuiPacMan.this).pacman.extendedY - 64) {
                        return new Point(this.offsetX, 240 + this.offsetY);
                    }
                    if (this.extendedX <= ((GuiPacMan)GuiPacMan.this).pacman.extendedX + 24 && this.extendedX >= ((GuiPacMan)GuiPacMan.this).pacman.extendedX - 24 && this.extendedY <= ((GuiPacMan)GuiPacMan.this).pacman.extendedY + 64) {
                        return new Point(this.offsetX, 240 + this.offsetY);
                    }
                    return new Point(((GuiPacMan)GuiPacMan.this).pacman.getPosition().x * 8 + this.offsetX, ((GuiPacMan)GuiPacMan.this).pacman.getPosition().y * 8 + this.offsetY);
                }
            }
            return null;
        }

        private Ghost drawGhost() {
            if (this.scared) {
                if (this.SCARED_STATE == 0) {
                    GuiPacMan.this.glColor(new Color(33, 33, 222));
                } else {
                    GuiPacMan.this.glColor(new Color(245, 245, 255));
                }
            } else {
                GuiPacMan.this.glColor(this.info.getColor());
            }
            if (!this.eaten) {
                if (this.BODY_STATE == 0) {
                    Gui.func_146110_a((int)(this.extendedX - 3), (int)(this.extendedY - 3), (float)244.0f, (float)248.0f, (int)14, (int)14, (float)512.0f, (float)512.0f);
                } else {
                    Gui.func_146110_a((int)(this.extendedX - 3), (int)(this.extendedY - 3), (float)258.0f, (float)248.0f, (int)14, (int)14, (float)512.0f, (float)512.0f);
                }
            }
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            if (!this.scared) {
                switch (this.current) {
                    case LEFT: {
                        Gui.func_146110_a((int)(this.extendedX - 2), (int)this.extendedY, (float)240.0f, (float)256.0f, (int)4, (int)5, (float)512.0f, (float)512.0f);
                        Gui.func_146110_a((int)(this.extendedX + 4), (int)this.extendedY, (float)240.0f, (float)256.0f, (int)4, (int)5, (float)512.0f, (float)512.0f);
                        GuiPacMan.this.glColor(new Color(33, 33, 222));
                        Gui.func_146110_a((int)(this.extendedX - 2), (int)(this.extendedY + 2), (float)234.0f, (float)250.0f, (int)2, (int)2, (float)512.0f, (float)512.0f);
                        Gui.func_146110_a((int)(this.extendedX + 4), (int)(this.extendedY + 2), (float)234.0f, (float)250.0f, (int)2, (int)2, (float)512.0f, (float)512.0f);
                        break;
                    }
                    case RIGHT: {
                        Gui.func_146110_a((int)this.extendedX, (int)this.extendedY, (float)240.0f, (float)256.0f, (int)4, (int)5, (float)512.0f, (float)512.0f);
                        Gui.func_146110_a((int)(this.extendedX + 4 + 2), (int)this.extendedY, (float)240.0f, (float)256.0f, (int)4, (int)5, (float)512.0f, (float)512.0f);
                        GuiPacMan.this.glColor(new Color(33, 33, 222));
                        Gui.func_146110_a((int)(this.extendedX + 2), (int)(this.extendedY + 2), (float)234.0f, (float)250.0f, (int)2, (int)2, (float)512.0f, (float)512.0f);
                        Gui.func_146110_a((int)(this.extendedX + 4 + 4), (int)(this.extendedY + 2), (float)234.0f, (float)250.0f, (int)2, (int)2, (float)512.0f, (float)512.0f);
                        break;
                    }
                    case UP: {
                        Gui.func_146110_a((int)(this.extendedX - 1), (int)(this.extendedY - 2), (float)240.0f, (float)256.0f, (int)4, (int)5, (float)512.0f, (float)512.0f);
                        Gui.func_146110_a((int)(this.extendedX + 4 + 1), (int)(this.extendedY - 2), (float)240.0f, (float)256.0f, (int)4, (int)5, (float)512.0f, (float)512.0f);
                        GuiPacMan.this.glColor(new Color(33, 33, 222));
                        Gui.func_146110_a((int)this.extendedX, (int)(this.extendedY - 2), (float)234.0f, (float)250.0f, (int)2, (int)2, (float)512.0f, (float)512.0f);
                        Gui.func_146110_a((int)(this.extendedX + 4 + 2), (int)(this.extendedY - 2), (float)234.0f, (float)250.0f, (int)2, (int)2, (float)512.0f, (float)512.0f);
                        break;
                    }
                    case DOWN: {
                        Gui.func_146110_a((int)(this.extendedX - 1), (int)(this.extendedY + 1), (float)240.0f, (float)256.0f, (int)4, (int)5, (float)512.0f, (float)512.0f);
                        Gui.func_146110_a((int)(this.extendedX + 4 + 1), (int)(this.extendedY + 1), (float)240.0f, (float)256.0f, (int)4, (int)5, (float)512.0f, (float)512.0f);
                        GuiPacMan.this.glColor(new Color(33, 33, 222));
                        Gui.func_146110_a((int)this.extendedX, (int)(this.extendedY + 4), (float)234.0f, (float)250.0f, (int)2, (int)2, (float)512.0f, (float)512.0f);
                        Gui.func_146110_a((int)(this.extendedX + 4 + 2), (int)(this.extendedY + 4), (float)234.0f, (float)250.0f, (int)2, (int)2, (float)512.0f, (float)512.0f);
                    }
                }
            } else {
                if (this.SCARED_STATE == 0) {
                    GuiPacMan.this.glColor(new Color(245, 245, 255));
                } else {
                    GuiPacMan.this.glColor(new Color(255, 15, 15));
                }
                Gui.func_146110_a((int)(this.extendedX + 1), (int)(this.extendedY + 1), (float)234.0f, (float)250.0f, (int)2, (int)2, (float)512.0f, (float)512.0f);
                Gui.func_146110_a((int)(this.extendedX + 4 + 1), (int)(this.extendedY + 1), (float)234.0f, (float)250.0f, (int)2, (int)2, (float)512.0f, (float)512.0f);
                Gui.func_146110_a((int)(this.extendedX - 2), (int)(this.extendedY + 5), (float)234.0f, (float)262.0f, (int)12, (int)2, (float)512.0f, (float)512.0f);
            }
            return this;
        }
    }

    private class Player
    extends Mover {
        int lives;
        int foodEaten;
        int ghostsEaten;
        int deathAnimation;
        boolean energizerMode;
        boolean canEatGhost;
        boolean playDeathAnimation;
        int STATE;
        int prevX;
        int prevY;
        boolean teleport;
        boolean stopped;

        public Player() {
            super(14, 23);
            this.lives = 3;
            this.STATE = 0;
            this.stopped = false;
            this.prevX = 14;
            this.prevY = 23;
            this.teleport = false;
            this.current = this.desired = Direction.LEFT;
        }

        private Mover move() {
            if (this.desired != this.current) {
                this.changeDirection(this.desired);
            }
            if (this.checkTile() == EnumTile.TELE) {
                if (this.extendedX <= this.offsetX + 2) {
                    this.moveX = 103.0f;
                }
                if (this.extendedX >= this.offsetX + 216) {
                    this.moveX = -103.0f;
                }
            }
            if (this.canMove) {
                switch (this.current) {
                    case LEFT: {
                        if (!this.isBlockedLeft()) {
                            this.moveX -= this.getSpeed();
                        } else {
                            this.current = Direction.STAND;
                        }
                        return this;
                    }
                    case RIGHT: {
                        if (!this.isBlockedRight()) {
                            this.moveX += this.getSpeed();
                        } else {
                            this.current = Direction.STAND;
                        }
                        return this;
                    }
                    case UP: {
                        if (!this.isBlocked()) {
                            this.moveY -= this.getSpeed();
                        } else {
                            this.current = Direction.STAND;
                        }
                        return this;
                    }
                    case DOWN: {
                        if (!this.isBlockedDown()) {
                            this.moveY += this.getSpeed();
                        } else {
                            this.current = Direction.STAND;
                        }
                        return this;
                    }
                }
            }
            return this;
        }

        @Override
        public void update() {
            if (GuiPacMan.this.tiles[this.y][this.x].hasEdible()) {
                if (GuiPacMan.this.useGlobalCounter) {
                    GuiPacMan.this.globalCounter++;
                } else if (!GuiPacMan.this.houseQueue.isEmpty()) {
                    ++((GuiPacMan)GuiPacMan.this).ghosts[((Integer)((GuiPacMan)GuiPacMan.this).houseQueue.get((int)0)).intValue()].dotCounter;
                }
                GuiPacMan.this.dotTick = GuiPacMan.this.tickCounter;
            }
            if (((GuiPacMan)GuiPacMan.this).tiles[this.y][this.x].edible == 1) {
                ((GuiPacMan)GuiPacMan.this).tiles[this.y][this.x].edible = 0;
                ++this.foodEaten;
                GuiPacMan.this.score = GuiPacMan.this.score + 10;
                this.playWaka();
            }
            if (((GuiPacMan)GuiPacMan.this).tiles[this.y][this.x].edible == 2) {
                ((GuiPacMan)GuiPacMan.this).tiles[this.y][this.x].edible = 0;
                ++this.foodEaten;
                GuiPacMan.this.score = GuiPacMan.this.score + 50;
                this.energizerMode = true;
                for (int i = 0; i < GuiPacMan.this.ghosts.length; ++i) {
                    ((GuiPacMan)GuiPacMan.this).ghosts[i].beScared = true;
                }
                this.canEatGhost = true;
            }
            if (this.playDeathAnimation) {
                if (this.deathAnimation <= 12 && GuiPacMan.this.tickCounter - GuiPacMan.this.deathTick == 2) {
                    GuiPacMan.this.deathTick = GuiPacMan.this.tickCounter;
                    ++this.deathAnimation;
                }
                if (this.deathAnimation >= 12 && GuiPacMan.this.gameOverTick == 0) {
                    this.moveY = 0.0f;
                    this.moveX = 0.0f;
                    this.setStartPos(14, 23);
                    this.prevX = 14;
                    this.prevY = 23;
                    GuiPacMan.this.gameOverTick = GuiPacMan.this.tickCounter;
                }
                if (GuiPacMan.this.tickCounter - GuiPacMan.this.gameOverTick == 20) {
                    if (this.lives == 0) {
                        GuiPacMan.this.giveReward(ArcadeItems.TICKET, GuiPacMan.this.score / 200);
                        GuiPacMan.this.inMenu = true;
                        GuiPacMan.this.menu = 3;
                        this.playDeathAnimation = false;
                        GuiPacMan.this.backTick = GuiPacMan.this.tickCounter;
                        GuiPacMan.this.houseQueue.clear();
                        GuiPacMan.this.gameOver = (GuiPacMan.this.mazeBlink = (GuiPacMan.this.nextLevel = (GuiPacMan.this.updatePos = false)));
                    } else {
                        --this.lives;
                        GuiPacMan.this.setupGame();
                        this.deathAnimation = 0;
                        GuiPacMan.this.useGlobalCounter = true;
                        GuiPacMan.this.globalCounter = 0;
                        this.playDeathAnimation = false;
                        GuiPacMan.this.showBonus = false;
                        GuiPacMan.this.bonusTick = 0;
                    }
                }
            }
            if (GuiPacMan.this.showBonus && this.extendedX >= this.offsetX + 104 - 2 && this.extendedX <= this.offsetX + 104 + 2 && this.extendedY == this.offsetY + 136) {
                GuiPacMan.this.showBonus = false;
                GuiPacMan.this.bonusTick = 0;
                GuiPacMan.this.score = GuiPacMan.this.score + GuiPacMan.this.bonus.getPoints();
            }
        }

        public void kill() {
            this.playDeathAnimation = true;
            GuiPacMan.this.deathTick = GuiPacMan.this.tickCounter;
        }

        private void reset() {
            this.setStartPos(14, 23);
            this.prevX = 14;
            this.prevY = 23;
            this.moveY = 0.0f;
            this.moveX = 0.0f;
            this.teleport = false;
            GuiPacMan.this.useGlobalCounter = false;
            this.current = this.desired = Direction.LEFT;
        }

        private void playWaka() {
            if (GuiPacMan.this.waka == 0) {
                GuiPacMan.this.getWorld().func_184133_a(GuiPacMan.this.getPlayer(), GuiPacMan.this.getPos(), ArcadeSounds.PACMAN_WAKA_1, SoundCategory.BLOCKS, GuiPacMan.this.volume, 1.0f);
                GuiPacMan.this.waka++;
                return;
            }
            if (GuiPacMan.this.waka == 1) {
                GuiPacMan.this.getWorld().func_184133_a(GuiPacMan.this.getPlayer(), GuiPacMan.this.getPos(), ArcadeSounds.PACMAN_WAKA_2, SoundCategory.BLOCKS, GuiPacMan.this.volume, 1.0f);
                GuiPacMan.this.waka++;
                return;
            }
            if (GuiPacMan.this.waka == 2) {
                GuiPacMan.this.getWorld().func_184133_a(GuiPacMan.this.getPlayer(), GuiPacMan.this.getPos(), ArcadeSounds.PACMAN_WAKA_3, SoundCategory.BLOCKS, GuiPacMan.this.volume, 1.0f);
                GuiPacMan.this.waka++;
                return;
            }
            if (GuiPacMan.this.waka == 3) {
                GuiPacMan.this.getWorld().func_184133_a(GuiPacMan.this.getPlayer(), GuiPacMan.this.getPos(), ArcadeSounds.PACMAN_WAKA_4, SoundCategory.BLOCKS, GuiPacMan.this.volume, 1.0f);
                GuiPacMan.this.waka++;
                return;
            }
            if (GuiPacMan.this.waka == 4) {
                GuiPacMan.this.getWorld().func_184133_a(GuiPacMan.this.getPlayer(), GuiPacMan.this.getPos(), ArcadeSounds.PACMAN_WAKA_5, SoundCategory.BLOCKS, GuiPacMan.this.volume, 1.0f);
                GuiPacMan.this.waka++;
                return;
            }
            if (GuiPacMan.this.waka == 5) {
                GuiPacMan.this.getWorld().func_184133_a(GuiPacMan.this.getPlayer(), GuiPacMan.this.getPos(), ArcadeSounds.PACMAN_WAKA_6, SoundCategory.BLOCKS, GuiPacMan.this.volume, 1.0f);
                GuiPacMan.this.waka = 0;
                return;
            }
        }

        private float getSpeed() {
            if (GuiPacMan.this.level == 0) {
                if (!this.canEatGhost) {
                    if (((GuiPacMan)GuiPacMan.this).tiles[this.y][this.x].edible != 0) {
                        return 0.71f;
                    }
                } else {
                    if (((GuiPacMan)GuiPacMan.this).tiles[this.y][this.x].edible != 0) {
                        return 0.79f;
                    }
                    return 0.9f;
                }
                return 0.8f;
            }
            if (GuiPacMan.this.level >= 1 && GuiPacMan.this.level <= 3) {
                if (!this.canEatGhost) {
                    if (((GuiPacMan)GuiPacMan.this).tiles[this.y][this.x].edible != 0) {
                        return 0.79f;
                    }
                } else {
                    if (((GuiPacMan)GuiPacMan.this).tiles[this.y][this.x].edible != 0) {
                        return 0.83f;
                    }
                    return 0.95f;
                }
                return 0.9f;
            }
            if (GuiPacMan.this.level >= 4 && GuiPacMan.this.level <= 19) {
                if (!this.canEatGhost) {
                    if (((GuiPacMan)GuiPacMan.this).tiles[this.y][this.x].edible != 0) {
                        return 0.87f;
                    }
                } else {
                    if (((GuiPacMan)GuiPacMan.this).tiles[this.y][this.x].edible != 0) {
                        return 0.87f;
                    }
                    return 1.0f;
                }
                return 1.0f;
            }
            if (GuiPacMan.this.level >= 20) {
                if (((GuiPacMan)GuiPacMan.this).tiles[this.y][this.x].edible != 0) {
                    return 0.79f;
                }
                return 0.9f;
            }
            return 0.8f;
        }

        private Mover changeDirection(Direction newDirection) {
            switch (newDirection) {
                case LEFT: {
                    if (this.current.getAxis() != newDirection.getAxis()) {
                        if (this.onTile() && !this.isBlockedLeft()) {
                            this.current = newDirection;
                        }
                    } else if (!this.isBlockedLeft()) {
                        this.current = newDirection;
                    }
                    return this;
                }
                case RIGHT: {
                    if (this.current.getAxis() != newDirection.getAxis()) {
                        if (this.onTile() && !this.isBlockedRight()) {
                            this.current = newDirection;
                        }
                    } else if (!this.isBlockedRight()) {
                        this.current = newDirection;
                    }
                    return this;
                }
                case UP: {
                    if (this.current.getAxis() != newDirection.getAxis()) {
                        if (this.onTile() && !this.isBlocked()) {
                            this.current = newDirection;
                        }
                    } else if (!this.isBlocked()) {
                        this.current = newDirection;
                    }
                    return this;
                }
                case DOWN: {
                    if (this.current.getAxis() != newDirection.getAxis()) {
                        if (this.onTile() && !this.isBlockedDown()) {
                            this.current = newDirection;
                        }
                    } else if (!this.isBlockedDown()) {
                        this.current = newDirection;
                    }
                    return this;
                }
            }
            return this;
        }

        @Override
        public Player updatePosition(int x, int y) {
            super.updatePosition(x, y);
            if (this.x != this.prevX || this.y != this.prevY) {
                this.prevX = this.x;
                this.prevY = this.y;
                this.STATE = this.STATE == 0 ? 1 : 0;
            }
            return this;
        }

        private Player drawPlayer() {
            if (!GuiPacMan.this.gameOver) {
                GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
                switch (this.current) {
                    case STAND: {
                        Gui.func_146110_a((int)(this.extendedX - 4), (int)(this.extendedY - 4), (float)0.0f, (float)300.0f, (int)15, (int)15, (float)512.0f, (float)512.0f);
                        return this;
                    }
                    case LEFT: {
                        Gui.func_146110_a((int)(this.extendedX - 4), (int)(this.extendedY - 4), (float)(15 * this.STATE), (float)315.0f, (int)15, (int)15, (float)512.0f, (float)512.0f);
                        return this;
                    }
                    case RIGHT: {
                        Gui.func_146110_a((int)(this.extendedX - 4), (int)(this.extendedY - 4), (float)(15 * this.STATE), (float)300.0f, (int)15, (int)15, (float)512.0f, (float)512.0f);
                        return this;
                    }
                    case DOWN: {
                        Gui.func_146110_a((int)(this.extendedX - 4), (int)(this.extendedY - 4), (float)(15 * this.STATE), (float)345.0f, (int)15, (int)15, (float)512.0f, (float)512.0f);
                        return this;
                    }
                    case UP: {
                        Gui.func_146110_a((int)(this.extendedX - 4), (int)(this.extendedY - 4), (float)(15 * this.STATE), (float)330.0f, (int)15, (int)15, (float)512.0f, (float)512.0f);
                        return this;
                    }
                }
            } else {
                GuiPacMan.this.glColor(Color.WHITE);
                if (this.playDeathAnimation && this.deathAnimation <= 12) {
                    Gui.func_146110_a((int)(this.extendedX - 4), (int)(this.extendedY - 4), (float)(15 * this.deathAnimation), (float)330.0f, (int)15, (int)15, (float)512.0f, (float)512.0f);
                }
            }
            return this;
        }

        private Player drawLives() {
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            for (int i = 0; i < this.lives; ++i) {
                Gui.func_146110_a((int)(this.offsetX + i * 14), (int)(this.offsetY + 248), (float)15.0f, (float)315.0f, (int)15, (int)15, (float)512.0f, (float)512.0f);
            }
            return this;
        }
    }

    private class Tile {
        int x;
        int y;
        int extendedX;
        int extendedY;
        int edible = 0;
        EnumTile type;

        Tile(int x, int y) {
            this(x, y, EnumTile.PLAY, 1);
        }

        Tile(int x, int y, int edible) {
            this(x, y, EnumTile.PLAY, edible);
        }

        Tile(int x, int y, EnumTile type) {
            this(x, y, type, 0);
        }

        Tile(int x, int y, EnumTile type, int edible) {
            this.x = x;
            this.y = y;
            this.extendedX = x * 8 + GuiPacMan.this.boardX;
            this.extendedY = y * 8 + GuiPacMan.this.boardY;
            this.type = type;
            this.edible = edible;
        }

        Tile drawTile() {
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            if (this.edible == 1) {
                Gui.func_146110_a((int)(this.extendedX + 3), (int)(this.extendedY + 3), (float)234.0f, (float)248.0f, (int)2, (int)2, (float)512.0f, (float)512.0f);
            } else if (this.edible == 2 && GuiPacMan.this.ENERGIZER_STATE == 0) {
                Gui.func_146110_a((int)this.extendedX, (int)this.extendedY, (float)236.0f, (float)248.0f, (int)8, (int)8, (float)512.0f, (float)512.0f);
            }
            return this;
        }

        public boolean hasEdible() {
            return this.edible != 0;
        }

        Tile updatePosition(int x, int y) {
            this.extendedX = this.x * 8 + x;
            this.extendedY = this.y * 8 + y;
            return this;
        }

        public Point getPosition() {
            return new Point(this.x, this.y);
        }
    }

    private static enum EnumBonus {
        CHERRY(0, 100),
        STRAWBERRY(1, 300),
        PEACH(2, 500),
        APPLE(3, 700),
        GRAPES(4, 1000),
        GALAXIAN(5, 2000),
        BELL(6, 3000),
        KEY(8, 5000);

        private int id;
        private int points;

        private EnumBonus(int id, int points) {
            this.id = id;
            this.points = points;
        }

        public int getId() {
            return this.id;
        }

        public int getPoints() {
            return this.points;
        }

        public int getPoints(int id) {
            return EnumBonus.values()[id].points;
        }
    }

    private static enum EnumTile {
        PLAY(0, Color.GREEN),
        WALL(1, Color.RED),
        TELE(2, Color.YELLOW),
        TELE_ZONE(3, Color.ORANGE),
        GHOST_ONLY(4, Color.WHITE),
        GHOST_LIMIT(5, Color.MAGENTA);

        private int id;
        private Color color;

        private EnumTile(int id, Color color) {
            this.id = id;
            this.color = color;
        }

        public int getId() {
            return this.id;
        }

        public Color getColor() {
            return this.color;
        }
    }

    private static enum EnumGhost {
        BLINKY(0, "Blinky", 14, 11, new Color(255, 7, 7), 0),
        PINKY(1, "Pinky", 14, 14, new Color(255, 184, 222), 7),
        INKY(2, "Inky", 12, 14, new Color(7, 255, 255), 17, new int[]{30, 0, 0}),
        CLYDE(3, "Clyde", 16, 14, new Color(255, 159, 7), 32, new int[]{60, 50, 0});

        private int id;
        private String name;
        private int x;
        private int y;
        private Color color;
        private int globalLimit;
        private int[] dotLimit;

        private EnumGhost(int id, String name, int x, int y, Color color, int globalLimit) {
            this.id = id;
            this.name = name;
            this.x = x;
            this.y = y;
            this.color = color;
            this.globalLimit = globalLimit;
            this.dotLimit = new int[]{0, 0, 0};
        }

        private EnumGhost(int id, String name, int x, int y, Color color, int globalLimit, int[] dotLimit) {
            this.id = id;
            this.name = name;
            this.x = x;
            this.y = y;
            this.color = color;
            this.globalLimit = globalLimit;
            this.dotLimit = dotLimit;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public Color getColor() {
            return this.color;
        }

        public int getGlobalLimit() {
            return this.globalLimit;
        }

        public int[] getDotLimit() {
            return this.dotLimit;
        }

        public int getDotLimit(byte level) {
            if (level > 2) {
                return this.dotLimit[2];
            }
            return this.dotLimit[level];
        }
    }

    private static enum Direction {
        STAND(0, 0, 0),
        UP(1, 2, 1),
        DOWN(2, 1, 1),
        LEFT(3, 4, 2),
        RIGHT(4, 3, 2);

        private int direction;
        private int opposite;
        private int axis;

        private Direction(int direction, int opposite, int axis) {
            this.direction = direction;
            this.opposite = opposite;
            this.axis = axis;
        }

        public int getDirection() {
            return this.direction;
        }

        public Direction getOpposite() {
            return Direction.values()[this.opposite];
        }

        public int getAxis() {
            return this.axis;
        }
    }
}

