/*
 * Decompiled with CFR 0.152.
 */
package superhb.arcademod;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeVersion;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.versioning.ComparableVersion;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import superhb.arcademod.Reference;
import superhb.arcademod.client.ArcadeItems;
import superhb.arcademod.client.tileentity.TileEntityArcade;
import superhb.arcademod.client.tileentity.TileEntityPlushie;
import superhb.arcademod.client.tileentity.TileEntityPrize;
import superhb.arcademod.client.tileentity.TileEntityPusher;
import superhb.arcademod.proxy.CommonProxy;
import superhb.arcademod.util.PrizeList;
import superhb.arcademod.util.prizebox.PrizeHelper;

@Mod(modid="arcademod", name="Arcade Mod", version="2.1.5", updateJSON="https://raw.githubusercontent.com/KenLPham/ArcadeMod/update/update.json", acceptedMinecraftVersions="[1.12.2]")
public class Arcade {
    @SidedProxy(clientSide="superhb.arcademod.proxy.ClientProxy", serverSide="superhb.arcademod.proxy.CommonProxy")
    public static CommonProxy proxy;
    @Mod.Instance(value="arcademod")
    public static Arcade instance;
    public static final Logger logger;
    @MethodsReturnNonnullByDefault
    public static final CreativeTabs tab;
    public static Set<Map.Entry<ComparableVersion, String>> changelog;
    public static ForgeVersion.Status status;
    public static boolean disableCoins;
    private static boolean requireRedstone;
    public static boolean disableUpdateNotification;
    public static PrizeList[] prizeList;
    private static JsonObject json;
    private static File gameDir;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        event.getModMetadata().autogenerated = false;
        event.getModMetadata().credits = "";
        event.getModMetadata().authorList.add("SuperHB");
        event.getModMetadata().description = "Adds various arcade games to Minecraft";
        event.getModMetadata().url = "https://minecraft.curseforge.com/projects/arcade-mod/files";
        event.getModMetadata().logoFile = "logo.png";
        event.getModMetadata().updateJSON = "https://raw.githubusercontent.com/KenLPham/ArcadeMod/update/update.json";
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        disableCoins = config.getBoolean("disableCoins", "general", false, "Disable the need to use coins to play the arcade machines");
        requireRedstone = config.getBoolean("requireRedstone", "general", false, "Require the machines to be powered by redstone to play");
        disableUpdateNotification = config.getBoolean("disableUpdateNotification", "general", false, "Disable message in chat when update is available");
        config.save();
        gameDir = new File(event.getModConfigurationDirectory().getParent(), "/arcademod/games");
        if (!gameDir.exists()) {
            logger.info("Games Addon directory doesn't exist. Creating empty folder...");
            gameDir.mkdir();
            gameDir.mkdirs();
        }
        this.loadPrizeList(event);
        GameRegistry.registerTileEntity(TileEntityArcade.class, (ResourceLocation)Reference.createResource("tile_arcade"));
        GameRegistry.registerTileEntity(TileEntityPlushie.class, (ResourceLocation)Reference.createResource("tile_plushie"));
        GameRegistry.registerTileEntity(TileEntityPrize.class, (ResourceLocation)Reference.createResource("tile_prize"));
        GameRegistry.registerTileEntity(TileEntityPusher.class, (ResourceLocation)Reference.createResource("tile_pusher"));
        proxy.preInit(event);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.init(event);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        for (ModContainer mod : Loader.instance().getModList()) {
            if (!mod.getModId().equals("arcademod") || (status = ForgeVersion.getResult((ModContainer)mod).status) != ForgeVersion.Status.OUTDATED && status != ForgeVersion.Status.BETA_OUTDATED) continue;
            changelog = ForgeVersion.getResult((ModContainer)mod).changes.entrySet();
        }
        this.initPrizeList();
        proxy.postInit(event);
    }

    private void loadPrizeList(FMLPreInitializationEvent event) {
        String dir = event.getModConfigurationDirectory().getParent() + "/" + "arcademod" + "/prizelist.json";
        try {
            JsonParser parser = new JsonParser();
            JsonElement element = parser.parse((Reader)new FileReader(dir));
            json = element.getAsJsonObject();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            File list = new File(dir);
            try {
                list.createNewFile();
                this.exportResource("prizelist.json", dir);
                JsonParser parser = new JsonParser();
                JsonElement element = parser.parse((Reader)new FileReader(dir));
                json = element.getAsJsonObject();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void initPrizeList() {
        JsonArray prizes = json.getAsJsonArray("prizes");
        prizeList = new PrizeList[prizes.size()];
        for (int i = 0; i < prizes.size(); ++i) {
            try {
                Arcade.prizeList[i] = new PrizeList(PrizeHelper.getItemStack(prizes.get(i).getAsJsonObject()), JsonUtils.func_151203_m((JsonObject)prizes.get(i).getAsJsonObject(), (String)"cost"));
                continue;
            }
            catch (JsonSyntaxException e) {
                throw new JsonSyntaxException("Item is missing 'cost' member. Item will not be added to Prize Counter");
            }
        }
    }

    private void exportResource(String name, String dir) throws Exception {
        int readBytes;
        InputStream in = this.getClass().getClassLoader().getResourceAsStream(name);
        if (in == null) {
            throw new Exception(String.format("Cannot get resource '%s' from JAR file", name));
        }
        byte[] buffer = new byte[4096];
        FileOutputStream out = new FileOutputStream(dir);
        while ((readBytes = in.read(buffer)) > 0) {
            ((OutputStream)out).write(buffer, 0, readBytes);
        }
        in.close();
        ((OutputStream)out).close();
    }

    private void getAddons(List<File> games) {
        for (File game : games) {
            if (!game.isDirectory()) continue;
        }
    }

    static {
        logger = LogManager.getLogger((String)"arcademod");
        tab = new CreativeTabs("arcademod"){

            public ItemStack func_78016_d() {
                return new ItemStack(ArcadeItems.COIN);
            }

            public String func_78024_c() {
                return I18n.func_135052_a((String)"mod.arcademod:name.locale", (Object[])new Object[0]);
            }
        };
    }
}

