/*
 * Decompiled with CFR 0.152.
 */
package com.yyon.grapplinghook.network;

import com.yyon.grapplinghook.entities.grappleArrow;
import com.yyon.grapplinghook.grapplemod;
import com.yyon.grapplinghook.vec;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class GrappleAttachMessage
implements IMessage {
    public int id;
    public double x;
    public double y;
    public double z;
    public int controlid;
    public int entityid;
    public int maxlen;
    public BlockPos blockpos;

    public GrappleAttachMessage() {
    }

    public GrappleAttachMessage(int id, double x, double y, double z, int controlid, int entityid, int maxlen, BlockPos blockpos) {
        this.id = id;
        this.x = x;
        this.y = y;
        this.z = z;
        this.controlid = controlid;
        this.entityid = entityid;
        this.maxlen = maxlen;
        this.blockpos = blockpos;
    }

    public void fromBytes(ByteBuf buf) {
        this.id = buf.readInt();
        this.x = buf.readDouble();
        this.y = buf.readDouble();
        this.z = buf.readDouble();
        this.controlid = buf.readInt();
        this.entityid = buf.readInt();
        this.maxlen = buf.readInt();
        int blockx = buf.readInt();
        int blocky = buf.readInt();
        int blockz = buf.readInt();
        this.blockpos = new BlockPos(blockx, blocky, blockz);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.id);
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
        buf.writeInt(this.controlid);
        buf.writeInt(this.entityid);
        buf.writeInt(this.maxlen);
        buf.writeInt(this.blockpos.func_177958_n());
        buf.writeInt(this.blockpos.func_177956_o());
        buf.writeInt(this.blockpos.func_177952_p());
    }

    public static class Handler
    implements IMessageHandler<GrappleAttachMessage, IMessage> {
        public IMessage onMessage(GrappleAttachMessage message, MessageContext ctx) {
            Minecraft mainThread = Minecraft.func_71410_x();
            mainThread.func_152344_a((Runnable)new runner(message, ctx));
            return null;
        }

        public class runner
        implements Runnable {
            GrappleAttachMessage message;
            MessageContext ctx;

            public runner(GrappleAttachMessage message, MessageContext ctx) {
                this.message = message;
                this.ctx = ctx;
            }

            @Override
            public void run() {
                WorldClient world = Minecraft.func_71410_x().field_71441_e;
                Entity grapple = world.func_73045_a(this.message.id);
                if (grapple instanceof grappleArrow) {
                    ((grappleArrow)grapple).clientAttach(this.message.x, this.message.y, this.message.z);
                }
                grapplemod.createControl(this.message.controlid, this.message.id, this.message.entityid, (World)world, new vec(this.message.x, this.message.y, this.message.z), this.message.maxlen, this.message.blockpos);
            }
        }
    }
}

