/*
 * Decompiled with CFR 0.152.
 */
package com.yyon.grapplinghook.controllers;

import com.yyon.grapplinghook.entities.grappleArrow;
import com.yyon.grapplinghook.grapplemod;
import com.yyon.grapplinghook.network.GrappleEndMessage;
import com.yyon.grapplinghook.network.PlayerMovementMessage;
import com.yyon.grapplinghook.vec;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class grappleController {
    public int arrowId;
    public int entityId;
    public World world;
    public vec pos;
    public grappleArrow arrow;
    public Entity entity;
    public boolean attached = true;
    public double r;
    public vec motion;
    public double playerforward = 0.0;
    public double playerstrafe = 0.0;
    public boolean playerjump = false;
    public boolean waitingonplayerjump = false;
    public vec playermovement_unrotated = new vec(0.0, 0.0, 0.0);
    public vec playermovement = new vec(0.0, 0.0, 0.0);
    public int ongroundtimer = 0;
    public int maxongroundtimer = 3;
    public int maxlen;
    public int controllerid;
    public final double playermovementmult = 0.5;

    public grappleController(int arrowId, int entityId, World world, vec pos, int maxlen, int controllerid) {
        Entity arrowentity;
        this.arrowId = arrowId;
        this.entityId = entityId;
        this.world = world;
        this.pos = pos;
        this.maxlen = maxlen;
        this.controllerid = controllerid;
        this.entity = world.func_73045_a(entityId);
        this.r = this.pos.sub(vec.positionvec(this.entity)).length();
        this.motion = vec.motionvec(this.entity);
        this.ongroundtimer = 0;
        grapplemod.registerController(this.entityId, this);
        if (arrowId != -1 && (arrowentity = world.func_73045_a(arrowId)) != null && !arrowentity.field_70128_L && arrowentity instanceof grappleArrow) {
            this.arrow = (grappleArrow)arrowentity;
        }
    }

    public void unattach() {
        if (grapplemod.controllers.containsValue(this)) {
            this.attached = false;
            grapplemod.unregisterController(this.entityId);
            if (this.controllerid != grapplemod.AIRID) {
                grapplemod.network.sendToServer((IMessage)new GrappleEndMessage(this.entityId, this.arrowId));
                grapplemod.createControl(grapplemod.AIRID, -1, this.entityId, this.entity.field_70170_p, new vec(0.0, 0.0, 0.0), 0, null);
            }
        }
    }

    public grappleArrow getArrow() {
        return (grappleArrow)this.world.func_73045_a(this.arrowId);
    }

    public void doClientTick() {
        if (this.attached) {
            if (this.entity == null || this.entity.field_70128_L) {
                this.unattach();
            } else {
                grapplemod.proxy.getplayermovement(this, this.entityId);
                this.updatePlayerPos();
            }
        }
    }

    public void receivePlayerMovementMessage(float strafe, float forward, boolean jump) {
        this.playerforward = forward;
        this.playerstrafe = strafe;
        if (!jump) {
            this.playerjump = false;
        } else if (jump && !this.playerjump) {
            this.playerjump = true;
            this.waitingonplayerjump = true;
        }
        this.playermovement_unrotated = new vec(strafe, 0.0, forward);
        this.playermovement = this.playermovement_unrotated.rotate_yaw((float)((double)this.entity.field_70177_z * (Math.PI / 180)));
    }

    public boolean isjumping() {
        if (this.playerjump && this.waitingonplayerjump) {
            this.waitingonplayerjump = false;
            return true;
        }
        return false;
    }

    public void updatePlayerPos() {
        Entity entity = this.entity;
        if (this.attached && entity != null) {
            this.normalGround();
            this.normalCollisions();
            vec arrowpos = this.pos;
            vec playerpos = vec.positionvec(entity);
            vec oldspherevec = playerpos.sub(arrowpos);
            vec spherevec = oldspherevec.changelen(this.r);
            vec spherechange = spherevec.sub(oldspherevec);
            vec additionalmotion = arrowpos.sub(playerpos).length() < this.r ? new vec(0.0, 0.0, 0.0) : spherechange;
            double dist = oldspherevec.length();
            this.calctaut(dist);
            if (entity instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)entity;
                if (this.isjumping()) {
                    this.dojump((Entity)player, spherevec);
                    return;
                }
                if (grapplemod.proxy.isSneaking(entity)) {
                    if (arrowpos.y > playerpos.y) {
                        vec motiontorwards = spherevec.changelen(-0.1);
                        motiontorwards = new vec(motiontorwards.x, 0.0, motiontorwards.z);
                        if (this.motion.dot(motiontorwards) < 0.0) {
                            this.motion.add_ip(motiontorwards);
                        }
                        vec newmotion = this.dampenmotion(this.motion, motiontorwards);
                        this.motion = new vec(newmotion.x, this.motion.y, newmotion.z);
                        if (this.playerforward != 0.0 && (dist < (double)this.maxlen || this.playerforward > 0.0 || this.maxlen == 0)) {
                            additionalmotion = new vec(0.0, this.playerforward, 0.0);
                            this.r = dist;
                            this.r -= this.playerforward * 0.3;
                            if (this.r < 0.0) {
                                this.r = dist;
                            }
                        }
                    }
                } else {
                    this.applyPlayerMovement();
                }
            }
            if (this.ongroundtimer <= 0) {
                this.motion.add_ip(0.0, -0.05, 0.0);
            }
            vec newmotion = this.motion.add(additionalmotion);
            if (arrowpos.sub(playerpos.add(this.motion)).length() > this.r) {
                this.motion = this.motion.removealong(spherevec);
            }
            entity.field_70159_w = newmotion.x;
            entity.field_70181_x = newmotion.y;
            entity.field_70179_y = newmotion.z;
            this.updateServerPos();
        }
    }

    public void calctaut(double dist) {
        if (this.arrow != null) {
            if (dist < this.r) {
                double taut = 1.0 - (this.r - dist) / 5.0;
                if (taut < 0.0) {
                    taut = 0.0;
                }
                this.arrow.taut = taut;
            } else {
                this.arrow.taut = 1.0;
            }
        }
    }

    public void normalCollisions() {
        if (this.entity.field_70123_F) {
            if (this.entity.field_70159_w == 0.0) {
                this.motion.x = 0.0;
            }
            if (this.entity.field_70179_y == 0.0) {
                this.motion.z = 0.0;
            }
        }
        if (this.entity.field_70124_G && this.entity.field_70181_x == 0.0) {
            this.motion.y = 0.0;
        }
    }

    public void normalGround() {
        if (this.entity.field_70122_E) {
            this.ongroundtimer = this.maxongroundtimer;
            if (this.motion.y < 0.0) {
                this.motion.y = 0.0;
            }
        } else if (this.ongroundtimer > 0) {
            --this.ongroundtimer;
        }
        if (this.ongroundtimer > 0 && !grapplemod.proxy.isSneaking(this.entity)) {
            this.motion = vec.motionvec(this.entity);
        }
    }

    public void dojump(Entity player, double jumppower) {
        double maxjump = 1.0;
        if (this.ongroundtimer > 0) {
            this.ongroundtimer = 20;
            return;
        }
        if (player.field_70122_E) {
            jumppower = 0.0;
        }
        if (player.field_70132_H) {
            jumppower = maxjump;
        }
        if (jumppower < 0.0) {
            jumppower = 0.0;
        }
        this.unattach();
        if (jumppower > 0.0) {
            player.field_70181_x = jumppower > player.field_70181_x + jumppower ? jumppower : (player.field_70181_x += jumppower);
        }
        this.updateServerPos();
    }

    public void dojump(Entity player, vec spherevec) {
        double maxjump = 1.0;
        vec jump = new vec(0.0, maxjump, 0.0);
        if (spherevec != null) {
            jump = jump.proj(spherevec);
        }
        double jumppower = jump.y;
        if (spherevec != null && spherevec.y > 0.0) {
            jumppower = 0.0;
        }
        if (this.arrow != null && this.r < 1.0 && player.field_70163_u < this.arrow.field_70163_u) {
            jumppower = maxjump;
        }
        this.dojump(player, jumppower);
    }

    public vec dampenmotion(vec motion, vec forward) {
        vec newmotion = motion.proj(forward);
        double dampening = 0.05;
        return new vec(newmotion.x * dampening + motion.x * (1.0 - dampening), newmotion.y * dampening + motion.y * (1.0 - dampening), newmotion.z * dampening + motion.z * (1.0 - dampening));
    }

    public void updateServerPos() {
        grapplemod.network.sendToServer((IMessage)new PlayerMovementMessage(this.entityId, this.entity.field_70165_t, this.entity.field_70163_u, this.entity.field_70161_v, this.entity.field_70159_w, this.entity.field_70181_x, this.entity.field_70179_y));
    }

    public void receiveGrappleClick(boolean leftclick) {
        if (!leftclick) {
            this.unattach();
        }
    }

    public void receiveEnderLaunch(double x, double y, double z) {
        this.motion.add_ip(x, y, z);
        this.entity.field_70159_w = this.motion.x;
        this.entity.field_70181_x = this.motion.y;
        this.entity.field_70179_y = this.motion.z;
    }

    public void applyAirFriction() {
        double vel = this.motion.length();
        double dragforce = vel * vel / 200.0;
        vec airfric = new vec(this.motion.x, this.motion.y, this.motion.z);
        airfric.changelen_ip(-dragforce);
        this.motion.add_ip(airfric);
    }

    public void applyPlayerMovement() {
        System.out.println(this.motion.length());
        this.motion.add_ip(this.playermovement.changelen(0.015 + this.motion.length() * 0.01));
    }
}

