/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.util.stackable;

import com.enderio.core.EnderCore;
import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.stackable.BlockThing;
import com.enderio.core.common.util.stackable.IProducer;
import com.enderio.core.common.util.stackable.IThing;
import com.enderio.core.common.util.stackable.ItemStackThing;
import com.enderio.core.common.util.stackable.ItemThing;
import com.enderio.core.common.util.stackable.OreThing;
import com.enderio.core.common.util.stackable.ProducerThing;
import com.enderio.core.common.util.stackable.ResourceThing;
import com.enderio.core.common.util.stackable.StringThing;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;

public class Things {
    @Nonnull
    static final Map<String, IThing> aliases = new HashMap<String, IThing>();
    @Nonnull
    private static final List<Things> values = new ArrayList<Things>();
    private static boolean inPreInit = true;
    @Nonnull
    private final List<IThing> things = new ArrayList<IThing>();
    @Nonnull
    private final NNList<Item> itemList = new NNList();
    @Nonnull
    private final NNList<ItemStack> itemStackListRaw = new NNList();
    @Nonnull
    private final NNList<ItemStack> itemStackList = new NNList();
    @Nonnull
    private final NNList<Block> blockList = new NNList();

    public Things(String ... names) {
        this.init(names);
    }

    public Things() {
    }

    protected void init(String ... names) {
        for (String string : names) {
            this.add(string);
        }
        if (inPreInit) {
            values.add(this);
        }
    }

    public static void init(@Nullable FMLInitializationEvent event) {
        inPreInit = false;
        for (Things element : values) {
            element.bake();
        }
        values.clear();
    }

    @Nonnull
    public Things add(@Nullable Item item) {
        if (item != null) {
            this.add(new ItemThing(item));
        }
        return this;
    }

    public Things add(NNList<?> list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            if (o instanceof String) {
                this.add((String)o);
                continue;
            }
            if (o instanceof Item) {
                this.add((Item)o);
                continue;
            }
            if (o instanceof Block) {
                this.add((Block)o);
                continue;
            }
            if (o instanceof IProducer) {
                this.add((IProducer)o);
                continue;
            }
            if (o instanceof ItemStack) {
                this.add((ItemStack)o);
                continue;
            }
            if (o instanceof ResourceLocation) {
                this.add((ResourceLocation)o);
                continue;
            }
            if (o instanceof Things) {
                this.add((Things)o);
                continue;
            }
            if (o instanceof NNList) {
                this.add((NNList)((Object)o));
                continue;
            }
            throw new RuntimeException("Class " + o.getClass() + " is not suitable for Things");
        }
        return this;
    }

    @Nonnull
    public Things add(@Nullable ItemStack itemStack) {
        if (itemStack != null && !itemStack.isEmpty()) {
            this.add(new ItemStackThing(itemStack));
        }
        return this;
    }

    @Nonnull
    public Things add(@Nullable Block block) {
        if (block != null) {
            this.add(new BlockThing(block));
        }
        return this;
    }

    @Nonnull
    public Things add(@Nullable String name) {
        if (name != null) {
            this.add(new StringThing(name));
        }
        return this;
    }

    @Nonnull
    public Things add(@Nullable IProducer producer) {
        if (producer != null) {
            this.add(new ProducerThing(producer));
        }
        return this;
    }

    public static void addAlias(@Nullable String name, @Nullable String value) {
        if (name != null && value != null) {
            aliases.put(name, new StringThing(value));
        }
    }

    @Nonnull
    public Things add(@Nullable ResourceLocation resourceLocation) {
        if (resourceLocation != null) {
            this.add(new ResourceThing(resourceLocation));
        }
        return this;
    }

    @Nonnull
    public Things addOredict(@Nullable String name) {
        if (name != null) {
            this.add(new OreThing(name));
        }
        return this;
    }

    @Nonnull
    public Things add(@Nullable Things otherThings) {
        if (otherThings != null) {
            for (IThing thing : otherThings.things) {
                this.add(thing);
            }
        }
        return this;
    }

    private void add(@Nullable IThing thing) {
        IThing baked = !inPreInit && thing != null ? thing.bake() : thing;
        if (baked != null) {
            this.things.add(baked);
            this.itemList.clear();
            this.itemStackListRaw.clear();
            this.itemStackList.clear();
            this.blockList.clear();
        }
    }

    private void bake() {
        for (int i = 0; i < this.things.size(); ++i) {
            IThing thing = this.things.get(i);
            IThing bakedThing = thing.bake();
            if (bakedThing != null) {
                this.things.set(i, bakedThing);
                continue;
            }
            this.things.remove(i);
            --i;
        }
    }

    public boolean contains(@Nullable Item item) {
        if (item != Items.AIR) {
            for (IThing thing : this.things) {
                if (!thing.is(item)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean contains(@Nullable ItemStack itemStack) {
        if (itemStack != null && !itemStack.isEmpty()) {
            for (IThing thing : this.things) {
                if (!thing.is(itemStack)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean contains(@Nullable Block block) {
        if (block != Blocks.field_150350_a) {
            for (IThing thing : this.things) {
                if (!thing.is(block)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isEmpty() {
        return this.things.isEmpty();
    }

    public NNList<Item> getItems() {
        if (this.itemList.isEmpty()) {
            for (IThing thing : this.things) {
                this.itemList.addAll((Collection)((Object)thing.getItems()));
            }
        }
        return this.itemList;
    }

    public NNList<ItemStack> getItemStacksRaw() {
        if (this.itemStackListRaw.isEmpty()) {
            for (IThing thing : this.things) {
                this.itemStackListRaw.addAll((Collection)((Object)thing.getItemStacks()));
            }
        }
        return this.itemStackListRaw;
    }

    @Nonnull
    public NNList<ItemStack> getItemStacks() {
        if (this.itemStackList.isEmpty()) {
            Iterator iterator = this.getItemStacksRaw().iterator();
            while (iterator.hasNext()) {
                ItemStack stack = (ItemStack)iterator.next();
                if (stack.isEmpty()) continue;
                if (stack.func_77952_i() == Short.MAX_VALUE) {
                    EnderCore.proxy.getSubItems(stack.func_77973_b(), EnderCore.proxy.getCreativeTab(stack), this.itemStackList);
                    continue;
                }
                this.itemStackList.add(stack);
            }
        }
        return this.itemStackList;
    }

    @Nonnull
    public NNList<Block> getBlocks() {
        if (this.blockList.isEmpty()) {
            for (IThing thing : this.things) {
                this.blockList.addAll((Collection)((Object)thing.getBlocks()));
            }
        }
        return this.blockList;
    }

    public NNList<Object> getRecipeObjects() {
        NNList<Object> result = new NNList<Object>();
        for (IThing thing : this.things) {
            Object recipeObject = thing.getRecipeObject();
            if (recipeObject == null) continue;
            result.add(recipeObject);
        }
        return result;
    }
}

