/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.util.stackable;

import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.stackable.IProducer;
import com.enderio.core.common.util.stackable.Things;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class RebuildableThings
extends Things {
    @Nonnull
    private final NNList<String> nameList = new NNList();

    @Nonnull
    public NNList<String> getNameList() {
        return this.nameList;
    }

    public RebuildableThings(String ... names) {
        this.init(names);
    }

    @Override
    @Nonnull
    public Things add(@Nullable Item item) {
        if (item != null) {
            this.nameList.add("item:" + item.getRegistryName());
        }
        return super.add(item);
    }

    @Override
    @Nonnull
    public Things add(@Nullable ItemStack itemStack) {
        if (itemStack != null && !itemStack.isEmpty()) {
            this.nameList.add("item:" + itemStack.func_77973_b().getRegistryName());
        }
        return super.add(itemStack);
    }

    @Override
    @Nonnull
    public Things add(@Nullable Block block) {
        if (block != null) {
            this.nameList.add("block:" + block.getRegistryName());
        }
        return super.add(block);
    }

    @Override
    @Nonnull
    public Things add(@Nullable String name) {
        if (name != null) {
            this.nameList.add(name);
        }
        return super.add(name);
    }

    @Override
    @Nonnull
    public Things add(@Nullable IProducer producer) {
        if (producer != null) {
            Item item;
            Block block = producer.getBlock();
            if (block != null) {
                this.nameList.add("block:" + block.getRegistryName());
            }
            if ((item = producer.getItem()) != null) {
                this.nameList.add("item:" + item.getRegistryName());
            }
        }
        return super.add(producer);
    }

    @Override
    @Nonnull
    public Things add(@Nullable ResourceLocation resourceLocation) {
        if (resourceLocation != null) {
            Item item;
            if (Block.field_149771_c.func_148741_d((Object)resourceLocation)) {
                Block block = (Block)Block.field_149771_c.func_82594_a((Object)resourceLocation);
                this.nameList.add("block:" + block.getRegistryName());
            }
            if ((item = (Item)Item.field_150901_e.func_82594_a((Object)resourceLocation)) != null) {
                this.nameList.add("item:" + item.getRegistryName());
            }
        }
        return super.add(resourceLocation);
    }

    @Override
    @Nonnull
    public Things addOredict(@Nullable String name) {
        if (name != null) {
            this.nameList.add("oredict:" + name);
        }
        return super.addOredict(name);
    }

    @Override
    @Nonnull
    public Things add(@Nullable Things otherThings) {
        if (otherThings instanceof RebuildableThings) {
            this.nameList.addAll((Collection)((Object)((RebuildableThings)otherThings).nameList));
        }
        return super.add(otherThings);
    }
}

