/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.util.stackable;

import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.stackable.IThing;
import java.util.Collection;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

class OreThing
implements IThing {
    @Nonnull
    private final String name;
    @Nonnull
    private NNList<ItemStack> ores = new NNList();

    OreThing(@Nonnull String name) {
        this.name = name;
    }

    @Override
    @Nullable
    public IThing bake() {
        if (OreDictionary.doesOreNameExist((String)this.name)) {
            this.ores.clear();
            this.ores.addAll((Collection)OreDictionary.getOres((String)this.name));
            if (!this.ores.isEmpty()) {
                return this;
            }
        }
        return null;
    }

    @Override
    public boolean is(@Nullable Item item) {
        Iterator iterator = this.ores.iterator();
        while (iterator.hasNext()) {
            ItemStack oreStack = (ItemStack)iterator.next();
            if (oreStack.func_77973_b() != item) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean is(@Nullable ItemStack itemStack) {
        Iterator iterator = this.ores.iterator();
        while (iterator.hasNext()) {
            ItemStack oreStack = (ItemStack)iterator.next();
            if (itemStack == null || itemStack.isEmpty() || itemStack.func_77973_b() != oreStack.func_77973_b() || oreStack.func_77981_g() && oreStack.func_77952_i() != Short.MAX_VALUE && oreStack.func_77960_j() != itemStack.func_77960_j()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean is(@Nullable Block block) {
        Iterator iterator = this.ores.iterator();
        while (iterator.hasNext()) {
            ItemStack oreStack = (ItemStack)iterator.next();
            if (block == null || Item.func_150898_a((Block)block) != oreStack.func_77973_b() && Block.func_149634_a((Item)oreStack.func_77973_b()) != block) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    public NNList<Item> getItems() {
        NNList<Item> result = new NNList<Item>();
        Iterator iterator = this.ores.iterator();
        while (iterator.hasNext()) {
            ItemStack oreStack = (ItemStack)iterator.next();
            if (oreStack.isEmpty() || result.contains(oreStack.func_77973_b())) continue;
            result.add(oreStack.func_77973_b());
        }
        return result;
    }

    @Override
    @Nonnull
    public NNList<ItemStack> getItemStacks() {
        return this.ores;
    }

    @Override
    @Nonnull
    public NNList<Block> getBlocks() {
        NNList<Block> result = new NNList<Block>();
        Iterator iterator = this.ores.iterator();
        while (iterator.hasNext()) {
            Block block;
            ItemStack oreStack = (ItemStack)iterator.next();
            if (oreStack.isEmpty() || (block = Block.func_149634_a((Item)oreStack.func_77973_b())) == Blocks.field_150350_a) continue;
            result.add(block);
        }
        return result;
    }

    @Override
    @Nullable
    public Object getRecipeObject() {
        return this.name;
    }
}

