/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.network;

import com.enderio.core.client.gui.widget.GhostSlot;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketGhostSlot
implements IMessage {
    private int windowId;
    private int slot;
    private ItemStack stack;

    public static PacketGhostSlot setGhostSlotContents(int slot, ItemStack stack) {
        PacketGhostSlot msg = new PacketGhostSlot();
        msg.slot = slot;
        msg.stack = stack;
        msg.windowId = Minecraft.func_71410_x().field_71439_g.field_71070_bA.field_75152_c;
        return msg;
    }

    public void fromBytes(ByteBuf buf) {
        this.windowId = buf.readInt();
        this.slot = buf.readShort();
        this.stack = ByteBufUtils.readItemStack((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.windowId);
        buf.writeShort(this.slot);
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.stack);
    }

    public static class Handler
    implements IMessageHandler<PacketGhostSlot, IMessage> {
        public IMessage onMessage(PacketGhostSlot msg, MessageContext ctx) {
            Container openContainer = ctx.getServerHandler().field_147369_b.field_71070_bA;
            if (openContainer instanceof GhostSlot.IGhostSlotAware && openContainer.field_75152_c == msg.windowId) {
                ((GhostSlot.IGhostSlotAware)openContainer).setGhostSlotContents(msg.slot, msg.stack);
            }
            return null;
        }
    }
}

