/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.inventory;

import com.enderio.core.common.inventory.Callback;
import com.enderio.core.common.inventory.Filters;
import com.enderio.core.common.util.ItemUtil;
import com.google.common.base.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.items.IItemHandler;

public class InventorySlot
implements IItemHandler {
    @Nonnull
    private static final ItemStack LIE = new ItemStack(Blocks.field_150414_aQ, 0);
    @Nonnull
    private ItemStack itemStack;
    @Nonnull
    private final Predicate<ItemStack> filterIn;
    @Nonnull
    private final Predicate<ItemStack> filterOut;
    @Nonnull
    private final Callback<ItemStack> callback;
    private final int limit;
    @Nullable
    private TileEntity owner;

    public InventorySlot() {
        this(LIE, null, null, null, -1);
    }

    public InventorySlot(@Nullable Callback<ItemStack> callback) {
        this(LIE, null, null, callback, -1);
    }

    public InventorySlot(@Nonnull ItemStack itemStack) {
        this(itemStack, null, null, null, -1);
    }

    public InventorySlot(@Nonnull ItemStack itemStack, @Nullable Callback<ItemStack> callback) {
        this(itemStack, null, null, callback, -1);
    }

    public InventorySlot(@Nullable Predicate<ItemStack> filterIn, @Nullable Predicate<ItemStack> filterOut) {
        this(LIE, filterIn, filterOut, null, -1);
    }

    public InventorySlot(@Nullable Predicate<ItemStack> filterIn, @Nullable Predicate<ItemStack> filterOut, @Nullable Callback<ItemStack> callback) {
        this(LIE, filterIn, filterOut, callback, -1);
    }

    public InventorySlot(int limit) {
        this(LIE, null, null, null, limit);
    }

    public InventorySlot(@Nullable Callback<ItemStack> callback, int limit) {
        this(LIE, null, null, callback, limit);
    }

    public InventorySlot(@Nonnull ItemStack itemStack, int limit) {
        this(itemStack, null, null, null, limit);
    }

    public InventorySlot(@Nonnull ItemStack itemStack, @Nullable Callback<ItemStack> callback, int limit) {
        this(itemStack, null, null, callback, limit);
    }

    public InventorySlot(@Nullable Predicate<ItemStack> filterIn, int limit) {
        this(LIE, filterIn, null, null, limit);
    }

    public InventorySlot(@Nullable Predicate<ItemStack> filterIn, @Nullable Predicate<ItemStack> filterOut, int limit) {
        this(LIE, filterIn, filterOut, null, limit);
    }

    public InventorySlot(@Nullable Predicate<ItemStack> filterIn, @Nullable Predicate<ItemStack> filterOut, @Nullable Callback<ItemStack> callback, int limit) {
        this(LIE, filterIn, filterOut, callback, limit);
    }

    public InventorySlot(@Nonnull ItemStack itemStack, @Nullable Predicate<ItemStack> filterIn, @Nullable Predicate<ItemStack> filterOut) {
        this(itemStack, filterIn, filterOut, null, -1);
    }

    public InventorySlot(@Nonnull ItemStack itemStack, @Nullable Predicate<ItemStack> filterIn, @Nullable Predicate<ItemStack> filterOut, @Nullable Callback<ItemStack> callback) {
        this(itemStack, filterIn, filterOut, callback, -1);
    }

    public InventorySlot(@Nonnull ItemStack itemStack, @Nullable Predicate<ItemStack> filterIn, @Nullable Predicate<ItemStack> filterOut, int limit) {
        this(itemStack, filterIn, filterOut, null, limit);
    }

    public InventorySlot(@Nonnull ItemStack itemStack, @Nullable Predicate<ItemStack> filterIn, @Nullable Predicate<ItemStack> filterOut, @Nullable Callback<ItemStack> callback, int limit) {
        this.itemStack = itemStack;
        this.filterIn = filterIn != null ? filterIn : Filters.ALWAYS_TRUE;
        this.filterOut = filterOut != null ? filterOut : Filters.ALWAYS_TRUE;
        this.callback = callback != null ? callback : Filters.NO_CALLBACK;
        this.limit = limit > 0 ? limit : 64;
    }

    public int getSlots() {
        return 1;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return slot == 0 ? this.itemStack : LIE;
    }

    public boolean isItemValidForSlot(@Nonnull ItemStack stack) {
        return !stack.isEmpty() && this.filterIn.apply((Object)stack);
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (stack.isEmpty()) {
            return LIE;
        }
        if (slot == 0 && this.filterIn.apply((Object)stack)) {
            if (this.itemStack.isEmpty()) {
                int max = Math.min(this.limit, stack.func_77976_d());
                if (!simulate) {
                    this.itemStack = stack.func_77946_l();
                }
                if (stack.getCount() <= max) {
                    if (!simulate) {
                        this.onChange(LIE, this.itemStack);
                    }
                    return LIE;
                }
                if (!simulate) {
                    this.itemStack.setCount(max);
                    this.onChange(LIE, this.itemStack);
                }
                ItemStack result = stack.func_77946_l();
                result.shrink(max);
                return result;
            }
            if (ItemUtil.areStackMergable(this.itemStack, stack)) {
                int max = Math.min(this.limit, stack.func_77976_d());
                int target = this.itemStack.getCount() + stack.getCount();
                if (target <= max) {
                    if (!simulate) {
                        ItemStack oldStack = this.itemStack.func_77946_l();
                        this.itemStack.setCount(target);
                        this.onChange(oldStack, this.itemStack);
                    }
                    return LIE;
                }
                int tomove = max - this.itemStack.getCount();
                if (!simulate) {
                    ItemStack oldStack = this.itemStack.func_77946_l();
                    this.itemStack.setCount(max);
                    this.onChange(oldStack, this.itemStack);
                }
                ItemStack result = stack.func_77946_l();
                result.shrink(tomove);
                return result;
            }
        }
        return stack;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (slot == 0 && !this.itemStack.isEmpty() && this.filterOut.apply((Object)this.itemStack)) {
            if (amount >= this.itemStack.getCount()) {
                if (!simulate) {
                    ItemStack oldStack = this.itemStack;
                    this.itemStack = LIE;
                    this.onChange(oldStack, this.itemStack);
                    return oldStack;
                }
                return this.itemStack.func_77946_l();
            }
            if (!simulate) {
                ItemStack oldStack = this.itemStack.func_77946_l();
                this.itemStack.shrink(amount);
                this.onChange(oldStack, this.itemStack);
                oldStack.setCount(amount);
                return oldStack;
            }
            ItemStack result = this.itemStack.func_77946_l();
            result.setCount(amount);
            return result;
        }
        return LIE;
    }

    private void onChange(@Nonnull ItemStack oldStack, @Nonnull ItemStack newStack) {
        this.callback.onChange(oldStack, newStack);
        if (this.owner != null) {
            this.owner.func_70296_d();
        }
    }

    public void writeToNBT(@Nonnull NBTTagCompound tag) {
        if (!this.itemStack.isEmpty()) {
            this.itemStack.func_77955_b(tag);
        }
    }

    public void readFromNBT(@Nonnull NBTTagCompound tag) {
        this.itemStack = new ItemStack(tag);
    }

    public void clear() {
        this.itemStack = LIE;
    }

    public void set(@Nonnull ItemStack stack) {
        ItemStack oldStack = this.itemStack;
        this.itemStack = stack;
        this.onChange(oldStack, this.itemStack);
    }

    @Nonnull
    public ItemStack get() {
        return this.itemStack;
    }

    @Nonnull
    public ItemStack getCopy() {
        return this.itemStack.func_77946_l();
    }

    public boolean isEmpty() {
        return this.itemStack.isEmpty();
    }

    public int getMaxStackSize() {
        return this.limit;
    }

    void setOwner(@Nullable TileEntity owner) {
        this.owner = owner;
    }

    TileEntity getOwner() {
        return this.owner;
    }

    public int getSlotLimit(int slot) {
        return this.getMaxStackSize();
    }
}

