/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.config;

import com.enderio.core.common.config.ConfigProcessor;
import com.google.common.base.Throwables;
import io.netty.buffer.ByteBuf;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class PacketConfigSync
implements IMessage {
    private Map<String, Object> configValues;
    private String modid;

    public PacketConfigSync() {
    }

    public PacketConfigSync(ConfigProcessor toSync) {
        this.configValues = toSync.configValues;
        this.modid = toSync.modid;
    }

    public void toBytes(ByteBuf buf) {
        ByteArrayOutputStream obj = new ByteArrayOutputStream();
        try {
            GZIPOutputStream gzip = new GZIPOutputStream(obj);
            ObjectOutputStream objStream = new ObjectOutputStream(gzip);
            objStream.writeObject(this.configValues);
            objStream.close();
        }
        catch (IOException e) {
            Throwables.propagate((Throwable)e);
        }
        buf.writeShort(obj.size());
        buf.writeBytes(obj.toByteArray());
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.modid);
    }

    public void fromBytes(ByteBuf buf) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            return;
        }
        short len = buf.readShort();
        byte[] compressedBody = new byte[len];
        for (short i = 0; i < len; i = (short)(i + 1)) {
            compressedBody[i] = buf.readByte();
        }
        try {
            ValidatingObjectInputStream obj = new ValidatingObjectInputStream(new GZIPInputStream(new ByteArrayInputStream(compressedBody)));
            this.configValues = (Map)obj.readObject();
            obj.close();
        }
        catch (Exception e) {
            Throwables.propagate((Throwable)e);
        }
        this.modid = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    private static class ValidatingObjectInputStream
    extends ObjectInputStream {
        private static final List<String> WHITELIST = Arrays.asList("java.util.HashMap", "java.lang.Integer", "java.lang.Number", "java.lang.Boolean");
        private static final Logger logger = LogManager.getLogger();
        private static final Marker securityMarker = MarkerManager.getMarker((String)"SuspiciousPackets");

        private ValidatingObjectInputStream(InputStream in) throws IOException {
            super(in);
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            String name = desc.getName();
            if (!WHITELIST.contains(name)) {
                logger.warn(securityMarker, "Received packet containing disallowed class: " + name);
                throw new RuntimeException();
            }
            return super.resolveClass(desc);
        }
    }

    public static class Handler
    implements IMessageHandler<PacketConfigSync, PacketConfigSync> {
        public PacketConfigSync onMessage(PacketConfigSync message, MessageContext ctx) {
            ConfigProcessor processor = ConfigProcessor.processorMap.get(message.modid);
            if (processor != null) {
                processor.syncTo(message.configValues);
            }
            return null;
        }
    }
}

