/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common;

import com.enderio.core.client.gui.widget.GhostSlot;
import com.enderio.core.common.TileEntityBase;
import com.google.common.collect.Maps;
import java.awt.Point;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public abstract class ContainerItemHandler<T extends ICapabilityProvider>
extends Container
implements GhostSlot.IGhostSlotAware {
    @Nonnull
    protected final Map<Slot, Point> playerSlotLocations = Maps.newLinkedHashMap();
    protected final int startPlayerSlot;
    protected final int endPlayerSlot;
    protected final int startHotBarSlot;
    protected final int endHotBarSlot;
    @Nonnull
    private final T owner;
    @Nonnull
    private final IItemHandler inv;
    @Nonnull
    private final InventoryPlayer playerInv;

    @Nonnull
    private static <T> T checkNotNull(T reference) {
        if (reference == null) {
            throw new NullPointerException();
        }
        return reference;
    }

    public ContainerItemHandler(@Nonnull InventoryPlayer playerInv, @Nonnull T owner, @Nullable EnumFacing facing) {
        int i;
        this.owner = (ICapabilityProvider)ContainerItemHandler.checkNotNull(owner);
        this.inv = (IItemHandler)ContainerItemHandler.checkNotNull(owner.getCapability(ContainerItemHandler.checkNotNull(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY), facing));
        this.playerInv = ContainerItemHandler.checkNotNull(playerInv);
        this.addSlots(this.playerInv);
        int x = this.getPlayerInventoryOffset().x;
        int y = this.getPlayerInventoryOffset().y;
        this.startPlayerSlot = this.field_75151_b.size();
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                Point loc = new Point(x + j * 18, y + i * 18);
                Slot slot = new Slot((IInventory)this.playerInv, j + i * 9 + 9, loc.x, loc.y);
                this.func_75146_a(slot);
                this.playerSlotLocations.put(slot, loc);
            }
        }
        this.endPlayerSlot = this.field_75151_b.size();
        this.startHotBarSlot = this.field_75151_b.size();
        for (i = 0; i < 9; ++i) {
            Point loc = new Point(x + i * 18, y + 58);
            Slot slot = new Slot((IInventory)this.playerInv, i, loc.x, loc.y);
            this.func_75146_a(slot);
            this.playerSlotLocations.put(slot, loc);
        }
        this.endHotBarSlot = this.field_75151_b.size();
    }

    protected void addSlots(@Nonnull InventoryPlayer playerInventory) {
    }

    @Nonnull
    public Point getPlayerInventoryOffset() {
        return new Point(8, 84);
    }

    @Nonnull
    public Point getUpgradeOffset() {
        return new Point(12, 60);
    }

    @Nonnull
    public T getOwner() {
        return this.owner;
    }

    @Nonnull
    public IItemHandler getInv() {
        return this.inv;
    }

    @Nonnull
    public ItemStack func_82846_b(@Nonnull EntityPlayer p_82846_1_, int p_82846_2_) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.field_75151_b.get(p_82846_2_);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            int minPlayerSlot = this.field_75151_b.size() - this.playerInv.field_70462_a.size();
            if (p_82846_2_ < minPlayerSlot ? !this.func_75135_a(itemstack1, minPlayerSlot, this.field_75151_b.size(), true) : !this.func_75135_a(itemstack1, 0, minPlayerSlot, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.func_75215_d(ItemStack.EMPTY);
            } else {
                slot.func_75218_e();
            }
        }
        return itemstack;
    }

    protected boolean func_75135_a(@Nonnull ItemStack par1ItemStack, int fromIndex, int toIndex, boolean reversOrder) {
        ItemStack itemstack1;
        Slot slot;
        boolean result = false;
        int checkIndex = fromIndex;
        if (reversOrder) {
            checkIndex = toIndex - 1;
        }
        if (par1ItemStack.func_77985_e()) {
            while (!par1ItemStack.isEmpty() && (!reversOrder && checkIndex < toIndex || reversOrder && checkIndex >= fromIndex)) {
                slot = (Slot)this.field_75151_b.get(checkIndex);
                itemstack1 = slot.func_75211_c();
                if (!itemstack1.isEmpty() && itemstack1.func_77973_b() == par1ItemStack.func_77973_b() && (!par1ItemStack.func_77981_g() || par1ItemStack.func_77952_i() == itemstack1.func_77952_i()) && ItemStack.func_77970_a((ItemStack)par1ItemStack, (ItemStack)itemstack1) && slot.func_75214_a(par1ItemStack) && par1ItemStack != itemstack1) {
                    int maxStackSize;
                    int mergedSize = itemstack1.getCount() + par1ItemStack.getCount();
                    if (mergedSize <= (maxStackSize = Math.min(par1ItemStack.func_77976_d(), slot.func_75219_a()))) {
                        par1ItemStack.setCount(0);
                        itemstack1.setCount(mergedSize);
                        slot.func_75218_e();
                        result = true;
                    } else if (itemstack1.getCount() < maxStackSize) {
                        par1ItemStack.shrink(maxStackSize - itemstack1.getCount());
                        itemstack1.setCount(maxStackSize);
                        slot.func_75218_e();
                        result = true;
                    }
                }
                if (reversOrder) {
                    --checkIndex;
                    continue;
                }
                ++checkIndex;
            }
        }
        if (!par1ItemStack.isEmpty()) {
            checkIndex = reversOrder ? toIndex - 1 : fromIndex;
            while (!reversOrder && checkIndex < toIndex || reversOrder && checkIndex >= fromIndex) {
                slot = (Slot)this.field_75151_b.get(checkIndex);
                itemstack1 = slot.func_75211_c();
                if (itemstack1.isEmpty() && slot.func_75214_a(par1ItemStack)) {
                    ItemStack in = par1ItemStack.func_77946_l();
                    in.setCount(Math.min(in.getCount(), slot.func_75219_a()));
                    slot.func_75215_d(in);
                    slot.func_75218_e();
                    par1ItemStack.shrink(in.getCount());
                    result = true;
                    break;
                }
                if (reversOrder) {
                    --checkIndex;
                    continue;
                }
                ++checkIndex;
            }
        }
        return result;
    }

    public void setGhostSlotContents(int slot, @Nonnull ItemStack stack, int realsize) {
        if (this.owner instanceof TileEntityBase) {
            ((TileEntityBase)((Object)this.owner)).setGhostSlotContents(slot, stack, realsize);
        }
    }
}

