/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.client.render;

import com.enderio.core.api.client.render.VertexTransform;
import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.vecmath.Vector2f;
import com.enderio.core.common.vecmath.Vector3d;
import com.enderio.core.common.vecmath.Vector3f;
import com.enderio.core.common.vecmath.Vertex;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;

public final class BoundingBox
extends AxisAlignedBB {
    public static final BoundingBox UNIT_CUBE = new BoundingBox(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);

    public BoundingBox(BlockPos pos1, BlockPos pos2) {
        super(pos1, pos2);
    }

    public BoundingBox(AxisAlignedBB bb) {
        super(bb.field_72340_a, bb.field_72338_b, bb.field_72339_c, bb.field_72336_d, bb.field_72337_e, bb.field_72334_f);
    }

    public BoundingBox(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        super((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
    }

    public BoundingBox(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        super(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public BoundingBox(Vector3d min, Vector3d max) {
        super(min.x, min.y, min.z, max.x, max.y, max.z);
    }

    public BoundingBox(BlockCoord bc) {
        this(bc.getBlockPos());
    }

    public BoundingBox(BlockPos bc) {
        super((double)bc.func_177958_n(), (double)bc.func_177956_o(), (double)bc.func_177952_p(), (double)(bc.func_177958_n() + 1), (double)(bc.func_177956_o() + 1), (double)(bc.func_177952_p() + 1));
    }

    public BoundingBox expandBy(BoundingBox other) {
        return new BoundingBox(Math.min(this.field_72340_a, other.field_72340_a), Math.min(this.field_72338_b, other.field_72338_b), Math.min(this.field_72339_c, other.field_72339_c), Math.max(this.field_72336_d, other.field_72336_d), Math.max(this.field_72337_e, other.field_72337_e), Math.max(this.field_72334_f, other.field_72334_f));
    }

    public boolean contains(BoundingBox other) {
        return this.field_72340_a >= other.field_72340_a && this.field_72338_b <= other.field_72338_b && this.field_72339_c <= other.field_72339_c && this.field_72336_d >= other.field_72336_d && this.field_72337_e <= other.field_72337_e && this.field_72334_f <= other.field_72334_f;
    }

    public boolean intersects(BoundingBox other) {
        return other.field_72336_d > this.field_72340_a && other.field_72340_a < this.field_72336_d ? (other.field_72337_e > this.field_72338_b && other.field_72338_b < this.field_72337_e ? other.field_72334_f > this.field_72339_c && other.field_72339_c < this.field_72334_f : false) : false;
    }

    @Deprecated
    public boolean isValid() {
        return true;
    }

    public BoundingBox scale(float xyz) {
        return this.scale((double)xyz, (double)xyz, (double)xyz);
    }

    public BoundingBox scale(double xyz) {
        return this.scale(xyz, xyz, xyz);
    }

    public BoundingBox scale(float x, float y, float z) {
        return this.scale((double)x, (double)y, (double)z);
    }

    public BoundingBox scale(double x, double y, double z) {
        x = 1.0 - x;
        y = 1.0 - y;
        z = 1.0 - z;
        double w = (this.field_72336_d - this.field_72340_a) * x / 2.0;
        double h = (this.field_72337_e - this.field_72338_b) * y / 2.0;
        double d = (this.field_72334_f - this.field_72339_c) * z / 2.0;
        return new BoundingBox(this.field_72340_a + w, this.field_72338_b + h, this.field_72339_c + d, this.field_72336_d - w, this.field_72337_e - h, this.field_72334_f - d);
    }

    public BoundingBox translate(float x, float y, float z) {
        return new BoundingBox(this.field_72340_a + (double)x, this.field_72338_b + (double)y, this.field_72339_c + (double)z, this.field_72336_d + (double)x, this.field_72337_e + (double)y, this.field_72334_f + (double)z);
    }

    public BoundingBox translate(Vector3d translation) {
        return this.translate((float)translation.x, (float)translation.y, (float)translation.z);
    }

    public BoundingBox translate(Vector3f vec) {
        return this.translate(vec.x, vec.y, vec.z);
    }

    public List<Vertex> getCornersWithUvForFace(EnumFacing face) {
        return this.getCornersWithUvForFace(face, 0.0f, 1.0f, 0.0f, 1.0f);
    }

    public List<Vertex> getCornersWithUvForFace(EnumFacing face, float minU, float maxU, float minV, float maxV) {
        ArrayList<Vertex> result = new ArrayList<Vertex>(4);
        switch (face) {
            case NORTH: {
                result.add(new Vertex(new Vector3d(this.field_72336_d, this.field_72338_b, this.field_72339_c), new Vector3f(0.0f, 0.0f, -1.0f), new Vector2f(minU, minV)));
                result.add(new Vertex(new Vector3d(this.field_72340_a, this.field_72338_b, this.field_72339_c), new Vector3f(0.0f, 0.0f, -1.0f), new Vector2f(maxU, minV)));
                result.add(new Vertex(new Vector3d(this.field_72340_a, this.field_72337_e, this.field_72339_c), new Vector3f(0.0f, 0.0f, -1.0f), new Vector2f(maxU, maxV)));
                result.add(new Vertex(new Vector3d(this.field_72336_d, this.field_72337_e, this.field_72339_c), new Vector3f(0.0f, 0.0f, -1.0f), new Vector2f(minU, maxV)));
                break;
            }
            case SOUTH: {
                result.add(new Vertex(new Vector3d(this.field_72340_a, this.field_72338_b, this.field_72334_f), new Vector3f(0.0f, 0.0f, 1.0f), new Vector2f(maxU, minV)));
                result.add(new Vertex(new Vector3d(this.field_72336_d, this.field_72338_b, this.field_72334_f), new Vector3f(0.0f, 0.0f, 1.0f), new Vector2f(minU, minV)));
                result.add(new Vertex(new Vector3d(this.field_72336_d, this.field_72337_e, this.field_72334_f), new Vector3f(0.0f, 0.0f, 1.0f), new Vector2f(minU, maxV)));
                result.add(new Vertex(new Vector3d(this.field_72340_a, this.field_72337_e, this.field_72334_f), new Vector3f(0.0f, 0.0f, 1.0f), new Vector2f(maxU, maxV)));
                break;
            }
            case EAST: {
                result.add(new Vertex(new Vector3d(this.field_72336_d, this.field_72337_e, this.field_72339_c), new Vector3f(1.0f, 0.0f, 0.0f), new Vector2f(maxU, maxV)));
                result.add(new Vertex(new Vector3d(this.field_72336_d, this.field_72337_e, this.field_72334_f), new Vector3f(1.0f, 0.0f, 0.0f), new Vector2f(minU, maxV)));
                result.add(new Vertex(new Vector3d(this.field_72336_d, this.field_72338_b, this.field_72334_f), new Vector3f(1.0f, 0.0f, 0.0f), new Vector2f(minU, minV)));
                result.add(new Vertex(new Vector3d(this.field_72336_d, this.field_72338_b, this.field_72339_c), new Vector3f(1.0f, 0.0f, 0.0f), new Vector2f(maxU, minV)));
                break;
            }
            case WEST: {
                result.add(new Vertex(new Vector3d(this.field_72340_a, this.field_72338_b, this.field_72339_c), new Vector3f(-1.0f, 0.0f, 0.0f), new Vector2f(maxU, minV)));
                result.add(new Vertex(new Vector3d(this.field_72340_a, this.field_72338_b, this.field_72334_f), new Vector3f(-1.0f, 0.0f, 0.0f), new Vector2f(minU, minV)));
                result.add(new Vertex(new Vector3d(this.field_72340_a, this.field_72337_e, this.field_72334_f), new Vector3f(-1.0f, 0.0f, 0.0f), new Vector2f(minU, maxV)));
                result.add(new Vertex(new Vector3d(this.field_72340_a, this.field_72337_e, this.field_72339_c), new Vector3f(-1.0f, 0.0f, 0.0f), new Vector2f(maxU, maxV)));
                break;
            }
            case UP: {
                result.add(new Vertex(new Vector3d(this.field_72336_d, this.field_72337_e, this.field_72334_f), new Vector3f(0.0f, 1.0f, 0.0f), new Vector2f(minU, minV)));
                result.add(new Vertex(new Vector3d(this.field_72336_d, this.field_72337_e, this.field_72339_c), new Vector3f(0.0f, 1.0f, 0.0f), new Vector2f(minU, maxV)));
                result.add(new Vertex(new Vector3d(this.field_72340_a, this.field_72337_e, this.field_72339_c), new Vector3f(0.0f, 1.0f, 0.0f), new Vector2f(maxU, maxV)));
                result.add(new Vertex(new Vector3d(this.field_72340_a, this.field_72337_e, this.field_72334_f), new Vector3f(0.0f, 1.0f, 0.0f), new Vector2f(maxU, minV)));
                break;
            }
            default: {
                result.add(new Vertex(new Vector3d(this.field_72340_a, this.field_72338_b, this.field_72339_c), new Vector3f(0.0f, -1.0f, 0.0f), new Vector2f(maxU, maxV)));
                result.add(new Vertex(new Vector3d(this.field_72336_d, this.field_72338_b, this.field_72339_c), new Vector3f(0.0f, -1.0f, 0.0f), new Vector2f(minU, maxV)));
                result.add(new Vertex(new Vector3d(this.field_72336_d, this.field_72338_b, this.field_72334_f), new Vector3f(0.0f, -1.0f, 0.0f), new Vector2f(minU, minV)));
                result.add(new Vertex(new Vector3d(this.field_72340_a, this.field_72338_b, this.field_72334_f), new Vector3f(0.0f, -1.0f, 0.0f), new Vector2f(maxU, minV)));
            }
        }
        return result;
    }

    public List<Vector3f> getCornersForFace(EnumFacing face) {
        ArrayList<Vector3f> result = new ArrayList<Vector3f>(4);
        switch (face) {
            case NORTH: {
                result.add(new Vector3f(this.field_72340_a, this.field_72337_e, this.field_72339_c));
                result.add(new Vector3f(this.field_72336_d, this.field_72337_e, this.field_72339_c));
                result.add(new Vector3f(this.field_72336_d, this.field_72338_b, this.field_72339_c));
                result.add(new Vector3f(this.field_72340_a, this.field_72338_b, this.field_72339_c));
                break;
            }
            case SOUTH: {
                result.add(new Vector3f(this.field_72340_a, this.field_72337_e, this.field_72334_f));
                result.add(new Vector3f(this.field_72340_a, this.field_72338_b, this.field_72334_f));
                result.add(new Vector3f(this.field_72336_d, this.field_72338_b, this.field_72334_f));
                result.add(new Vector3f(this.field_72336_d, this.field_72337_e, this.field_72334_f));
                break;
            }
            case EAST: {
                result.add(new Vector3f(this.field_72336_d, this.field_72338_b, this.field_72334_f));
                result.add(new Vector3f(this.field_72336_d, this.field_72338_b, this.field_72339_c));
                result.add(new Vector3f(this.field_72336_d, this.field_72337_e, this.field_72339_c));
                result.add(new Vector3f(this.field_72336_d, this.field_72337_e, this.field_72334_f));
                break;
            }
            case WEST: {
                result.add(new Vector3f(this.field_72340_a, this.field_72337_e, this.field_72334_f));
                result.add(new Vector3f(this.field_72340_a, this.field_72337_e, this.field_72339_c));
                result.add(new Vector3f(this.field_72340_a, this.field_72338_b, this.field_72339_c));
                result.add(new Vector3f(this.field_72340_a, this.field_72338_b, this.field_72334_f));
                break;
            }
            case UP: {
                result.add(new Vector3f(this.field_72336_d, this.field_72337_e, this.field_72334_f));
                result.add(new Vector3f(this.field_72336_d, this.field_72337_e, this.field_72339_c));
                result.add(new Vector3f(this.field_72340_a, this.field_72337_e, this.field_72339_c));
                result.add(new Vector3f(this.field_72340_a, this.field_72337_e, this.field_72334_f));
                break;
            }
            default: {
                result.add(new Vector3f(this.field_72340_a, this.field_72338_b, this.field_72334_f));
                result.add(new Vector3f(this.field_72340_a, this.field_72338_b, this.field_72339_c));
                result.add(new Vector3f(this.field_72336_d, this.field_72338_b, this.field_72339_c));
                result.add(new Vector3f(this.field_72336_d, this.field_72338_b, this.field_72334_f));
            }
        }
        return result;
    }

    public List<Vector3d> getCornersForFaceD(EnumFacing face) {
        ArrayList<Vector3d> result = new ArrayList<Vector3d>(4);
        switch (face) {
            case NORTH: {
                result.add(new Vector3d(this.field_72340_a, this.field_72337_e, this.field_72339_c));
                result.add(new Vector3d(this.field_72336_d, this.field_72337_e, this.field_72339_c));
                result.add(new Vector3d(this.field_72336_d, this.field_72338_b, this.field_72339_c));
                result.add(new Vector3d(this.field_72340_a, this.field_72338_b, this.field_72339_c));
                break;
            }
            case SOUTH: {
                result.add(new Vector3d(this.field_72340_a, this.field_72337_e, this.field_72334_f));
                result.add(new Vector3d(this.field_72340_a, this.field_72338_b, this.field_72334_f));
                result.add(new Vector3d(this.field_72336_d, this.field_72338_b, this.field_72334_f));
                result.add(new Vector3d(this.field_72336_d, this.field_72337_e, this.field_72334_f));
                break;
            }
            case EAST: {
                result.add(new Vector3d(this.field_72336_d, this.field_72338_b, this.field_72334_f));
                result.add(new Vector3d(this.field_72336_d, this.field_72338_b, this.field_72339_c));
                result.add(new Vector3d(this.field_72336_d, this.field_72337_e, this.field_72339_c));
                result.add(new Vector3d(this.field_72336_d, this.field_72337_e, this.field_72334_f));
                break;
            }
            case WEST: {
                result.add(new Vector3d(this.field_72340_a, this.field_72337_e, this.field_72334_f));
                result.add(new Vector3d(this.field_72340_a, this.field_72337_e, this.field_72339_c));
                result.add(new Vector3d(this.field_72340_a, this.field_72338_b, this.field_72339_c));
                result.add(new Vector3d(this.field_72340_a, this.field_72338_b, this.field_72334_f));
                break;
            }
            case UP: {
                result.add(new Vector3d(this.field_72336_d, this.field_72337_e, this.field_72334_f));
                result.add(new Vector3d(this.field_72336_d, this.field_72337_e, this.field_72339_c));
                result.add(new Vector3d(this.field_72340_a, this.field_72337_e, this.field_72339_c));
                result.add(new Vector3d(this.field_72340_a, this.field_72337_e, this.field_72334_f));
                break;
            }
            default: {
                result.add(new Vector3d(this.field_72340_a, this.field_72338_b, this.field_72334_f));
                result.add(new Vector3d(this.field_72340_a, this.field_72338_b, this.field_72339_c));
                result.add(new Vector3d(this.field_72336_d, this.field_72338_b, this.field_72339_c));
                result.add(new Vector3d(this.field_72336_d, this.field_72338_b, this.field_72334_f));
            }
        }
        return result;
    }

    public Vector3d getCenter() {
        return new Vector3d(this.field_72340_a + (this.field_72336_d - this.field_72340_a) / 2.0, this.field_72338_b + (this.field_72337_e - this.field_72338_b) / 2.0, this.field_72339_c + (this.field_72334_f - this.field_72339_c) / 2.0);
    }

    public double sizeX() {
        return Math.abs(this.field_72336_d - this.field_72340_a);
    }

    public double sizeY() {
        return Math.abs(this.field_72337_e - this.field_72338_b);
    }

    public double sizeZ() {
        return Math.abs(this.field_72334_f - this.field_72339_c);
    }

    public Vector3d getMin() {
        return new Vector3d(this.field_72340_a, this.field_72338_b, this.field_72339_c);
    }

    public Vector3d getMax() {
        return new Vector3d(this.field_72336_d, this.field_72337_e, this.field_72334_f);
    }

    public double getArea() {
        return this.sizeX() * this.sizeY() * this.sizeZ();
    }

    public BoundingBox fixMinMax() {
        double mnX = this.field_72340_a;
        double mnY = this.field_72338_b;
        double mnZ = this.field_72339_c;
        double mxX = this.field_72336_d;
        double mxY = this.field_72337_e;
        double mxZ = this.field_72334_f;
        boolean mod = false;
        if (this.field_72340_a > this.field_72336_d) {
            mnX = this.field_72336_d;
            mxX = this.field_72340_a;
            mod = true;
        }
        if (this.field_72338_b > this.field_72337_e) {
            mnY = this.field_72337_e;
            mxY = this.field_72338_b;
            mod = true;
        }
        if (this.field_72339_c > this.field_72334_f) {
            mnZ = this.field_72334_f;
            mxZ = this.field_72339_c;
            mod = true;
        }
        if (!mod) {
            return this;
        }
        return new BoundingBox(mnX, mnY, mnZ, mxX, mxY, mxZ);
    }

    @Deprecated
    public AxisAlignedBB getAxisAlignedBB() {
        return this;
    }

    public BoundingBox transform(VertexTransform vertexTransform) {
        Vector3d min = new Vector3d(this.field_72340_a, this.field_72338_b, this.field_72339_c);
        Vector3d max = new Vector3d(this.field_72336_d, this.field_72337_e, this.field_72334_f);
        vertexTransform.apply(min);
        vertexTransform.apply(max);
        return new BoundingBox(Math.min(min.x, max.x), Math.min(min.y, max.y), Math.min(min.z, max.z), Math.max(min.x, max.x), Math.max(min.y, max.y), Math.max(min.z, max.z));
    }

    public BoundingBox expand(double x, double y, double z) {
        return new BoundingBox(this.field_72340_a - x, this.field_72338_b - y, this.field_72339_c - z, this.field_72336_d + x, this.field_72337_e + y, this.field_72334_f + z);
    }

    public BoundingBox setMaxY(double y2) {
        return new BoundingBox(this.field_72340_a, this.field_72338_b, this.field_72339_c, this.field_72336_d, y2, this.field_72334_f);
    }

    public BoundingBox expand(double xyz) {
        return new BoundingBox(this.field_72340_a - xyz, this.field_72338_b - xyz, this.field_72339_c - xyz, this.field_72336_d + xyz, this.field_72337_e + xyz, this.field_72334_f + xyz);
    }
}

