/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.client.handlers;

import com.enderio.core.EnderCore;
import com.enderio.core.common.Handlers;
import com.enderio.core.common.fluid.BlockFluidEnder;
import com.enderio.core.common.util.NullHelper;
import java.lang.reflect.Field;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderBlockOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Handlers.Handler(side=Handlers.Handler.HandlerSide.CLIENT)
@SideOnly(value=Side.CLIENT)
public class FluidVisualsHandler {
    private static final Field FfogColor1 = ReflectionHelper.findField(EntityRenderer.class, (String[])new String[]{"fogColor1", "field_78539_ae"});
    private static final Field FfogColor2 = ReflectionHelper.findField(EntityRenderer.class, (String[])new String[]{"fogColor2", "field_78535_ad"});
    private static final Field FbossColorModifier = ReflectionHelper.findField(EntityRenderer.class, (String[])new String[]{"bossColorModifier", "field_82831_U"});
    private static final Field FbossColorModifierPrev = ReflectionHelper.findField(EntityRenderer.class, (String[])new String[]{"bossColorModifierPrev", "field_82832_V"});
    private static final Field FcloudFog = ReflectionHelper.findField(EntityRenderer.class, (String[])new String[]{"cloudFog", "field_78500_U"});
    @Nonnull
    private static final ResourceLocation RES_UNDERFLUID_OVERLAY = new ResourceLocation(EnderCore.DOMAIN, "textures/misc/underfluid.png");

    @SubscribeEvent
    public static void onFOVModifier(@Nonnull EntityViewRenderEvent.FOVModifier event) {
        if (event.getState() instanceof BlockFluidEnder) {
            event.setFOV(event.getFOV() * 60.0f / 70.0f);
        }
    }

    private static float getNightVisionBrightness(@Nonnull EntityLivingBase entitylivingbaseIn, float partialTicks) {
        int i = NullHelper.notnull(entitylivingbaseIn.func_70660_b(MobEffects.field_76439_r), "LOC9003476").func_76459_b();
        return i > 200 ? 1.0f : 0.7f + MathHelper.func_76126_a((float)(((float)i - partialTicks) * (float)Math.PI * 0.2f)) * 0.3f;
    }

    @SubscribeEvent
    public static void onRenderBlockOverlay(RenderBlockOverlayEvent event) {
        BlockPos blockpos;
        EntityPlayer player;
        Block block;
        if (event.getOverlayType() == RenderBlockOverlayEvent.OverlayType.WATER && (block = player.world.func_180495_p(blockpos = new BlockPos(player.field_70165_t, player.field_70163_u + (double)(player = event.getPlayer()).func_70047_e(), player.field_70161_v)).func_177230_c()) instanceof BlockFluidEnder) {
            float fogColorRed = ((BlockFluidEnder)block).getFogColorRed();
            float fogColorGreen = ((BlockFluidEnder)block).getFogColorGreen();
            float fogColorBlue = ((BlockFluidEnder)block).getFogColorBlue();
            Minecraft.func_71410_x().func_110434_K().func_110577_a(RES_UNDERFLUID_OVERLAY);
            Tessellator tessellator = Tessellator.func_178181_a();
            VertexBuffer vertexbuffer = tessellator.func_178180_c();
            float f = player.func_70013_c(event.getRenderPartialTicks());
            GlStateManager.func_179131_c((float)(f * fogColorRed), (float)(f * fogColorGreen), (float)(f * fogColorBlue), (float)0.5f);
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_179094_E();
            float f7 = -player.field_70177_z / 64.0f;
            float f8 = player.field_70125_A / 64.0f;
            vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            vertexbuffer.func_181662_b(-1.0, -1.0, -0.5).func_187315_a((double)(4.0f + f7), (double)(4.0f + f8)).func_181675_d();
            vertexbuffer.func_181662_b(1.0, -1.0, -0.5).func_187315_a((double)(0.0f + f7), (double)(4.0f + f8)).func_181675_d();
            vertexbuffer.func_181662_b(1.0, 1.0, -0.5).func_187315_a((double)(0.0f + f7), (double)(0.0f + f8)).func_181675_d();
            vertexbuffer.func_181662_b(-1.0, 1.0, -0.5).func_187315_a((double)(4.0f + f7), (double)(0.0f + f8)).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179121_F();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179084_k();
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onFogDensity(@Nonnull EntityViewRenderEvent.FogDensity event) throws IllegalArgumentException, IllegalAccessException {
        if (event.getState().func_177230_c() instanceof BlockFluidEnder) {
            EntityRenderer renderer = event.getRenderer();
            Entity entity = event.getEntity();
            boolean cloudFog = FcloudFog.getBoolean(renderer);
            if (entity instanceof EntityLivingBase && ((EntityLivingBase)entity).func_70644_a(MobEffects.field_76440_q)) {
                return;
            }
            if (cloudFog) {
                return;
            }
            GlStateManager.func_187430_a((GlStateManager.FogMode)GlStateManager.FogMode.EXP);
            if (entity instanceof EntityLivingBase) {
                if (((EntityLivingBase)entity).func_70644_a(MobEffects.field_76427_o)) {
                    event.setDensity(0.01f);
                } else {
                    event.setDensity(0.1f - (float)EnchantmentHelper.func_185292_c((EntityLivingBase)((EntityLivingBase)entity)) * 0.03f);
                }
            } else {
                event.setDensity(0.1f);
            }
        }
    }

    @SubscribeEvent
    public static void onFogColor(EntityViewRenderEvent.FogColors event) throws IllegalArgumentException, IllegalAccessException {
        if (event.getState().func_177230_c() instanceof BlockFluidEnder) {
            float fogColorRed = ((BlockFluidEnder)event.getState().func_177230_c()).getFogColorRed();
            float fogColorGreen = ((BlockFluidEnder)event.getState().func_177230_c()).getFogColorGreen();
            float fogColorBlue = ((BlockFluidEnder)event.getState().func_177230_c()).getFogColorBlue();
            EntityRenderer renderer = event.getRenderer();
            float fogColor1 = FfogColor1.getFloat(renderer);
            float fogColor2 = FfogColor2.getFloat(renderer);
            float partialTicks = (float)event.getRenderPartialTicks();
            Entity entity = event.getEntity();
            World world = entity.func_130014_f_();
            float bossColorModifier = FbossColorModifier.getFloat(renderer);
            float bossColorModifierPrev = FbossColorModifierPrev.getFloat(renderer);
            float f12 = 0.0f;
            if (entity instanceof EntityLivingBase) {
                f12 = (float)EnchantmentHelper.func_185292_c((EntityLivingBase)((EntityLivingBase)entity)) * 0.2f;
                if (((EntityLivingBase)entity).func_70644_a(MobEffects.field_76427_o)) {
                    f12 = f12 * 0.3f + 0.6f;
                }
            }
            fogColorRed += f12;
            fogColorGreen += f12;
            fogColorBlue += f12;
            float f13 = fogColor2 + (fogColor1 - fogColor2) * partialTicks;
            fogColorRed *= f13;
            fogColorGreen *= f13;
            fogColorBlue *= f13;
            double d1 = (entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partialTicks) * world.field_73011_w.func_76565_k();
            if (entity instanceof EntityLivingBase && ((EntityLivingBase)entity).func_70644_a(MobEffects.field_76440_q)) {
                int i = NullHelper.notnull(((EntityLivingBase)entity).func_70660_b(MobEffects.field_76440_q), "LOC9903481").func_76459_b();
                d1 = i < 20 ? (d1 *= (double)(1.0f - (float)i / 20.0f)) : 0.0;
            }
            if (d1 < 1.0) {
                if (d1 < 0.0) {
                    d1 = 0.0;
                }
                d1 *= d1;
                fogColorRed = (float)((double)fogColorRed * d1);
                fogColorGreen = (float)((double)fogColorGreen * d1);
                fogColorBlue = (float)((double)fogColorBlue * d1);
            }
            if (bossColorModifier > 0.0f) {
                float f14 = bossColorModifierPrev + (bossColorModifier - bossColorModifierPrev) * partialTicks;
                fogColorRed = fogColorRed * (1.0f - f14) + fogColorRed * 0.7f * f14;
                fogColorGreen = fogColorGreen * (1.0f - f14) + fogColorGreen * 0.6f * f14;
                fogColorBlue = fogColorBlue * (1.0f - f14) + fogColorBlue * 0.6f * f14;
            }
            if (entity instanceof EntityLivingBase && ((EntityLivingBase)entity).func_70644_a(MobEffects.field_76439_r)) {
                float f15 = FluidVisualsHandler.getNightVisionBrightness((EntityLivingBase)entity, partialTicks);
                float f6 = 1.0f / fogColorRed;
                if (f6 > 1.0f / fogColorGreen) {
                    f6 = 1.0f / fogColorGreen;
                }
                if (f6 > 1.0f / fogColorBlue) {
                    f6 = 1.0f / fogColorBlue;
                }
                fogColorRed = fogColorRed * (1.0f - f15) + fogColorRed * f6 * f15;
                fogColorGreen = fogColorGreen * (1.0f - f15) + fogColorGreen * f6 * f15;
                fogColorBlue = fogColorBlue * (1.0f - f15) + fogColorBlue * f6 * f15;
            }
            if (Minecraft.func_71410_x().field_71474_y.field_74337_g) {
                float f16 = (fogColorRed * 30.0f + fogColorGreen * 59.0f + fogColorBlue * 11.0f) / 100.0f;
                float f17 = (fogColorRed * 30.0f + fogColorGreen * 70.0f) / 100.0f;
                float f7 = (fogColorRed * 30.0f + fogColorBlue * 70.0f) / 100.0f;
                fogColorRed = f16;
                fogColorGreen = f17;
                fogColorBlue = f7;
            }
            event.setRed(fogColorRed);
            event.setGreen(fogColorGreen);
            event.setBlue(fogColorBlue);
        }
    }

    private FluidVisualsHandler() {
    }
}

