/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import mekanism.api.Coord4D;
import mekanism.common.Mekanism;
import mekanism.common.util.ListUtils;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public final class MinerUtils {
    public static final String[] GET_SILK_TOUCH_DROP = new String[]{"getSilkTouchDrop", "func_180643_i"};
    public static List<Block> specialSilkIDs = ListUtils.asList(Blocks.field_150432_aD);
    private static Method getSilkTouchDrop = null;

    public static List<ItemStack> getDrops(World world, Coord4D obj, boolean silk) {
        IBlockState state = obj.getBlockState((IBlockAccess)world);
        Block block = state.func_177230_c();
        if (block == null || block.isAir(state, (IBlockAccess)world, obj.getPos())) {
            return new ArrayList<ItemStack>();
        }
        if (silk && block.canSilkHarvest(world, obj.getPos(), state, null)) {
            ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
            if (getSilkTouchDrop != null) {
                try {
                    Object it = getSilkTouchDrop.invoke((Object)block, state);
                    if (it != null && it instanceof ItemStack && ((ItemStack)it).field_77994_a > 0) {
                        ret.add((ItemStack)it);
                    }
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    Mekanism.logger.error("Block.getSilkTouchDrop errored", (Throwable)e);
                }
            } else {
                Item item = Item.func_150898_a((Block)block);
                if (item != null) {
                    int meta = item.func_77614_k() ? block.func_176201_c(state) : 0;
                    ret.add(new ItemStack(item, 1, meta));
                }
            }
            if (ret.size() > 0) {
                List blockDrops = block.getDrops((IBlockAccess)world, obj.getPos(), state, 0);
                if (specialSilkIDs.contains(block) || blockDrops != null && blockDrops.size() > 0) {
                    ForgeEventFactory.fireBlockHarvesting(ret, (World)world, (BlockPos)obj.getPos(), (IBlockState)state, (int)0, (float)1.0f, (boolean)true, null);
                    return ret;
                }
            }
        } else {
            List blockDrops = block.getDrops((IBlockAccess)world, obj.getPos(), state, 0);
            if (blockDrops.size() > 0) {
                ForgeEventFactory.fireBlockHarvesting((List)blockDrops, (World)world, (BlockPos)obj.getPos(), (IBlockState)state, (int)0, (float)1.0f, (boolean)true, null);
            }
            return blockDrops;
        }
        return new ArrayList<ItemStack>();
    }

    static {
        try {
            getSilkTouchDrop = ReflectionHelper.findMethod(Block.class, null, (String[])GET_SILK_TOUCH_DROP, (Class[])new Class[]{IBlockState.class});
        }
        catch (ReflectionHelper.UnableToFindMethodException e) {
            Mekanism.logger.error("Unable to find method Block.getSilkTouchDrop");
        }
    }
}

