/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.api.gas.IGasHandler;
import mekanism.api.gas.IGasItem;
import mekanism.api.gas.ITubeConnection;
import mekanism.common.Upgrade;
import mekanism.common.base.IRedstoneControl;
import mekanism.common.base.ISustainedData;
import mekanism.common.base.ITankManager;
import mekanism.common.base.IUpgradeTile;
import mekanism.common.block.states.BlockStateMachine;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.config.MekanismConfig;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.ChemicalPairInput;
import mekanism.common.recipe.machines.ChemicalInfuserRecipe;
import mekanism.common.recipe.outputs.GasOutput;
import mekanism.common.security.ISecurityTile;
import mekanism.common.tile.prefab.TileEntityMachine;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.GasUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.ListUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class TileEntityChemicalInfuser
extends TileEntityMachine
implements IGasHandler,
ITubeConnection,
IRedstoneControl,
ISustainedData,
IUpgradeTile,
Upgrade.IUpgradeInfoHandler,
ITankManager,
ISecurityTile {
    public GasTank leftTank = new GasTank(10000);
    public GasTank rightTank = new GasTank(10000);
    public GasTank centerTank = new GasTank(10000);
    public static final int MAX_GAS = 10000;
    public int gasOutput = 256;
    public ChemicalInfuserRecipe cachedRecipe;
    public double clientEnergyUsed;

    public TileEntityChemicalInfuser() {
        super("machine.cheminfuser", "ChemicalInfuser", BlockStateMachine.MachineType.CHEMICAL_INFUSER.baseEnergy, MekanismConfig.usage.chemicalInfuserUsage, 4);
        this.inventory = new ItemStack[5];
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.field_145850_b.field_72995_K) {
            ChemicalInfuserRecipe recipe;
            ChargeUtils.discharge(3, this);
            if (this.inventory[0] != null && (this.leftTank.getGas() == null || this.leftTank.getStored() < this.leftTank.getMaxGas())) {
                this.leftTank.receive(GasUtils.removeGas(this.inventory[0], this.leftTank.getGasType(), this.leftTank.getNeeded()), true);
            }
            if (this.inventory[1] != null && (this.rightTank.getGas() == null || this.rightTank.getStored() < this.rightTank.getMaxGas())) {
                this.rightTank.receive(GasUtils.removeGas(this.inventory[1], this.rightTank.getGasType(), this.rightTank.getNeeded()), true);
            }
            if (this.inventory[2] != null && this.centerTank.getGas() != null) {
                this.centerTank.draw(GasUtils.addGas(this.inventory[2], this.centerTank.getGas()), true);
            }
            if (this.canOperate(recipe = this.getRecipe()) && this.getEnergy() >= this.energyPerTick && MekanismUtils.canFunction(this)) {
                this.setActive(true);
                int operations = this.operate(recipe);
                double prev = this.getEnergy();
                this.setEnergy(this.getEnergy() - this.energyPerTick * (double)operations);
                this.clientEnergyUsed = prev - this.getEnergy();
            } else if (this.prevEnergy >= this.getEnergy()) {
                this.setActive(false);
            }
            if (this.centerTank.getGas() != null) {
                GasStack toSend = new GasStack(this.centerTank.getGas().getGas(), Math.min(this.centerTank.getStored(), this.gasOutput));
                this.centerTank.draw(GasUtils.emit(toSend, this, ListUtils.asList(this.facing)), true);
            }
            this.prevEnergy = this.getEnergy();
        }
    }

    public int getUpgradedUsage(ChemicalInfuserRecipe recipe) {
        int possibleProcess = (int)Math.pow(2.0, this.upgradeComponent.getUpgrades(Upgrade.SPEED));
        if (this.leftTank.getGasType() == ((ChemicalPairInput)recipe.recipeInput).leftGas.getGas()) {
            possibleProcess = Math.min(this.leftTank.getStored() / ((ChemicalPairInput)recipe.recipeInput).leftGas.amount, possibleProcess);
            possibleProcess = Math.min(this.rightTank.getStored() / ((ChemicalPairInput)recipe.recipeInput).rightGas.amount, possibleProcess);
        } else {
            possibleProcess = Math.min(this.leftTank.getStored() / ((ChemicalPairInput)recipe.recipeInput).rightGas.amount, possibleProcess);
            possibleProcess = Math.min(this.rightTank.getStored() / ((ChemicalPairInput)recipe.recipeInput).leftGas.amount, possibleProcess);
        }
        possibleProcess = Math.min(this.centerTank.getNeeded() / ((GasOutput)recipe.recipeOutput).output.amount, possibleProcess);
        possibleProcess = Math.min((int)(this.getEnergy() / this.energyPerTick), possibleProcess);
        return possibleProcess;
    }

    public ChemicalPairInput getInput() {
        return new ChemicalPairInput(this.leftTank.getGas(), this.rightTank.getGas());
    }

    public ChemicalInfuserRecipe getRecipe() {
        ChemicalPairInput input = this.getInput();
        if (this.cachedRecipe == null || !input.testEquality((ChemicalPairInput)this.cachedRecipe.getInput())) {
            this.cachedRecipe = RecipeHandler.getChemicalInfuserRecipe(this.getInput());
        }
        return this.cachedRecipe;
    }

    public boolean canOperate(ChemicalInfuserRecipe recipe) {
        return recipe != null && recipe.canOperate(this.leftTank, this.rightTank, this.centerTank);
    }

    public int operate(ChemicalInfuserRecipe recipe) {
        int operations = this.getUpgradedUsage(recipe);
        recipe.operate(this.leftTank, this.rightTank, this.centerTank, operations);
        this.func_70296_d();
        return operations;
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            this.clientEnergyUsed = dataStream.readDouble();
            if (dataStream.readBoolean()) {
                this.leftTank.setGas(new GasStack(GasRegistry.getGas(dataStream.readInt()), dataStream.readInt()));
            } else {
                this.leftTank.setGas(null);
            }
            if (dataStream.readBoolean()) {
                this.rightTank.setGas(new GasStack(GasRegistry.getGas(dataStream.readInt()), dataStream.readInt()));
            } else {
                this.rightTank.setGas(null);
            }
            if (dataStream.readBoolean()) {
                this.centerTank.setGas(new GasStack(GasRegistry.getGas(dataStream.readInt()), dataStream.readInt()));
            } else {
                this.centerTank.setGas(null);
            }
        }
    }

    @Override
    public ArrayList<Object> getNetworkedData(ArrayList<Object> data) {
        super.getNetworkedData(data);
        data.add(this.clientEnergyUsed);
        if (this.leftTank.getGas() != null) {
            data.add(true);
            data.add(this.leftTank.getGas().getGas().getID());
            data.add(this.leftTank.getStored());
        } else {
            data.add(false);
        }
        if (this.rightTank.getGas() != null) {
            data.add(true);
            data.add(this.rightTank.getGas().getGas().getID());
            data.add(this.rightTank.getStored());
        } else {
            data.add(false);
        }
        if (this.centerTank.getGas() != null) {
            data.add(true);
            data.add(this.centerTank.getGas().getGas().getID());
            data.add(this.centerTank.getStored());
        } else {
            data.add(false);
        }
        return data;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        this.leftTank.read(nbtTags.func_74775_l("leftTank"));
        this.rightTank.read(nbtTags.func_74775_l("rightTank"));
        this.centerTank.read(nbtTags.func_74775_l("centerTank"));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbtTags) {
        super.func_189515_b(nbtTags);
        nbtTags.func_74782_a("leftTank", (NBTBase)this.leftTank.write(new NBTTagCompound()));
        nbtTags.func_74782_a("rightTank", (NBTBase)this.rightTank.write(new NBTTagCompound()));
        nbtTags.func_74782_a("centerTank", (NBTBase)this.centerTank.write(new NBTTagCompound()));
        return nbtTags;
    }

    @Override
    public boolean canSetFacing(int i) {
        return i != 0 && i != 1;
    }

    public GasTank getTank(EnumFacing side) {
        if (side == MekanismUtils.getLeft(this.facing)) {
            return this.leftTank;
        }
        if (side == MekanismUtils.getRight(this.facing)) {
            return this.rightTank;
        }
        if (side == this.facing) {
            return this.centerTank;
        }
        return null;
    }

    @Override
    public boolean canTubeConnect(EnumFacing side) {
        return side == MekanismUtils.getLeft(this.facing) || side == MekanismUtils.getRight(this.facing) || side == this.facing;
    }

    @Override
    public boolean canReceiveGas(EnumFacing side, Gas type) {
        return this.getTank(side) != null && this.getTank(side) != this.centerTank && this.getTank(side).canReceive(type);
    }

    @Override
    public int receiveGas(EnumFacing side, GasStack stack, boolean doTransfer) {
        if (this.canReceiveGas(side, stack != null ? stack.getGas() : null)) {
            return this.getTank(side).receive(stack, doTransfer);
        }
        return 0;
    }

    @Override
    public GasStack drawGas(EnumFacing side, int amount, boolean doTransfer) {
        if (this.canDrawGas(side, null)) {
            return this.getTank(side).draw(amount, doTransfer);
        }
        return null;
    }

    @Override
    public boolean canDrawGas(EnumFacing side, Gas type) {
        return this.getTank(side) != null && this.getTank(side) == this.centerTank && this.getTank(side).canDraw(type);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing side) {
        return capability == Capabilities.GAS_HANDLER_CAPABILITY || capability == Capabilities.TUBE_CONNECTION_CAPABILITY || super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        if (capability == Capabilities.GAS_HANDLER_CAPABILITY || capability == Capabilities.TUBE_CONNECTION_CAPABILITY) {
            return (T)this;
        }
        return super.getCapability(capability, side);
    }

    @Override
    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        return slotID == 3 && ChargeUtils.canBeDischarged(itemstack);
    }

    @Override
    public boolean func_180461_b(int slotID, ItemStack itemstack, EnumFacing side) {
        if (slotID == 0 || slotID == 2) {
            return itemstack != null && itemstack.func_77973_b() instanceof IGasItem && ((IGasItem)itemstack.func_77973_b()).canReceiveGas(itemstack, null);
        }
        if (slotID == 1) {
            return itemstack != null && itemstack.func_77973_b() instanceof IGasItem && ((IGasItem)itemstack.func_77973_b()).canProvideGas(itemstack, null);
        }
        if (slotID == 3) {
            return ChargeUtils.canBeOutputted(itemstack, false);
        }
        return false;
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        if (side == MekanismUtils.getLeft(this.facing)) {
            return new int[]{0};
        }
        if (side == this.facing) {
            return new int[]{1};
        }
        if (side == MekanismUtils.getRight(this.facing)) {
            return new int[]{2};
        }
        if (side.func_176740_k() == EnumFacing.Axis.Y) {
            return new int[3];
        }
        return InventoryUtils.EMPTY;
    }

    @Override
    public void writeSustainedData(ItemStack itemStack) {
        if (this.leftTank.getGas() != null) {
            ItemDataUtils.setCompound(itemStack, "leftTank", this.leftTank.getGas().write(new NBTTagCompound()));
        }
        if (this.rightTank.getGas() != null) {
            ItemDataUtils.setCompound(itemStack, "rightTank", this.rightTank.getGas().write(new NBTTagCompound()));
        }
        if (this.centerTank.getGas() != null) {
            ItemDataUtils.setCompound(itemStack, "centerTank", this.centerTank.getGas().write(new NBTTagCompound()));
        }
    }

    @Override
    public void readSustainedData(ItemStack itemStack) {
        this.leftTank.setGas(GasStack.readFromNBT(ItemDataUtils.getCompound(itemStack, "leftTank")));
        this.rightTank.setGas(GasStack.readFromNBT(ItemDataUtils.getCompound(itemStack, "rightTank")));
        this.centerTank.setGas(GasStack.readFromNBT(ItemDataUtils.getCompound(itemStack, "centerTank")));
    }

    @Override
    public List<String> getInfo(Upgrade upgrade) {
        return upgrade == Upgrade.SPEED ? upgrade.getExpScaledInfo(this) : upgrade.getMultScaledInfo(this);
    }

    @Override
    public Object[] getTanks() {
        return new Object[]{this.leftTank, this.rightTank, this.centerTank};
    }
}

