/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.machines;

import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.common.recipe.inputs.PressurizedInput;
import mekanism.common.recipe.machines.MachineRecipe;
import mekanism.common.recipe.outputs.PressurizedOutput;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class PressurizedRecipe
extends MachineRecipe<PressurizedInput, PressurizedOutput, PressurizedRecipe> {
    public double extraEnergy;
    public int ticks;

    public PressurizedRecipe(ItemStack inputSolid, FluidStack inputFluid, GasStack inputGas, ItemStack outputSolid, GasStack outputGas, double energy, int duration) {
        this(new PressurizedInput(inputSolid, inputFluid, inputGas), new PressurizedOutput(outputSolid, outputGas), energy, duration);
    }

    public PressurizedRecipe(PressurizedInput pressurizedInput, PressurizedOutput pressurizedProducts, double energy, int duration) {
        super(pressurizedInput, pressurizedProducts);
        this.extraEnergy = energy;
        this.ticks = duration;
    }

    public PressurizedRecipe(PressurizedInput pressurizedInput, PressurizedOutput pressurizedProducts, NBTTagCompound extraNBT) {
        super(pressurizedInput, pressurizedProducts);
        this.extraEnergy = extraNBT.func_74769_h("extraEnergy");
        this.ticks = extraNBT.func_74762_e("duration");
    }

    @Override
    public PressurizedRecipe copy() {
        return new PressurizedRecipe(((PressurizedInput)this.getInput()).copy(), ((PressurizedOutput)this.getOutput()).copy(), this.extraEnergy, this.ticks);
    }

    public boolean canOperate(ItemStack[] inventory, FluidTank inputFluidTank, GasTank inputGasTank, GasTank outputGasTank) {
        return ((PressurizedInput)this.getInput()).use(inventory, 0, inputFluidTank, inputGasTank, false) && ((PressurizedOutput)this.getOutput()).applyOutputs(inventory, 2, outputGasTank, false);
    }

    public void operate(ItemStack[] inventory, FluidTank inputFluidTank, GasTank inputGasTank, GasTank outputGasTank) {
        if (((PressurizedInput)this.getInput()).use(inventory, 0, inputFluidTank, inputGasTank, true)) {
            ((PressurizedOutput)this.getOutput()).applyOutputs(inventory, 2, outputGasTank, true);
        }
    }
}

