/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item;

import java.util.List;
import mekanism.api.EnumColor;
import mekanism.api.MekanismAPI;
import mekanism.common.MekanismBlocks;
import mekanism.common.block.BlockCardboardBox;
import mekanism.common.tile.TileEntityCardboardBox;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.LangUtils;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBlockCardboardBox
extends ItemBlock {
    private static boolean isMonitoring;
    public Block metaBlock;

    public ItemBlockCardboardBox(Block block) {
        super(block);
        this.func_77625_d(1);
        this.metaBlock = block;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemstack, EntityPlayer entityplayer, List<String> list, boolean flag) {
        list.add((Object)((Object)EnumColor.INDIGO) + LangUtils.localize("tooltip.blockData") + ": " + LangUtils.transYesNo(this.getBlockData(itemstack) != null));
        BlockCardboardBox.BlockData data = this.getBlockData(itemstack);
        if (data != null) {
            try {
                list.add(LangUtils.localize("tooltip.block") + ": " + new ItemStack(data.block, 1, data.meta).func_82833_r());
                list.add(LangUtils.localize("tooltip.meta") + ": " + data.meta);
                if (data.tileTag != null) {
                    list.add(LangUtils.localize("tooltip.tile") + ": " + data.tileTag.func_74779_i("id"));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public int func_77647_b(int i) {
        return i;
    }

    public EnumActionResult onItemUseFirst(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        if (!player.func_70093_af() && !world.func_175623_d(pos) && stack.func_77952_i() == 0) {
            IBlockState state = world.func_180495_p(pos);
            Block block = state.func_177230_c();
            int meta = block.func_176201_c(state);
            if (!world.field_72995_K && MekanismAPI.isBlockCompatible(block, meta) && state.func_185887_b(world, pos) != -1.0f) {
                BlockCardboardBox.BlockData data = new BlockCardboardBox.BlockData();
                data.block = block;
                data.meta = meta;
                isMonitoring = true;
                if (world.func_175625_s(pos) != null) {
                    TileEntity tile = world.func_175625_s(pos);
                    NBTTagCompound tag = new NBTTagCompound();
                    tile.func_189515_b(tag);
                    data.tileTag = tag;
                }
                if (!player.field_71075_bZ.field_75098_d) {
                    --stack.field_77994_a;
                }
                world.func_180501_a(pos, MekanismBlocks.CardboardBox.func_176203_a(1), 3);
                isMonitoring = false;
                TileEntityCardboardBox tileEntity = (TileEntityCardboardBox)world.func_175625_s(pos);
                if (tileEntity != null) {
                    tileEntity.storedData = data;
                }
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.PASS;
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState state) {
        TileEntityCardboardBox tileEntity;
        if (world.field_72995_K) {
            return true;
        }
        boolean place = super.placeBlockAt(stack, player, world, pos, side, hitX, hitY, hitZ, state);
        if (place && (tileEntity = (TileEntityCardboardBox)world.func_175625_s(pos)) != null) {
            tileEntity.storedData = this.getBlockData(stack);
        }
        return place;
    }

    public void setBlockData(ItemStack itemstack, BlockCardboardBox.BlockData data) {
        ItemDataUtils.setCompound(itemstack, "blockData", data.write(new NBTTagCompound()));
    }

    public BlockCardboardBox.BlockData getBlockData(ItemStack itemstack) {
        if (!ItemDataUtils.hasData(itemstack, "blockData")) {
            return null;
        }
        return BlockCardboardBox.BlockData.read(ItemDataUtils.getCompound(itemstack, "blockData"));
    }

    @SubscribeEvent
    public void onEntitySpawn(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityItem && isMonitoring) {
            event.setCanceled(true);
        }
    }
}

