/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration;

import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.peripheral.IPeripheralProvider;
import ic2.api.recipe.IMachineRecipeManager;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeInputItemStack;
import ic2.api.recipe.RecipeInputOreDict;
import ic2.api.recipe.Recipes;
import java.util.List;
import li.cil.oc.api.Driver;
import li.cil.oc.api.driver.SidedBlock;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.Mekanism;
import mekanism.common.MekanismItems;
import mekanism.common.Resource;
import mekanism.common.integration.computer.CCPeripheral;
import mekanism.common.integration.computer.OCDriver;
import mekanism.common.multipart.TransmitterType;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.util.MekanismUtils;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.event.FMLInterModComms;

public final class MekanismHooks {
    public boolean IC2Loaded = false;
    public boolean RailcraftLoaded = false;
    public boolean CoFHCoreLoaded = false;
    public boolean TELoaded = false;
    public boolean CCLoaded = false;
    public boolean AE2Loaded = false;
    public boolean TeslaLoaded = false;
    public boolean MetallurgyCoreLoaded = false;
    public boolean MetallurgyBaseLoaded = false;

    public void hook() {
        if (Loader.isModLoaded((String)"CoFHCore")) {
            this.CoFHCoreLoaded = true;
        }
        if (Loader.isModLoaded((String)"IC2")) {
            this.IC2Loaded = true;
        }
        if (Loader.isModLoaded((String)"Railcraft")) {
            this.RailcraftLoaded = true;
        }
        if (Loader.isModLoaded((String)"ThermalExpansion")) {
            this.TELoaded = true;
        }
        if (Loader.isModLoaded((String)"ComputerCraft")) {
            this.CCLoaded = true;
        }
        if (Loader.isModLoaded((String)"appliedenergistics2")) {
            this.AE2Loaded = true;
        }
        if (Loader.isModLoaded((String)"tesla")) {
            this.TeslaLoaded = true;
        }
        if (Loader.isModLoaded((String)"Metallurgy3Core")) {
            this.MetallurgyCoreLoaded = true;
            if (Loader.isModLoaded((String)"Metallurgy3Base")) {
                this.MetallurgyBaseLoaded = true;
            }
        }
        if (this.IC2Loaded) {
            this.hookIC2Recipes();
            Mekanism.logger.info("Hooked into IC2 successfully.");
        }
        if (this.CCLoaded) {
            this.loadCCPeripheralProviders();
        }
    }

    @Optional.Method(modid="IC2")
    public void hookIC2Recipes() {
        block6: for (IMachineRecipeManager.RecipeIoContainer entry : Recipes.macerator.getRecipes()) {
            if (entry.input.getInputs().isEmpty()) continue;
            List<String> names = MekanismUtils.getOreDictName((ItemStack)entry.input.getInputs().get(0));
            for (String name : names) {
                boolean did = false;
                if (name.startsWith("ingot")) {
                    RecipeHandler.addCrusherRecipe((ItemStack)entry.input.getInputs().get(0), (ItemStack)entry.output.items.get(0));
                    did = true;
                }
                if (!did) continue;
                continue block6;
            }
        }
        try {
            Recipes.macerator.addRecipe((IRecipeInput)new RecipeInputOreDict("oreOsmium"), null, false, new ItemStack[]{new ItemStack(MekanismItems.Dust, 2, Resource.OSMIUM.ordinal())});
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Recipes.macerator.addRecipe((IRecipeInput)new RecipeInputOreDict("ingotOsmium"), null, false, new ItemStack[]{new ItemStack(MekanismItems.Dust, 1, Resource.OSMIUM.ordinal())});
            Recipes.macerator.addRecipe((IRecipeInput)new RecipeInputOreDict("ingotRefinedObsidian"), null, false, new ItemStack[]{new ItemStack(MekanismItems.OtherDust, 1, 5)});
            Recipes.macerator.addRecipe((IRecipeInput)new RecipeInputOreDict("ingotRefinedGlowstone"), null, false, new ItemStack[]{new ItemStack(Items.field_151114_aO)});
            Recipes.macerator.addRecipe((IRecipeInput)new RecipeInputOreDict("ingotSteel"), null, false, new ItemStack[]{new ItemStack(MekanismItems.OtherDust, 1, 1)});
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            for (Resource resource : Resource.values()) {
                Recipes.macerator.addRecipe((IRecipeInput)new RecipeInputOreDict("clump" + resource.getName()), null, false, new ItemStack[]{new ItemStack(MekanismItems.DirtyDust, 1, resource.ordinal())});
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("amplification", 50000);
        Recipes.matterAmplifier.addRecipe((IRecipeInput)new RecipeInputItemStack(new ItemStack(MekanismItems.EnrichedAlloy), 1), tag, false, new ItemStack[0]);
    }

    @Optional.Method(modid="ComputerCraft")
    public void loadCCPeripheralProviders() {
        try {
            ComputerCraftAPI.registerPeripheralProvider((IPeripheralProvider)new CCPeripheral.CCPeripheralProvider());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Optional.Method(modid="OpenComputers")
    public void loadOCDrivers() {
        try {
            Driver.add((SidedBlock)new OCDriver());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addPulverizerRecipe(ItemStack input, ItemStack output, int energy) {
        NBTTagCompound nbtTags = new NBTTagCompound();
        nbtTags.func_74768_a("energy", energy);
        nbtTags.func_74782_a("input", (NBTBase)input.func_77955_b(new NBTTagCompound()));
        nbtTags.func_74782_a("primaryOutput", (NBTBase)output.func_77955_b(new NBTTagCompound()));
        FMLInterModComms.sendMessage((String)"mekanism", (String)"PulverizerRecipe", (NBTTagCompound)nbtTags);
    }

    @Optional.Method(modid="appliedenergistics2")
    public void registerAE2P2P() {
        String energyP2P = "add-p2p-attunement-rf-power";
        if (this.IC2Loaded) {
            energyP2P = "add-p2p-attunement-ic2-power";
        }
        for (TransmitterType type : TransmitterType.values()) {
            if (type.getTransmission().equals((Object)TransmissionType.ITEM)) {
                FMLInterModComms.sendMessage((String)"appliedenergistics2", (String)"add-p2p-attunement-item", (ItemStack)new ItemStack(MekanismItems.PartTransmitter, 1, type.ordinal()));
                continue;
            }
            if (type.getTransmission().equals((Object)TransmissionType.FLUID)) {
                FMLInterModComms.sendMessage((String)"appliedenergistics2", (String)"add-p2p-attunement-fluid", (ItemStack)new ItemStack(MekanismItems.PartTransmitter, 1, type.ordinal()));
                continue;
            }
            if (!type.getTransmission().equals((Object)TransmissionType.ENERGY)) continue;
            FMLInterModComms.sendMessage((String)"appliedenergistics2", (String)energyP2P, (ItemStack)new ItemStack(MekanismItems.PartTransmitter, 1, type.ordinal()));
        }
    }
}

