/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.transporter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.common.base.ISideConfiguration;
import mekanism.common.content.transporter.TransitRequest;
import mekanism.common.content.transporter.TransporterStack;
import mekanism.common.tile.TileEntityBin;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StackUtils;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.items.IItemHandler;
import powercrystals.minefactoryreloaded.api.IDeepStorageUnit;

public class TransporterManager {
    public static Map<Coord4D, Set<TransporterStack>> flowingStacks = new HashMap<Coord4D, Set<TransporterStack>>();

    public static void reset() {
        flowingStacks.clear();
    }

    public static void add(TransporterStack stack) {
        HashSet<TransporterStack> set = new HashSet<TransporterStack>();
        set.add(stack);
        if (flowingStacks.get(stack.getDest()) == null) {
            flowingStacks.put(stack.getDest(), set);
        } else {
            flowingStacks.get(stack.getDest()).addAll(set);
        }
    }

    public static void remove(TransporterStack stack) {
        if (stack.hasPath() && stack.pathType != TransporterStack.Path.NONE) {
            flowingStacks.get(stack.getDest()).remove(stack);
        }
    }

    public static List<TransporterStack> getStacksToDest(Coord4D dest) {
        ArrayList<TransporterStack> ret = new ArrayList<TransporterStack>();
        if (flowingStacks.containsKey(dest)) {
            for (TransporterStack stack : flowingStacks.get(dest)) {
                if (stack == null || stack.pathType == TransporterStack.Path.NONE || !stack.hasPath() || !stack.getDest().equals(dest)) continue;
                ret.add(stack);
            }
        }
        return ret;
    }

    public static InventoryCopy copyInv(IItemHandler handler) {
        ItemStack[] ret = new ItemStack[handler.getSlots()];
        for (int i = 0; i < handler.getSlots(); ++i) {
            ret[i] = handler.getStackInSlot(i);
        }
        return new InventoryCopy(ret);
    }

    public static InventoryCopy copyInvFromSide(IInventory inv, EnumFacing side) {
        ItemStack[] ret = new ItemStack[inv.func_70302_i_()];
        if (!(inv instanceof ISidedInventory)) {
            for (int i = 0; i <= inv.func_70302_i_() - 1; ++i) {
                ret[i] = inv.func_70301_a(i) != null ? inv.func_70301_a(i).func_77946_l() : null;
            }
        } else {
            ISidedInventory sidedInventory = (ISidedInventory)inv;
            int[] slots = sidedInventory.func_180463_a(side.func_176734_d());
            if (slots == null || slots.length == 0) {
                return null;
            }
            for (int get = 0; get <= slots.length - 1; ++get) {
                int slotID = slots[get];
                ret[slotID] = sidedInventory.func_70301_a(slotID) != null ? sidedInventory.func_70301_a(slotID).func_77946_l() : null;
            }
            if (inv instanceof TileEntityBin) {
                return new InventoryCopy(ret, ((TileEntityBin)inv).getItemCount());
            }
            return new InventoryCopy(ret);
        }
        return new InventoryCopy(ret);
    }

    public static void testInsert(TileEntity tile, InventoryCopy copy, EnumFacing side, TransporterStack stack) {
        block22: {
            ItemStack inSlot;
            IInventory inv;
            ItemStack toInsert;
            block21: {
                toInsert = stack.itemStack.func_77946_l();
                if (stack.pathType != TransporterStack.Path.HOME && tile instanceof ISideConfiguration) {
                    ISideConfiguration config = (ISideConfiguration)tile;
                    EnumFacing tileSide = config.getOrientation();
                    EnumColor configColor = config.getEjector().getInputColor(MekanismUtils.getBaseOrientation(side, tileSide).func_176734_d());
                    if (config.getEjector().hasStrictInput() && configColor != null && configColor != stack.color) {
                        return;
                    }
                }
                if (Loader.isModLoaded((String)"MinefactoryReloaded") && tile instanceof IDeepStorageUnit && !(tile instanceof TileEntityBin)) {
                    return;
                }
                if (!(tile instanceof ISidedInventory)) break block21;
                ISidedInventory sidedInventory = (ISidedInventory)tile;
                int[] slots = sidedInventory.func_180463_a(side.func_176734_d());
                if (slots == null || slots.length == 0) break block22;
                if (stack.pathType != TransporterStack.Path.HOME && sidedInventory instanceof TileEntityBin && side.func_176734_d() == EnumFacing.DOWN) {
                    slots = sidedInventory.func_180463_a(EnumFacing.UP);
                }
                if (tile instanceof TileEntityBin) {
                    int slot = slots[0];
                    if (!sidedInventory.func_94041_b(slot, toInsert) || !sidedInventory.func_180462_a(slot, toInsert, side.func_176734_d())) {
                        return;
                    }
                    int amountRemaining = ((TileEntityBin)sidedInventory).getMaxStoredCount() - copy.binAmount;
                    copy.binAmount += Math.min(amountRemaining, toInsert.field_77994_a);
                    return;
                }
                for (int get = 0; get <= slots.length - 1; ++get) {
                    ItemStack toSet;
                    int slotID = slots[get];
                    if (stack.pathType != TransporterStack.Path.HOME && (!sidedInventory.func_94041_b(slotID, toInsert) || !sidedInventory.func_180462_a(slotID, toInsert, side.func_176734_d()))) continue;
                    ItemStack inSlot2 = copy.inventory[slotID];
                    if (inSlot2 == null) {
                        if (toInsert.field_77994_a <= sidedInventory.func_70297_j_()) {
                            copy.inventory[slotID] = toInsert;
                            return;
                        }
                        int rejects = toInsert.field_77994_a - sidedInventory.func_70297_j_();
                        toSet = toInsert.func_77946_l();
                        toSet.field_77994_a = sidedInventory.func_70297_j_();
                        ItemStack remains = toInsert.func_77946_l();
                        remains.field_77994_a = rejects;
                        copy.inventory[slotID] = toSet;
                        toInsert = remains;
                        continue;
                    }
                    if (!InventoryUtils.areItemsStackable(toInsert, inSlot2) || inSlot2.field_77994_a >= Math.min(inSlot2.func_77976_d(), sidedInventory.func_70297_j_())) continue;
                    int max = Math.min(inSlot2.func_77976_d(), sidedInventory.func_70297_j_());
                    if (inSlot2.field_77994_a + toInsert.field_77994_a <= max) {
                        toSet = toInsert.func_77946_l();
                        toSet.field_77994_a += inSlot2.field_77994_a;
                        copy.inventory[slotID] = toSet;
                        return;
                    }
                    int rejects = inSlot2.field_77994_a + toInsert.field_77994_a - max;
                    ItemStack toSet2 = toInsert.func_77946_l();
                    toSet2.field_77994_a = max;
                    ItemStack remains = toInsert.func_77946_l();
                    remains.field_77994_a = rejects;
                    copy.inventory[slotID] = toSet2;
                    toInsert = remains;
                }
                break block22;
            }
            if (tile instanceof IInventory) {
                inv = InventoryUtils.checkChestInv((IInventory)tile);
                for (int i = 0; i <= inv.func_70302_i_() - 1; ++i) {
                    if (stack.pathType != TransporterStack.Path.HOME && !inv.func_94041_b(i, toInsert)) continue;
                    inSlot = copy.inventory[i];
                    if (inSlot == null) {
                        if (toInsert.field_77994_a <= inv.func_70297_j_()) {
                            copy.inventory[i] = toInsert;
                            return;
                        }
                        int rejects = toInsert.field_77994_a - inv.func_70297_j_();
                        ItemStack toSet = toInsert.func_77946_l();
                        toSet.field_77994_a = inv.func_70297_j_();
                        ItemStack remains = toInsert.func_77946_l();
                        remains.field_77994_a = rejects;
                        copy.inventory[i] = toSet;
                        toInsert = remains;
                        continue;
                    }
                    if (!InventoryUtils.areItemsStackable(toInsert, inSlot) || inSlot.field_77994_a >= Math.min(inSlot.func_77976_d(), inv.func_70297_j_())) continue;
                    int max = Math.min(inSlot.func_77976_d(), inv.func_70297_j_());
                    if (inSlot.field_77994_a + toInsert.field_77994_a <= max) {
                        ItemStack toSet = toInsert.func_77946_l();
                        toSet.field_77994_a += inSlot.field_77994_a;
                        copy.inventory[i] = toSet;
                        return;
                    }
                    int rejects = inSlot.field_77994_a + toInsert.field_77994_a - max;
                    ItemStack toSet = toInsert.func_77946_l();
                    toSet.field_77994_a = max;
                    ItemStack remains = toInsert.func_77946_l();
                    remains.field_77994_a = rejects;
                    copy.inventory[i] = toSet;
                    toInsert = remains;
                }
            } else if (InventoryUtils.isItemHandler(tile, side.func_176734_d())) {
                inv = InventoryUtils.getItemHandler(tile, side.func_176734_d());
                for (int i = 0; i <= inv.getSlots() - 1; ++i) {
                    ItemStack rejectStack;
                    if (stack.pathType != TransporterStack.Path.HOME && !TransporterManager.didEmit(toInsert, rejectStack = inv.insertItem(i, toInsert, true))) continue;
                    inSlot = copy.inventory[i];
                    if (inSlot == null) {
                        if (toInsert.field_77994_a <= toInsert.func_77976_d()) {
                            copy.inventory[i] = toInsert;
                            return;
                        }
                        int rejects = toInsert.field_77994_a - toInsert.func_77976_d();
                        ItemStack toSet = toInsert.func_77946_l();
                        toSet.field_77994_a = toInsert.func_77976_d();
                        ItemStack remains = toInsert.func_77946_l();
                        remains.field_77994_a = rejects;
                        copy.inventory[i] = toSet;
                        toInsert = remains;
                        continue;
                    }
                    if (!InventoryUtils.areItemsStackable(toInsert, inSlot) || inSlot.field_77994_a >= inSlot.func_77976_d()) continue;
                    int max = inSlot.func_77976_d();
                    if (inSlot.field_77994_a + toInsert.field_77994_a <= max) {
                        ItemStack toSet = toInsert.func_77946_l();
                        toSet.field_77994_a += inSlot.field_77994_a;
                        copy.inventory[i] = toSet;
                        return;
                    }
                    int rejects = inSlot.field_77994_a + toInsert.field_77994_a - max;
                    ItemStack toSet = toInsert.func_77946_l();
                    toSet.field_77994_a = max;
                    ItemStack remains = toInsert.func_77946_l();
                    remains.field_77994_a = rejects;
                    copy.inventory[i] = toSet;
                    toInsert = remains;
                }
            }
        }
    }

    public static boolean didEmit(ItemStack stack, ItemStack returned) {
        return returned == null || returned.field_77994_a < stack.field_77994_a;
    }

    public static ItemStack getToUse(ItemStack stack, ItemStack returned) {
        if (returned == null || returned.field_77994_a == 0) {
            return stack;
        }
        return MekanismUtils.size(stack, stack.field_77994_a - returned.field_77994_a);
    }

    public static ItemStack getToUse(ItemStack stack, int rejected) {
        return MekanismUtils.size(stack, stack.field_77994_a - rejected);
    }

    public static TransitRequest.TransitResponse getPredictedInsert(TileEntity tileEntity, EnumColor color, TransitRequest request, EnumFacing side) {
        if (tileEntity instanceof ISideConfiguration) {
            ISideConfiguration config = (ISideConfiguration)tileEntity;
            EnumFacing tileSide = config.getOrientation();
            EnumColor configColor = config.getEjector().getInputColor(MekanismUtils.getBaseOrientation(side, tileSide).func_176734_d());
            if (config.getEjector().hasStrictInput() && configColor != null && configColor != color) {
                return TransitRequest.TransitResponse.EMPTY;
            }
        }
        InventoryCopy copy = null;
        if (tileEntity instanceof IInventory) {
            copy = TransporterManager.copyInvFromSide(InventoryUtils.checkChestInv((IInventory)tileEntity), side);
        } else if (InventoryUtils.isItemHandler(tileEntity, side.func_176734_d())) {
            copy = TransporterManager.copyInv(InventoryUtils.getItemHandler(tileEntity, side.func_176734_d()));
        }
        if (copy == null) {
            return TransitRequest.TransitResponse.EMPTY;
        }
        List<TransporterStack> insertQueue = TransporterManager.getStacksToDest(Coord4D.get(tileEntity));
        for (TransporterStack transporterStack : insertQueue) {
            TransporterManager.testInsert(tileEntity, copy, side, transporterStack);
        }
        for (Map.Entry entry : request.itemMap.entrySet()) {
            IInventory inventory;
            int rejects;
            ItemStack toInsert = ((ItemStack)entry.getKey()).func_77946_l();
            if (tileEntity instanceof ISidedInventory) {
                ISidedInventory sidedInventory = (ISidedInventory)tileEntity;
                int[] slots = sidedInventory.func_180463_a(side.func_176734_d());
                if (slots == null || slots.length == 0) continue;
                if (tileEntity instanceof TileEntityBin) {
                    int slot = slots[0];
                    if (!sidedInventory.func_94041_b(slot, toInsert) || !sidedInventory.func_180462_a(slot, toInsert, side.func_176734_d())) continue;
                    int amountRemaining = ((TileEntityBin)tileEntity).getMaxStoredCount() - copy.binAmount;
                    ItemStack ret = null;
                    ret = toInsert.field_77994_a <= amountRemaining ? toInsert : StackUtils.size(toInsert, amountRemaining);
                    return new TransitRequest.TransitResponse((Integer)entry.getValue(), ret);
                }
                for (int get = 0; get <= slots.length - 1; ++get) {
                    int slotID = slots[get];
                    if (!sidedInventory.func_94041_b(slotID, toInsert) || !sidedInventory.func_180462_a(slotID, toInsert, side.func_176734_d())) continue;
                    ItemStack inSlot = copy.inventory[slotID];
                    if (toInsert == null) {
                        return new TransitRequest.TransitResponse((Integer)entry.getValue(), (ItemStack)entry.getKey());
                    }
                    if (inSlot == null) {
                        if (toInsert.field_77994_a <= sidedInventory.func_70297_j_()) {
                            return new TransitRequest.TransitResponse((Integer)entry.getValue(), (ItemStack)entry.getKey());
                        }
                        rejects = toInsert.field_77994_a - sidedInventory.func_70297_j_();
                        if (rejects >= toInsert.field_77994_a) continue;
                        toInsert = StackUtils.size(toInsert, rejects);
                        continue;
                    }
                    if (!InventoryUtils.areItemsStackable(toInsert, inSlot) || inSlot.field_77994_a >= Math.min(inSlot.func_77976_d(), sidedInventory.func_70297_j_())) continue;
                    int max = Math.min(inSlot.func_77976_d(), sidedInventory.func_70297_j_());
                    if (inSlot.field_77994_a + toInsert.field_77994_a <= max) {
                        return new TransitRequest.TransitResponse((Integer)entry.getValue(), (ItemStack)entry.getKey());
                    }
                    int rejects2 = inSlot.field_77994_a + toInsert.field_77994_a - max;
                    if (rejects2 >= toInsert.field_77994_a) continue;
                    toInsert = StackUtils.size(toInsert, rejects2);
                }
                if (!TransporterManager.didEmit((ItemStack)entry.getKey(), toInsert)) continue;
                return new TransitRequest.TransitResponse((Integer)entry.getValue(), TransporterManager.getToUse((ItemStack)entry.getKey(), toInsert));
            }
            if (tileEntity instanceof IInventory) {
                inventory = InventoryUtils.checkChestInv((IInventory)tileEntity);
                for (int i = 0; i <= inventory.func_70302_i_() - 1; ++i) {
                    if (!inventory.func_94041_b(i, toInsert)) continue;
                    ItemStack inSlot = copy.inventory[i];
                    if (toInsert == null) {
                        return new TransitRequest.TransitResponse((Integer)entry.getValue(), (ItemStack)entry.getKey());
                    }
                    if (inSlot == null) {
                        if (toInsert.field_77994_a <= inventory.func_70297_j_()) {
                            return new TransitRequest.TransitResponse((Integer)entry.getValue(), (ItemStack)entry.getKey());
                        }
                        int rejects3 = toInsert.field_77994_a - inventory.func_70297_j_();
                        if (rejects3 >= toInsert.field_77994_a) continue;
                        toInsert = StackUtils.size(toInsert, rejects3);
                        continue;
                    }
                    if (!InventoryUtils.areItemsStackable(toInsert, inSlot) || inSlot.field_77994_a >= Math.min(inSlot.func_77976_d(), inventory.func_70297_j_())) continue;
                    int max = Math.min(inSlot.func_77976_d(), inventory.func_70297_j_());
                    if (inSlot.field_77994_a + toInsert.field_77994_a <= max) {
                        return new TransitRequest.TransitResponse((Integer)entry.getValue(), (ItemStack)entry.getKey());
                    }
                    int rejects4 = inSlot.field_77994_a + toInsert.field_77994_a - max;
                    if (rejects4 >= toInsert.field_77994_a) continue;
                    toInsert = StackUtils.size(toInsert, rejects4);
                }
                if (!TransporterManager.didEmit((ItemStack)entry.getKey(), toInsert)) continue;
                return new TransitRequest.TransitResponse((Integer)entry.getValue(), TransporterManager.getToUse((ItemStack)entry.getKey(), toInsert));
            }
            if (!InventoryUtils.isItemHandler(tileEntity, side.func_176734_d())) continue;
            inventory = InventoryUtils.getItemHandler(tileEntity, side.func_176734_d());
            for (int i = 0; i <= inventory.getSlots() - 1; ++i) {
                ItemStack rejectStack = inventory.insertItem(i, toInsert, true);
                if (!TransporterManager.didEmit(toInsert, rejectStack)) continue;
                ItemStack inSlot = copy.inventory[i];
                if (toInsert == null) {
                    return new TransitRequest.TransitResponse((Integer)entry.getValue(), (ItemStack)entry.getKey());
                }
                if (inSlot == null) {
                    if (toInsert.field_77994_a <= toInsert.func_77976_d()) {
                        return new TransitRequest.TransitResponse((Integer)entry.getValue(), (ItemStack)entry.getKey());
                    }
                    int rejects5 = toInsert.field_77994_a - toInsert.func_77976_d();
                    if (rejects5 >= toInsert.field_77994_a) continue;
                    toInsert = StackUtils.size(toInsert, rejects5);
                    continue;
                }
                if (!InventoryUtils.areItemsStackable(toInsert, inSlot) || inSlot.field_77994_a >= inSlot.func_77976_d()) continue;
                int max = inSlot.func_77976_d();
                if (inSlot.field_77994_a + toInsert.field_77994_a <= max) {
                    return new TransitRequest.TransitResponse((Integer)entry.getValue(), (ItemStack)entry.getKey());
                }
                rejects = inSlot.field_77994_a + toInsert.field_77994_a - max;
                if (rejects >= toInsert.field_77994_a) continue;
                toInsert = StackUtils.size(toInsert, rejects);
            }
            if (!TransporterManager.didEmit((ItemStack)entry.getKey(), toInsert)) continue;
            return new TransitRequest.TransitResponse((Integer)entry.getValue(), TransporterManager.getToUse((ItemStack)entry.getKey(), toInsert));
        }
        return TransitRequest.TransitResponse.EMPTY;
    }

    public static class InventoryCopy {
        public ItemStack[] inventory;
        public int binAmount;

        public InventoryCopy(ItemStack[] inv) {
            this.inventory = inv;
        }

        public InventoryCopy(ItemStack[] inv, int amount) {
            this(inv);
            this.binAmount = amount;
        }
    }
}

