/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.transporter;

import mekanism.common.content.transporter.Finder;
import mekanism.common.content.transporter.InvStack;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.StackUtils;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.items.IItemHandler;

public class StackSearcher {
    public int i = -1;
    public int[] slots;
    public TileEntity tileEntity;
    public EnumFacing side;

    public StackSearcher(TileEntity tile, EnumFacing direction) {
        this.tileEntity = tile;
        this.side = direction;
        if (tile instanceof ISidedInventory) {
            this.slots = ((ISidedInventory)tile).func_180463_a(this.side.func_176734_d());
            if (this.slots != null) {
                this.i = this.slots.length;
            }
        } else if (tile instanceof IInventory) {
            this.i = ((IInventory)tile).func_70302_i_();
        } else if (InventoryUtils.isItemHandler(tile, direction.func_176734_d())) {
            this.i = InventoryUtils.getItemHandler(tile, direction.func_176734_d()).getSlots();
        }
    }

    public InvStack takeTopStack(Finder id) {
        block10: {
            block9: {
                if (!(this.tileEntity instanceof ISidedInventory)) break block9;
                ISidedInventory inventory = (ISidedInventory)this.tileEntity;
                if (this.slots == null || this.slots.length == 0) break block10;
                --this.i;
                while (this.i >= 0) {
                    ItemStack toSend;
                    int slotID = this.slots[this.i];
                    if (inventory.func_70301_a(slotID) != null && id.modifies(inventory.func_70301_a(slotID)) && inventory.func_180461_b(slotID, toSend = inventory.func_70301_a(slotID), this.side.func_176734_d())) {
                        return new InvStack(this.tileEntity, slotID, toSend, this.side.func_176734_d());
                    }
                    --this.i;
                }
                break block10;
            }
            if (this.tileEntity instanceof IInventory) {
                IInventory inventory = InventoryUtils.checkChestInv((IInventory)this.tileEntity);
                --this.i;
                while (this.i >= 0) {
                    if (inventory.func_70301_a(this.i) != null && id.modifies(inventory.func_70301_a(this.i))) {
                        ItemStack toSend = inventory.func_70301_a(this.i).func_77946_l();
                        return new InvStack(this.tileEntity, this.i, toSend, this.side.func_176734_d());
                    }
                    --this.i;
                }
            } else if (InventoryUtils.isItemHandler(this.tileEntity, this.side.func_176734_d())) {
                IItemHandler inventory = InventoryUtils.getItemHandler(this.tileEntity, this.side.func_176734_d());
                --this.i;
                while (this.i >= 0) {
                    ItemStack stack = inventory.extractItem(this.i, 64, true);
                    if (stack != null && id.modifies(stack)) {
                        return new InvStack(this.tileEntity, this.i, stack, this.side.func_176734_d());
                    }
                    --this.i;
                }
            }
        }
        return null;
    }

    public InvStack takeDefinedItem(ItemStack type, int min, int max) {
        InvStack ret = new InvStack(this.tileEntity, this.side.func_176734_d());
        if (this.tileEntity instanceof ISidedInventory) {
            ISidedInventory sidedInventory = (ISidedInventory)this.tileEntity;
            int[] slots = sidedInventory.func_180463_a(this.side.func_176734_d());
            if (slots != null && slots.length != 0) {
                --this.i;
                while (this.i >= 0) {
                    int slotID = slots[this.i];
                    if (sidedInventory.func_70301_a(slotID) != null && StackUtils.equalsWildcard(sidedInventory.func_70301_a(slotID), type)) {
                        ItemStack copy;
                        int current;
                        ItemStack stack = sidedInventory.func_70301_a(slotID);
                        int n = current = ret.getStack() != null ? ret.getStack().field_77994_a : 0;
                        if (current + stack.field_77994_a <= max) {
                            copy = stack.func_77946_l();
                            if (sidedInventory.func_180461_b(slotID, copy, this.side.func_176734_d())) {
                                ret.appendStack(slotID, copy);
                            }
                        } else {
                            copy = stack.func_77946_l();
                            if (sidedInventory.func_180461_b(slotID, copy, this.side.func_176734_d())) {
                                copy.field_77994_a = max - current;
                                ret.appendStack(slotID, copy);
                            }
                        }
                        if (ret.getStack() != null && ret.getStack().field_77994_a == max) {
                            return ret;
                        }
                    }
                    --this.i;
                }
            }
        } else if (this.tileEntity instanceof IInventory) {
            IInventory inventory = InventoryUtils.checkChestInv((IInventory)this.tileEntity);
            --this.i;
            while (this.i >= 0) {
                if (inventory.func_70301_a(this.i) != null && StackUtils.equalsWildcard(inventory.func_70301_a(this.i), type)) {
                    int current;
                    ItemStack stack = inventory.func_70301_a(this.i);
                    int n = current = ret.getStack() != null ? ret.getStack().field_77994_a : 0;
                    if (current + stack.field_77994_a <= max) {
                        ret.appendStack(this.i, stack.func_77946_l());
                    } else {
                        ItemStack copy = stack.func_77946_l();
                        copy.field_77994_a = max - current;
                        ret.appendStack(this.i, copy);
                    }
                    if (ret.getStack() != null && ret.getStack().field_77994_a == max) {
                        return ret;
                    }
                }
                --this.i;
            }
        } else if (InventoryUtils.isItemHandler(this.tileEntity, this.side.func_176734_d())) {
            IItemHandler inventory = InventoryUtils.getItemHandler(this.tileEntity, this.side.func_176734_d());
            --this.i;
            while (this.i >= 0) {
                ItemStack stack = inventory.extractItem(this.i, max, true);
                if (stack != null && StackUtils.equalsWildcard(stack, type)) {
                    int current;
                    int n = current = ret.getStack() != null ? ret.getStack().field_77994_a : 0;
                    if (current + stack.field_77994_a <= max) {
                        ret.appendStack(this.i, stack.func_77946_l());
                    } else {
                        ItemStack copy = stack.func_77946_l();
                        copy.field_77994_a = max - current;
                        ret.appendStack(this.i, copy);
                    }
                    if (ret.getStack() != null && ret.getStack().field_77994_a == max) {
                        return ret;
                    }
                }
                --this.i;
            }
        }
        if (ret != null && ret.getStack() != null && ret.getStack().field_77994_a >= min) {
            return ret;
        }
        return null;
    }
}

