/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.boiler;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import mekanism.api.Coord4D;
import mekanism.api.IHeatTransfer;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.tank.SynchronizedTankData;
import mekanism.common.multiblock.SynchronizedData;
import mekanism.common.util.UnitDisplayUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidStack;

public class SynchronizedBoilerData
extends SynchronizedData<SynchronizedBoilerData>
implements IHeatTransfer {
    public static Map<String, Boolean> clientHotMap = new HashMap<String, Boolean>();
    public static double CASING_INSULATION_COEFFICIENT = 1.0;
    public static double CASING_INVERSE_CONDUCTION_COEFFICIENT = 1.0;
    public static double BASE_BOIL_TEMP = 100.0 - (UnitDisplayUtils.TemperatureUnit.AMBIENT.zeroOffset - UnitDisplayUtils.TemperatureUnit.CELSIUS.zeroOffset);
    public FluidStack waterStored;
    public FluidStack prevWater;
    public FluidStack steamStored;
    public FluidStack prevSteam;
    public double lastEnvironmentLoss;
    public int lastBoilRate;
    public int lastMaxBoil;
    public boolean clientHot;
    public double temperature;
    public double heatToAbsorb;
    public double heatCapacity = 1000.0;
    public int superheatingElements;
    public int waterVolume;
    public int steamVolume;
    public ItemStack[] inventory = new ItemStack[2];
    public Coord4D upperRenderLocation;
    public Set<SynchronizedTankData.ValveData> valves = new HashSet<SynchronizedTankData.ValveData>();

    public static double getHeatEnthalpy() {
        return MekanismConfig.general.maxEnergyPerSteam / MekanismConfig.general.energyPerHeat;
    }

    public double getHeatAvailable() {
        double heatAvailable = (this.temperature - BASE_BOIL_TEMP) * (double)this.locations.size();
        return Math.min(heatAvailable, (double)this.superheatingElements * MekanismConfig.general.superheatingHeatTransfer);
    }

    public boolean needsRenderUpdate() {
        if (this.waterStored == null && this.prevWater != null || this.waterStored != null && this.prevWater == null) {
            return true;
        }
        if (this.waterStored != null && this.prevWater != null && (this.waterStored.getFluid() != this.prevWater.getFluid() || this.waterStored.amount != this.prevWater.amount)) {
            return true;
        }
        if (this.steamStored == null && this.prevSteam != null || this.steamStored != null && this.prevSteam == null) {
            return true;
        }
        return this.steamStored != null && this.prevSteam != null && (this.steamStored.getFluid() != this.prevSteam.getFluid() || this.steamStored.amount != this.prevSteam.amount);
    }

    @Override
    public ItemStack[] getInventory() {
        return this.inventory;
    }

    @Override
    public double getTemp() {
        return this.temperature;
    }

    @Override
    public double getInverseConductionCoefficient() {
        return CASING_INVERSE_CONDUCTION_COEFFICIENT * (double)this.locations.size();
    }

    @Override
    public double getInsulationCoefficient(EnumFacing side) {
        return CASING_INSULATION_COEFFICIENT * (double)this.locations.size();
    }

    @Override
    public void transferHeatTo(double heat) {
        this.heatToAbsorb += heat;
    }

    @Override
    public double[] simulateHeat() {
        double invConduction = 10000.0 + (CASING_INSULATION_COEFFICIENT + CASING_INVERSE_CONDUCTION_COEFFICIENT) * (double)this.locations.size();
        double heatToTransfer = this.temperature / invConduction;
        this.transferHeatTo(-heatToTransfer);
        return new double[]{0.0, heatToTransfer};
    }

    @Override
    public double applyTemperatureChange() {
        this.temperature += this.heatToAbsorb / (double)this.locations.size();
        this.heatToAbsorb = 0.0;
        return this.temperature;
    }

    @Override
    public boolean canConnectHeat(EnumFacing side) {
        return false;
    }

    @Override
    public IHeatTransfer getAdjacent(EnumFacing side) {
        return null;
    }
}

