/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.transmitter;

import java.util.HashMap;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.transmitter.RenderTransmitterBase;
import mekanism.common.ColourRGBA;
import mekanism.common.config.MekanismConfig;
import mekanism.common.multipart.PartMechanicalPipe;
import mekanism.common.multipart.PartSidedPipe;
import mekanism.common.transmitters.grid.FluidNetwork;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.Fluid;
import org.lwjgl.opengl.GL11;

public class RenderMechanicalPipe
extends RenderTransmitterBase<PartMechanicalPipe> {
    private static HashMap<Integer, HashMap<Fluid, MekanismRenderer.DisplayInteger[]>> cachedLiquids = new HashMap();
    private static final int stages = 100;
    private static final double height = 0.45;
    private static final double offset = 0.015;

    public void renderMultipartAt(PartMechanicalPipe pipe, double x, double y, double z, float partialTick, int destroyStage) {
        if (MekanismConfig.client.opaqueTransmitters) {
            return;
        }
        float targetScale = pipe.getTransmitter().hasTransmitterNetwork() ? ((FluidNetwork)pipe.getTransmitter().getTransmitterNetwork()).fluidScale : (float)pipe.buffer.getFluidAmount() / (float)pipe.buffer.getCapacity();
        pipe.currentScale = (double)Math.abs(pipe.currentScale - targetScale) > 0.01 ? (12.0f * pipe.currentScale + targetScale) / 13.0f : targetScale;
        Fluid fluid = pipe.getTransmitter().hasTransmitterNetwork() ? ((FluidNetwork)pipe.getTransmitter().getTransmitterNetwork()).refFluid : (pipe.getBuffer() == null ? null : pipe.getBuffer().getFluid());
        float scale = Math.min(pipe.currentScale, 1.0f);
        if ((double)scale > 0.01 && fluid != null) {
            this.push();
            MekanismRenderer.glowOn(fluid.getLuminosity());
            MekanismRenderer.colorFluid(fluid);
            this.bindTexture(MekanismRenderer.getBlocksTexture());
            GL11.glTranslated((double)x, (double)y, (double)z);
            boolean gas = fluid.isGaseous();
            for (EnumFacing side : EnumFacing.field_82609_l) {
                if (pipe.getConnectionType(side) == PartSidedPipe.ConnectionType.NORMAL) {
                    MekanismRenderer.DisplayInteger[] displayLists = this.getListAndRender(side, fluid);
                    if (displayLists == null) continue;
                    if (!gas) {
                        displayLists[Math.max(3, (int)(scale * 99.0f))].render();
                        continue;
                    }
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)scale);
                    displayLists[99].render();
                    continue;
                }
                if (pipe.getConnectionType(side) == PartSidedPipe.ConnectionType.NONE) continue;
                GL11.glTranslated((double)0.5, (double)0.5, (double)0.5);
                Tessellator tessellator = Tessellator.func_178181_a();
                VertexBuffer worldRenderer = tessellator.func_178180_c();
                if (this.renderFluidInOut(worldRenderer, side, pipe)) {
                    tessellator.func_78381_a();
                }
                GL11.glTranslated((double)-0.5, (double)-0.5, (double)-0.5);
            }
            MekanismRenderer.DisplayInteger[] displayLists = this.getListAndRender(null, fluid);
            if (displayLists != null) {
                if (!gas) {
                    displayLists[Math.max(3, (int)(scale * 99.0f))].render();
                } else {
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)scale);
                    displayLists[99].render();
                }
            }
            MekanismRenderer.glowOff();
            MekanismRenderer.resetColor();
            this.pop();
        }
    }

    private MekanismRenderer.DisplayInteger[] getListAndRender(EnumFacing side, Fluid fluid) {
        int sideOrdinal;
        if (fluid == null) {
            return null;
        }
        int n = sideOrdinal = side != null ? side.ordinal() : 6;
        if (cachedLiquids.containsKey(sideOrdinal) && cachedLiquids.get(sideOrdinal).containsKey(fluid)) {
            return cachedLiquids.get(sideOrdinal).get(fluid);
        }
        MekanismRenderer.Model3D toReturn = new MekanismRenderer.Model3D();
        toReturn.baseBlock = Blocks.field_150355_j;
        toReturn.setTexture(MekanismRenderer.getFluidTexture(fluid, MekanismRenderer.FluidType.STILL));
        if (side != null) {
            toReturn.setSideRender(side, false);
            toReturn.setSideRender(side.func_176734_d(), false);
        }
        MekanismRenderer.DisplayInteger[] displays = new MekanismRenderer.DisplayInteger[100];
        if (cachedLiquids.containsKey(sideOrdinal)) {
            cachedLiquids.get(sideOrdinal).put(fluid, displays);
        } else {
            HashMap<Fluid, MekanismRenderer.DisplayInteger[]> map = new HashMap<Fluid, MekanismRenderer.DisplayInteger[]>();
            map.put(fluid, displays);
            cachedLiquids.put(sideOrdinal, map);
        }
        for (int i = 0; i < 100; ++i) {
            displays[i] = MekanismRenderer.DisplayInteger.createAndStart();
            switch (sideOrdinal) {
                case 6: {
                    toReturn.minX = 0.265;
                    toReturn.minY = 0.265;
                    toReturn.minZ = 0.265;
                    toReturn.maxX = 0.735;
                    toReturn.maxY = 0.265 + (double)((float)i / 100.0f) * 0.45;
                    toReturn.maxZ = 0.735;
                    break;
                }
                case 0: {
                    toReturn.minX = 0.5 - (double)((float)i / 100.0f) * 0.45 / 2.0;
                    toReturn.minY = 0.0;
                    toReturn.minZ = 0.5 - (double)((float)i / 100.0f) * 0.45 / 2.0;
                    toReturn.maxX = 0.5 + (double)((float)i / 100.0f) * 0.45 / 2.0;
                    toReturn.maxY = 0.265;
                    toReturn.maxZ = 0.5 + (double)((float)i / 100.0f) * 0.45 / 2.0;
                    break;
                }
                case 1: {
                    toReturn.minX = 0.5 - (double)((float)i / 100.0f) * 0.45 / 2.0;
                    toReturn.minY = 0.235 + (double)((float)i / 100.0f) * 0.45;
                    toReturn.minZ = 0.5 - (double)((float)i / 100.0f) * 0.45 / 2.0;
                    toReturn.maxX = 0.5 + (double)((float)i / 100.0f) * 0.45 / 2.0;
                    toReturn.maxY = 1.0;
                    toReturn.maxZ = 0.5 + (double)((float)i / 100.0f) * 0.45 / 2.0;
                    break;
                }
                case 2: {
                    toReturn.minX = 0.265;
                    toReturn.minY = 0.265;
                    toReturn.minZ = 0.0;
                    toReturn.maxX = 0.735;
                    toReturn.maxY = 0.265 + (double)((float)i / 100.0f) * 0.45;
                    toReturn.maxZ = 0.265;
                    break;
                }
                case 3: {
                    toReturn.minX = 0.265;
                    toReturn.minY = 0.265;
                    toReturn.minZ = 0.735;
                    toReturn.maxX = 0.735;
                    toReturn.maxY = 0.265 + (double)((float)i / 100.0f) * 0.45;
                    toReturn.maxZ = 1.0;
                    break;
                }
                case 4: {
                    toReturn.minX = 0.0;
                    toReturn.minY = 0.265;
                    toReturn.minZ = 0.265;
                    toReturn.maxX = 0.265;
                    toReturn.maxY = 0.265 + (double)((float)i / 100.0f) * 0.45;
                    toReturn.maxZ = 0.735;
                    break;
                }
                case 5: {
                    toReturn.minX = 0.735;
                    toReturn.minY = 0.265;
                    toReturn.minZ = 0.265;
                    toReturn.maxX = 1.0;
                    toReturn.maxY = 0.265 + (double)((float)i / 100.0f) * 0.45;
                    toReturn.maxZ = 0.735;
                }
            }
            MekanismRenderer.renderObject(toReturn);
            MekanismRenderer.DisplayInteger cfr_ignored_0 = displays[i];
            MekanismRenderer.DisplayInteger.endList();
        }
        return displays;
    }

    public boolean renderFluidInOut(VertexBuffer renderer, EnumFacing side, PartMechanicalPipe pipe) {
        if (pipe != null && pipe.getTransmitter() != null && pipe.getTransmitter().getTransmitterNetwork() != null) {
            this.bindTexture(MekanismRenderer.getBlocksTexture());
            TextureAtlasSprite tex = MekanismRenderer.getFluidTexture(((FluidNetwork)pipe.getTransmitter().getTransmitterNetwork()).refFluid, MekanismRenderer.FluidType.STILL);
            this.renderTransparency(renderer, tex, this.getModelForSide(pipe, side), new ColourRGBA(1.0, 1.0, 1.0, pipe.currentScale));
            return true;
        }
        return false;
    }

    public static void onStitch() {
        cachedLiquids.clear();
    }
}

