/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.ctm;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.MultimapBuilder;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import mekanism.client.render.ctm.CTM;
import mekanism.client.render.ctm.ISubmap;
import mekanism.client.render.ctm.Submap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.util.vector.ReadableVector3f;
import org.lwjgl.util.vector.Vector;
import org.lwjgl.util.vector.Vector2f;
import org.lwjgl.util.vector.Vector3f;

public class Quad {
    public static final ISubmap TOP_LEFT = new Submap(8.0f, 8.0f, 0.0f, 0.0f);
    public static final ISubmap TOP_RIGHT = new Submap(8.0f, 8.0f, 8.0f, 0.0f);
    public static final ISubmap BOTTOM_LEFT = new Submap(8.0f, 8.0f, 0.0f, 8.0f);
    public static final ISubmap BOTTOM_RIGHT = new Submap(8.0f, 8.0f, 8.0f, 8.0f);
    private static final TextureAtlasSprite BASE = Minecraft.func_71410_x().func_147117_R().func_110572_b(TextureMap.field_174945_f.toString());
    private final Vector3f[] vertPos;
    private final Vector2f[] vertUv;
    private UVs uvsObj;
    private final Builder builder;

    private Quad(Vector3f[] verts, Vector2f[] uvs, Builder b) {
        this.vertPos = verts;
        this.vertUv = uvs;
        this.builder = b;
        this.uvsObj = new UVs(uvs);
    }

    private Quad(Vector3f[] verts, UVs uvs, Builder builder) {
        this(verts, uvs.vectorize(), builder);
        this.uvsObj = new UVs(uvs.getSprite(), this.vertUv);
    }

    public UVs getUVs() {
        return this.uvsObj;
    }

    public Quad[] subdivide(int count) {
        ArrayList rects = Lists.newArrayList();
        Pair<Quad, Quad> firstDivide = this.divide(false);
        Pair<Quad, Quad> secondDivide = ((Quad)firstDivide.getLeft()).divide(true);
        rects.add(secondDivide.getLeft());
        if (firstDivide.getRight() != null) {
            Pair<Quad, Quad> thirdDivide = ((Quad)firstDivide.getRight()).divide(true);
            rects.add(thirdDivide.getLeft());
            rects.add(thirdDivide.getRight());
        } else {
            rects.add(null);
            rects.add(null);
        }
        rects.add(secondDivide.getRight());
        return rects.toArray(new Quad[rects.size()]);
    }

    @Nullable
    private Pair<Quad, Quad> divide(boolean vertical) {
        float max;
        float min;
        UVs uvs = this.uvsObj.normalize();
        if (vertical) {
            min = uvs.minV;
            max = uvs.maxV;
        } else {
            min = uvs.minU;
            max = uvs.maxU;
        }
        if ((double)min < 0.5 && (double)max > 0.5) {
            UVs first = new UVs(vertical ? uvs.minU : 0.5f, vertical ? 0.5f : uvs.minV, uvs.maxU, uvs.maxV, uvs.getSprite());
            UVs second = new UVs(uvs.minU, uvs.minV, vertical ? uvs.maxU : 0.5f, vertical ? 0.5f : uvs.maxV, uvs.getSprite());
            int firstIndex = 0;
            for (int i = 0; i < this.vertUv.length; ++i) {
                if (this.vertUv[i].y != this.uvsObj.minV || this.vertUv[i].x != this.uvsObj.minU) continue;
                firstIndex = i;
                break;
            }
            float f = (0.5f - min) / (max - min);
            Vector3f[] firstQuad = new Vector3f[4];
            Vector3f[] secondQuad = new Vector3f[4];
            for (int i = 0; i < 4; ++i) {
                int idx = (firstIndex + i) % 4;
                firstQuad[i] = new Vector3f((ReadableVector3f)this.vertPos[idx]);
                secondQuad[i] = new Vector3f((ReadableVector3f)this.vertPos[idx]);
            }
            int i1 = 0;
            int i2 = vertical ? 1 : 3;
            int j1 = vertical ? 3 : 1;
            int j2 = 2;
            firstQuad[i1].x = Quad.lerp(firstQuad[i1].x, firstQuad[i2].x, f);
            firstQuad[i1].y = Quad.lerp(firstQuad[i1].y, firstQuad[i2].y, f);
            firstQuad[i1].z = Quad.lerp(firstQuad[i1].z, firstQuad[i2].z, f);
            firstQuad[j1].x = Quad.lerp(firstQuad[j1].x, firstQuad[j2].x, f);
            firstQuad[j1].y = Quad.lerp(firstQuad[j1].y, firstQuad[j2].y, f);
            firstQuad[j1].z = Quad.lerp(firstQuad[j1].z, firstQuad[j2].z, f);
            secondQuad[i2].x = Quad.lerp(secondQuad[i1].x, secondQuad[i2].x, f);
            secondQuad[i2].y = Quad.lerp(secondQuad[i1].y, secondQuad[i2].y, f);
            secondQuad[i2].z = Quad.lerp(secondQuad[i1].z, secondQuad[i2].z, f);
            secondQuad[j2].x = Quad.lerp(secondQuad[j1].x, secondQuad[j2].x, f);
            secondQuad[j2].y = Quad.lerp(secondQuad[j1].y, secondQuad[j2].y, f);
            secondQuad[j2].z = Quad.lerp(secondQuad[j1].z, secondQuad[j2].z, f);
            Quad q1 = new Quad(firstQuad, first.relativize(), this.builder);
            Quad q2 = new Quad(secondQuad, second.relativize(), this.builder);
            return Pair.of((Object)q1, (Object)q2);
        }
        return Pair.of((Object)this, null);
    }

    static float lerp(float a, float b, float f) {
        float ret = a * (1.0f - f) + b * f;
        return ret;
    }

    static float normalize(float min, float max, float x) {
        float ret = (x - min) / (max - min);
        return ret;
    }

    public Quad rotate(int amount) {
        int i;
        Vector2f[] uvs = new Vector2f[4];
        TextureAtlasSprite s = this.uvsObj.getSprite();
        for (i = 0; i < 4; ++i) {
            Vector2f uv;
            Vector2f normalized = new Vector2f(Quad.normalize(s.func_94209_e(), s.func_94212_f(), this.vertUv[i].x), Quad.normalize(s.func_94206_g(), s.func_94210_h(), this.vertUv[i].y));
            switch (amount) {
                case 1: {
                    uv = new Vector2f(normalized.y, 1.0f - normalized.x);
                    break;
                }
                case 2: {
                    uv = new Vector2f(1.0f - normalized.x, 1.0f - normalized.y);
                    break;
                }
                case 3: {
                    uv = new Vector2f(1.0f - normalized.y, normalized.x);
                    break;
                }
                default: {
                    uv = new Vector2f(normalized.x, normalized.y);
                }
            }
            uvs[i] = uv;
        }
        for (i = 0; i < uvs.length; ++i) {
            uvs[i] = new Vector2f(Quad.lerp(s.func_94209_e(), s.func_94212_f(), uvs[i].x), Quad.lerp(s.func_94206_g(), s.func_94210_h(), uvs[i].y));
        }
        Quad ret = new Quad(this.vertPos, uvs, this.builder);
        ret.uvsObj = new UVs(this.uvsObj.getSprite(), ret.vertUv);
        return ret;
    }

    public Quad derotate() {
        int start = 0;
        for (int i = 0; i < 4; ++i) {
            if (!(this.vertUv[i].x <= this.uvsObj.minU) || !(this.vertUv[i].y <= this.uvsObj.minV)) continue;
            start = i;
            break;
        }
        Vector2f[] uvs = new Vector2f[4];
        for (int i = 0; i < 4; ++i) {
            uvs[i] = this.vertUv[(i + start) % 4];
        }
        return new Quad(this.vertPos, uvs, this.builder);
    }

    public BakedQuad rebake() {
        UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(this.builder.vertexFormat);
        builder.setQuadOrientation(this.builder.quadOrientation);
        builder.setQuadTint(this.builder.quadTint);
        builder.setApplyDiffuseLighting(this.builder.applyDiffuseLighting);
        builder.setTexture(this.uvsObj.getSprite());
        for (int v = 0; v < 4; ++v) {
            block5: for (int i = 0; i < this.builder.vertexFormat.func_177345_h(); ++i) {
                VertexFormatElement ele = this.builder.vertexFormat.func_177348_c(i);
                switch (ele.func_177375_c()) {
                    case UV: {
                        Vector2f uv = this.vertUv[v];
                        builder.put(i, new float[]{uv.x, uv.y, 0.0f, 1.0f});
                        continue block5;
                    }
                    case POSITION: {
                        Vector3f p = this.vertPos[v];
                        builder.put(i, new float[]{p.x, p.y, p.z, 1.0f});
                        continue block5;
                    }
                    default: {
                        builder.put(i, (float[])this.builder.vertexData.get((Object)ele.func_177375_c()).get(v));
                    }
                }
            }
        }
        return builder.build();
    }

    public Quad transformUVs(TextureAtlasSprite sprite) {
        return this.transformUVs(sprite, CTM.FULL_TEXTURE.normalize());
    }

    public Quad transformUVs(TextureAtlasSprite sprite, ISubmap submap) {
        return new Quad(this.vertPos, this.uvsObj.transform(sprite, submap), this.builder);
    }

    public Quad grow() {
        return new Quad(this.vertPos, this.uvsObj.normalizeQuadrant(), this.builder);
    }

    public static Quad from(BakedQuad baked, VertexFormat fmt) {
        Builder b = new Builder(fmt);
        baked.pipe((IVertexConsumer)b);
        return b.build().derotate();
    }

    public static class Builder
    implements IVertexConsumer {
        private final VertexFormat vertexFormat;
        private int quadTint;
        private EnumFacing quadOrientation;
        private boolean applyDiffuseLighting;
        private ListMultimap<VertexFormatElement.EnumUsage, float[]> vertexData = MultimapBuilder.enumKeys(VertexFormatElement.EnumUsage.class).arrayListValues().build();

        public Builder(VertexFormat fmt) {
            this.vertexFormat = fmt;
        }

        public void setTexture(TextureAtlasSprite sprite) {
        }

        public void setQuadTint(int tint) {
            this.quadTint = tint;
        }

        public void setQuadOrientation(EnumFacing orientation) {
            this.quadOrientation = orientation;
        }

        public VertexFormat getVertexFormat() {
            return this.vertexFormat;
        }

        public void setApplyDiffuseLighting(boolean lighting) {
            this.applyDiffuseLighting = lighting;
        }

        public void put(int element, float ... data) {
            float[] copy = new float[data.length];
            System.arraycopy(data, 0, copy, 0, data.length);
            VertexFormatElement ele = this.vertexFormat.func_177348_c(element);
            this.vertexData.put((Object)ele.func_177375_c(), (Object)copy);
        }

        public Quad build() {
            Vector3f[] verts = (Vector3f[])this.fromData(this.vertexData.get((Object)VertexFormatElement.EnumUsage.POSITION), 3);
            Vector2f[] uvs = (Vector2f[])this.fromData(this.vertexData.get((Object)VertexFormatElement.EnumUsage.UV), 2);
            return new Quad(verts, uvs, this);
        }

        private <T extends Vector> T[] fromData(List<float[]> data, int size) {
            Vector2f[] ret = size == 2 ? new Vector2f[data.size()] : new Vector3f[data.size()];
            for (int i = 0; i < data.size(); ++i) {
                ret[i] = size == 2 ? new Vector2f(data.get(i)[0], data.get(i)[1]) : new Vector3f(data.get(i)[0], data.get(i)[1], data.get(i)[2]);
            }
            return (Vector[])ret;
        }
    }

    public class UVs {
        private float minU;
        private float minV;
        private float maxU;
        private float maxV;
        private final TextureAtlasSprite sprite;
        private final Vector2f[] data;

        private UVs(Vector2f ... data) {
            this(BASE, data);
        }

        private UVs(TextureAtlasSprite sprite, Vector2f ... data) {
            this.data = data;
            this.sprite = sprite;
            float minU = Float.MAX_VALUE;
            float minV = Float.MAX_VALUE;
            float maxU = 0.0f;
            float maxV = 0.0f;
            for (Vector2f v : data) {
                minU = Math.min(minU, v.x);
                minV = Math.min(minV, v.y);
                maxU = Math.max(maxU, v.x);
                maxV = Math.max(maxV, v.y);
            }
            this.minU = minU;
            this.minV = minV;
            this.maxU = maxU;
            this.maxV = maxV;
        }

        public UVs(float minU, float minV, float maxU, float maxV, TextureAtlasSprite sprite) {
            this.minU = minU;
            this.minV = minV;
            this.maxU = maxU;
            this.maxV = maxV;
            this.sprite = sprite;
            this.data = this.vectorize();
        }

        public UVs transform(TextureAtlasSprite other, ISubmap submap) {
            UVs normal = this.normalize();
            submap = submap.normalize();
            float width = normal.maxU - normal.minU;
            float height = normal.maxV - normal.minV;
            float minU = submap.getXOffset();
            float minV = submap.getYOffset();
            float maxU = (minU += normal.minU * submap.getWidth()) + width * submap.getWidth();
            float maxV = (minV += normal.minV * submap.getHeight()) + height * submap.getHeight();
            return new UVs(other, new Vector2f(this.data[0].x == this.minU ? minU : maxU, this.data[0].y == this.minV ? minV : maxV), new Vector2f(this.data[1].x == this.minU ? minU : maxU, this.data[1].y == this.minV ? minV : maxV), new Vector2f(this.data[2].x == this.minU ? minU : maxU, this.data[2].y == this.minV ? minV : maxV), new Vector2f(this.data[3].x == this.minU ? minU : maxU, this.data[3].y == this.minV ? minV : maxV)).relativize();
        }

        public UVs normalizeQuadrant() {
            UVs normal = this.normalize();
            int quadrant = normal.getQuadrant();
            float minUInterp = quadrant == 1 || quadrant == 2 ? 0.5f : 0.0f;
            float minVInterp = quadrant < 2 ? 0.5f : 0.0f;
            float maxUInterp = quadrant == 0 || quadrant == 3 ? 0.5f : 1.0f;
            float maxVInterp = quadrant > 1 ? 0.5f : 1.0f;
            normal = new UVs(this.sprite, this.normalize(new Vector2f(minUInterp, minVInterp), new Vector2f(maxUInterp, maxVInterp), normal.vectorize()));
            return normal.relativize();
        }

        public UVs normalize() {
            Vector2f min = new Vector2f(this.sprite.func_94209_e(), this.sprite.func_94206_g());
            Vector2f max = new Vector2f(this.sprite.func_94212_f(), this.sprite.func_94210_h());
            return new UVs(this.sprite, this.normalize(min, max, this.data));
        }

        public UVs relativize() {
            return this.relativize(this.sprite);
        }

        public TextureAtlasSprite getSprite() {
            return this.sprite;
        }

        public UVs relativize(TextureAtlasSprite sprite) {
            Vector2f min = new Vector2f(sprite.func_94209_e(), sprite.func_94206_g());
            Vector2f max = new Vector2f(sprite.func_94212_f(), sprite.func_94210_h());
            return new UVs(sprite, this.lerp(min, max, this.data));
        }

        public Vector2f[] vectorize() {
            Vector2f[] vector2fArray;
            if (this.data == null) {
                Vector2f[] vector2fArray2 = new Vector2f[4];
                vector2fArray2[0] = new Vector2f(this.minU, this.minV);
                vector2fArray2[1] = new Vector2f(this.minU, this.maxV);
                vector2fArray2[2] = new Vector2f(this.maxU, this.maxV);
                vector2fArray = vector2fArray2;
                vector2fArray2[3] = new Vector2f(this.maxU, this.minV);
            } else {
                vector2fArray = this.data;
            }
            return vector2fArray;
        }

        private Vector2f[] normalize(Vector2f min, Vector2f max, Vector2f ... vecs) {
            Vector2f[] ret = new Vector2f[vecs.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = this.normalize(min, max, vecs[i]);
            }
            return ret;
        }

        private Vector2f normalize(Vector2f min, Vector2f max, Vector2f vec) {
            return new Vector2f(Quad.normalize(min.x, max.x, vec.x), Quad.normalize(min.y, max.y, vec.y));
        }

        private Vector2f[] lerp(Vector2f min, Vector2f max, Vector2f ... vecs) {
            Vector2f[] ret = new Vector2f[vecs.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = this.lerp(min, max, vecs[i]);
            }
            return ret;
        }

        private Vector2f lerp(Vector2f min, Vector2f max, Vector2f vec) {
            return new Vector2f(Quad.lerp(min.x, max.x, vec.x), Quad.lerp(min.y, max.y, vec.y));
        }

        public int getQuadrant() {
            if (this.maxU <= 0.5f) {
                if (this.maxV <= 0.5f) {
                    return 3;
                }
                return 0;
            }
            if (this.maxV <= 0.5f) {
                return 2;
            }
            return 1;
        }
    }

    public static class Vertex {
        Vector3f pos;
        Vector2f uvs;
    }
}

