/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.ctm;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;
import mekanism.client.render.ctm.CTM;
import mekanism.client.render.ctm.CTMBlockRenderContext;
import mekanism.client.render.ctm.CTMData;
import mekanism.client.render.ctm.CTMRegistry;
import mekanism.client.render.ctm.ICTMBlock;
import mekanism.client.render.ctm.ModelCTM;
import mekanism.client.render.ctm.TextureCTM;
import mekanism.common.block.states.BlockStateBasic;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import org.apache.commons.lang3.tuple.Pair;

public class CTMModelFactory
implements IPerspectiveAwareModel {
    private ListMultimap<BlockRenderLayer, BakedQuad> genQuads = MultimapBuilder.enumKeys(BlockRenderLayer.class).arrayListValues().build();
    private Table<BlockRenderLayer, EnumFacing, List<BakedQuad>> faceQuads = Tables.newCustomTable((Map)Maps.newEnumMap(BlockRenderLayer.class), () -> Maps.newEnumMap(EnumFacing.class));
    private ModelCTM model;
    private CTMOverride override = new CTMOverride();
    private static Cache<Integer, CTMModelFactory> ctmCache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).maximumSize(500L).build();
    public static Map<ItemCameraTransforms.TransformType, TRSRTransformation> transforms = ImmutableMap.builder().put((Object)ItemCameraTransforms.TransformType.GUI, (Object)CTMModelFactory.get(0.0f, 0.0f, 0.0f, 30.0f, 225.0f, 0.0f, 0.625f)).put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, (Object)CTMModelFactory.get(0.0f, 2.5f, 0.0f, 75.0f, 45.0f, 0.0f, 0.375f)).put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, (Object)CTMModelFactory.get(0.0f, 2.5f, 0.0f, 75.0f, 45.0f, 0.0f, 0.375f)).put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, (Object)CTMModelFactory.get(0.0f, 0.0f, 0.0f, 0.0f, 45.0f, 0.0f, 0.4f)).put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, (Object)CTMModelFactory.get(0.0f, 0.0f, 0.0f, 0.0f, 225.0f, 0.0f, 0.4f)).put((Object)ItemCameraTransforms.TransformType.GROUND, (Object)CTMModelFactory.get(0.0f, 2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.25f)).put((Object)ItemCameraTransforms.TransformType.HEAD, (Object)CTMModelFactory.get(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f)).put((Object)ItemCameraTransforms.TransformType.FIXED, (Object)CTMModelFactory.get(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f)).put((Object)ItemCameraTransforms.TransformType.NONE, (Object)CTMModelFactory.get(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f)).build();

    public CTMModelFactory(ModelCTM m) {
        this.model = m;
    }

    public List<BakedQuad> func_188616_a(IBlockState stateIn, EnumFacing side, long rand) {
        CTMModelFactory baked;
        if (stateIn != null && stateIn.func_177230_c() instanceof ICTMBlock && stateIn instanceof IExtendedBlockState) {
            IExtendedBlockState state = (IExtendedBlockState)stateIn;
            IBlockState clean = state.getClean();
            CTMBlockRenderContext ctxList = (CTMBlockRenderContext)state.getValue((IUnlistedProperty)BlockStateBasic.ctmProperty);
            try {
                if (ctxList == null) {
                    baked = (CTMModelFactory)ctmCache.get((Object)Objects.hash(clean, -1), () -> this.createModel((IBlockState)state, this.model, null));
                }
                long serialized = ctxList.serialize();
                baked = (CTMModelFactory)ctmCache.get((Object)Objects.hash(clean, serialized), () -> this.createModel((IBlockState)state, this.model, ctxList));
            }
            catch (Exception e) {
                e.printStackTrace();
                return Lists.newArrayList();
            }
        } else {
            baked = this;
        }
        BlockRenderLayer layer = MinecraftForgeClient.getRenderLayer();
        return side == null ? baked.genQuads.get((Object)layer) : (layer == null ? baked.faceQuads.column((Object)side).values().stream().flatMap(Collection::stream).collect(Collectors.toList()) : (List)baked.faceQuads.get((Object)layer, (Object)side));
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return true;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.model.getDefaultFace().getParticle();
    }

    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    private CTMModelFactory createModel(IBlockState state, ModelCTM model, CTMBlockRenderContext ctx) {
        CTMModelFactory ret = new CTMModelFactory(model);
        IBakedModel baked = model.getModel(state);
        int quadGoal = ctx == null ? 1 : CTM.QUADS_PER_SIDE;
        ArrayList quads = Lists.newArrayList();
        for (BlockRenderLayer layer : BlockRenderLayer.values()) {
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                TextureCTM face = model.getFace(facing);
                if (ctx == null || layer == state.func_177230_c().func_180664_k()) {
                    ICTMBlock block = (ICTMBlock)state.func_177230_c();
                    CTMData data = block.getCTMData(state);
                    if (block.getOverrideTexture(state, facing) != null) {
                        face = CTMRegistry.textureCache.get(block.getOverrideTexture(state, facing));
                    }
                    List temp = baked.func_188616_a(state, facing, 0L);
                    this.addAllQuads(temp, face, ctx, state, quadGoal, quads);
                    ret.faceQuads.put((Object)layer, (Object)facing, (Object)ImmutableList.copyOf((Collection)quads));
                    temp = FluentIterable.from((Iterable)baked.func_188616_a(state, null, 0L)).filter(q -> q.func_178210_d() == facing).toList();
                    this.addAllQuads(temp, face, ctx, state, quadGoal, quads);
                    ret.genQuads.putAll((Object)layer, (Iterable)temp);
                    continue;
                }
                ret.faceQuads.put((Object)layer, (Object)facing, (Object)Lists.newArrayList());
            }
        }
        return ret;
    }

    private void addAllQuads(List<BakedQuad> from, TextureCTM tex, @Nullable CTMBlockRenderContext ctx, IBlockState state, int quadGoal, List<BakedQuad> to) {
        to.clear();
        for (BakedQuad q : from) {
            to.addAll(tex.transformQuad(q, ctx == null ? null : ctx, quadGoal));
        }
    }

    private static TRSRTransformation get(float tx, float ty, float tz, float ax, float ay, float az, float s) {
        return new TRSRTransformation(new Vector3f(tx / 16.0f, ty / 16.0f, tz / 16.0f), TRSRTransformation.quatFromXYZDegrees((Vector3f)new Vector3f(ax, ay, az)), new Vector3f(s, s, s), null);
    }

    public Pair<? extends IPerspectiveAwareModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        return Pair.of((Object)this, (Object)transforms.get(cameraTransformType).getMatrix());
    }

    public ItemOverrideList func_188617_f() {
        return this.override;
    }

    private class CTMOverride
    extends ItemOverrideList {
        public CTMOverride() {
            super((List)Lists.newArrayList());
        }

        public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
            Block block = ((ItemBlock)stack.func_77973_b()).func_179223_d();
            return CTMModelFactory.this.createModel(block.func_176223_P(), CTMModelFactory.this.model, null);
        }
    }
}

