/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.jei.machine.other;

import java.util.List;
import mekanism.client.jei.BaseRecipeCategory;
import mekanism.client.jei.machine.other.ThermalEvaporationRecipeWrapper;
import mekanism.common.recipe.inputs.FluidInput;
import mekanism.common.recipe.machines.ThermalEvaporationRecipe;
import mekanism.common.recipe.outputs.FluidOutput;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ITickTimer;
import mezz.jei.api.gui.ITooltipCallback;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class ThermalEvaporationRecipeCategory
extends BaseRecipeCategory {
    public IGuiHelper guiHelper;
    public IDrawable background;
    public IDrawable fluidOverlay;
    public ThermalEvaporationRecipe tempRecipe;
    public ITickTimer timer;

    public ThermalEvaporationRecipeCategory(IGuiHelper helper) {
        super("mekanism:gui/nei/GuiThermalEvaporationController.png", "thermal_evaporation_plant", "gui.thermalEvaporationController.short", null);
        this.guiHelper = helper;
        this.timer = helper.createTickTimer(20, 20, false);
        this.xOffset = 3;
        this.yOffset = 12;
        this.background = this.guiHelper.createDrawable(new ResourceLocation(this.guiTexture), this.xOffset, this.yOffset, 170, 62);
        this.fluidOverlay = this.guiHelper.createDrawable(new ResourceLocation(this.guiTexture), 176, 0, 16, 59);
    }

    @Override
    public void drawExtras(Minecraft minecraft) {
        super.drawExtras(minecraft);
        this.drawTexturedRect(49 - this.xOffset, 64 - this.yOffset, 176, 59, 78, 8);
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(IRecipeLayout recipeLayout, IRecipeWrapper recipeWrapper, IIngredients ingredients) {
        if (recipeWrapper instanceof ThermalEvaporationRecipeWrapper) {
            this.tempRecipe = ((ThermalEvaporationRecipeWrapper)recipeWrapper).recipe;
        }
        IGuiFluidStackGroup fluidStacks = recipeLayout.getFluidStacks();
        fluidStacks.init(0, true, 7 - this.xOffset, 14 - this.yOffset, 16, 58, ((FluidInput)this.tempRecipe.getInput()).ingredient.amount, false, this.fluidOverlay);
        fluidStacks.init(1, false, 153 - this.xOffset, 14 - this.yOffset, 16, 58, ((FluidOutput)this.tempRecipe.getOutput()).output.amount, false, this.fluidOverlay);
        fluidStacks.set(0, ((FluidInput)this.tempRecipe.recipeInput).ingredient);
        fluidStacks.set(1, ((FluidOutput)this.tempRecipe.recipeOutput).output);
        fluidStacks.addTooltipCallback((ITooltipCallback)new ITooltipCallback<FluidStack>(){

            public void onTooltip(int slotIndex, boolean input, FluidStack ingredient, List<String> tooltip) {
                tooltip.remove(1);
            }
        });
    }
}

