/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.jei.machine.other;

import java.util.List;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiFluidGauge;
import mekanism.client.gui.element.GuiGasGauge;
import mekanism.client.gui.element.GuiGauge;
import mekanism.client.gui.element.GuiPowerBar;
import mekanism.client.gui.element.GuiProgress;
import mekanism.client.gui.element.GuiSlot;
import mekanism.client.jei.BaseRecipeCategory;
import mekanism.client.jei.machine.other.PRCRecipeWrapper;
import mekanism.common.recipe.inputs.PressurizedInput;
import mekanism.common.recipe.machines.PressurizedRecipe;
import mekanism.common.recipe.outputs.PressurizedOutput;
import mekanism.common.util.MekanismUtils;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ITickTimer;
import mezz.jei.api.gui.ITooltipCallback;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class PRCRecipeCategory
extends BaseRecipeCategory {
    public IGuiHelper guiHelper;
    public IDrawable background;
    public IDrawable fluidOverlay;
    public GuiGasGauge gasInput;
    public GuiGasGauge gasOutput;
    public PressurizedRecipe tempRecipe;
    public ITickTimer timer;

    public PRCRecipeCategory(IGuiHelper helper) {
        super("mekanism:gui/nei/GuiPRC.png", "pressurized_reaction_chamber", "tile.MachineBlock2.PressurizedReactionChamber.short.name", GuiProgress.ProgressBar.MEDIUM);
        this.guiHelper = helper;
        this.timer = helper.createTickTimer(20, 20, false);
        this.xOffset = 3;
        this.yOffset = 11;
        this.background = this.guiHelper.createDrawable(new ResourceLocation(this.guiTexture), this.xOffset, this.yOffset, 170, 68);
        this.fluidOverlay = this.guiHelper.createDrawable(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_ELEMENT, GuiGauge.Type.STANDARD.textureLocation), 19, 1, 16, 59);
    }

    @Override
    public void addGuiElements() {
        this.guiElements.add(new GuiSlot(GuiSlot.SlotType.INPUT, this, this.guiLocation, 53, 34));
        this.guiElements.add(new GuiSlot(GuiSlot.SlotType.POWER, this, this.guiLocation, 140, 18).with(GuiSlot.SlotOverlay.POWER));
        this.guiElements.add(new GuiSlot(GuiSlot.SlotType.OUTPUT, this, this.guiLocation, 115, 34));
        this.guiElements.add(GuiFluidGauge.getDummy(GuiGauge.Type.STANDARD_YELLOW, this, this.guiLocation, 5, 10));
        this.gasInput = GuiGasGauge.getDummy(GuiGauge.Type.STANDARD_RED, this, this.guiLocation, 28, 10);
        this.guiElements.add(this.gasInput);
        this.gasOutput = GuiGasGauge.getDummy(GuiGauge.Type.SMALL_BLUE, this, this.guiLocation, 140, 40);
        this.guiElements.add(this.gasOutput);
        this.guiElements.add(new GuiPowerBar((IGuiWrapper)this, new GuiPowerBar.IPowerInfoHandler(){

            @Override
            public double getLevel() {
                return 1.0;
            }
        }, this.guiLocation, 164, 15));
        this.guiElements.add(new GuiProgress(new GuiProgress.IProgressInfoHandler(){

            @Override
            public double getProgress() {
                return (float)PRCRecipeCategory.this.timer.getValue() / 20.0f;
            }
        }, this.progressBar, this, this.guiLocation, 75, 37));
    }

    @Override
    public void drawExtras(Minecraft minecraft) {
        super.drawExtras(minecraft);
        if (((PressurizedInput)this.tempRecipe.getInput()).getGas() != null) {
            this.gasInput.setDummyType(((PressurizedInput)this.tempRecipe.getInput()).getGas().getGas());
            this.gasInput.renderScale(0, 0, -this.xOffset, -this.yOffset);
        }
        if (((PressurizedOutput)this.tempRecipe.getOutput()).getGasOutput() != null) {
            this.gasOutput.setDummyType(((PressurizedOutput)this.tempRecipe.getOutput()).getGasOutput().getGas());
            this.gasOutput.renderScale(0, 0, -this.xOffset, -this.yOffset);
        }
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(IRecipeLayout recipeLayout, IRecipeWrapper recipeWrapper, IIngredients ingredients) {
        if (recipeWrapper instanceof PRCRecipeWrapper) {
            this.tempRecipe = ((PRCRecipeWrapper)recipeWrapper).recipe;
        }
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        itemStacks.init(0, true, 53 - this.xOffset, 34 - this.yOffset);
        itemStacks.init(1, false, 115 - this.xOffset, 34 - this.yOffset);
        itemStacks.set(0, ((PressurizedInput)this.tempRecipe.recipeInput).getSolid());
        itemStacks.set(1, ((PressurizedOutput)this.tempRecipe.recipeOutput).getItemOutput());
        IGuiFluidStackGroup fluidStacks = recipeLayout.getFluidStacks();
        fluidStacks.init(0, true, 3, 0, 16, 58, ((PressurizedInput)this.tempRecipe.getInput()).getFluid().amount, false, this.fluidOverlay);
        fluidStacks.set(0, ((PressurizedInput)this.tempRecipe.recipeInput).getFluid());
        fluidStacks.addTooltipCallback((ITooltipCallback)new ITooltipCallback<FluidStack>(){

            public void onTooltip(int slotIndex, boolean input, FluidStack ingredient, List<String> tooltip) {
                tooltip.remove(1);
            }
        });
    }
}

