/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.jei.machine.chemical;

import mekanism.client.gui.element.GuiGasGauge;
import mekanism.client.gui.element.GuiGauge;
import mekanism.client.gui.element.GuiProgress;
import mekanism.client.gui.element.GuiSlot;
import mekanism.client.jei.BaseRecipeCategory;
import mekanism.client.jei.machine.chemical.ChemicalOxidizerRecipeWrapper;
import mekanism.common.recipe.inputs.ItemStackInput;
import mekanism.common.recipe.machines.OxidationRecipe;
import mekanism.common.recipe.outputs.GasOutput;
import mekanism.common.util.MekanismUtils;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ITickTimer;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;

public class ChemicalOxidizerRecipeCategory
extends BaseRecipeCategory {
    public IGuiHelper guiHelper;
    public IDrawable background;
    public OxidationRecipe tempRecipe;
    public GuiGasGauge gasOutput;
    public ITickTimer timer;

    public ChemicalOxidizerRecipeCategory(IGuiHelper helper) {
        super("mekanism:gui/GuiChemicalOxidizer.png", "chemical_oxidizer", "tile.MachineBlock2.ChemicalOxidizer.name", GuiProgress.ProgressBar.LARGE_RIGHT);
        this.guiHelper = helper;
        this.timer = helper.createTickTimer(20, 20, false);
        this.xOffset = 20;
        this.yOffset = 12;
        this.background = this.guiHelper.createDrawable(new ResourceLocation(this.guiTexture), this.xOffset, this.yOffset, 132, 62);
    }

    @Override
    public void addGuiElements() {
        this.gasOutput = GuiGasGauge.getDummy(GuiGauge.Type.STANDARD, this, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiChemicalOxidizer.png"), 133, 13);
        this.guiElements.add(this.gasOutput);
        this.guiElements.add(new GuiSlot(GuiSlot.SlotType.NORMAL, this, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiChemicalOxidizer.png"), 25, 35));
        this.guiElements.add(new GuiProgress(new GuiProgress.IProgressInfoHandler(){

            @Override
            public double getProgress() {
                return (double)ChemicalOxidizerRecipeCategory.this.timer.getValue() / 20.0;
            }
        }, this.progressBar, this, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiChemicalOxidizer.png"), 62, 39));
    }

    @Override
    public void drawExtras(Minecraft minecraft) {
        super.drawExtras(minecraft);
        if (((GasOutput)this.tempRecipe.getOutput()).output != null) {
            this.gasOutput.setDummyType(((GasOutput)this.tempRecipe.getOutput()).output.getGas());
            this.gasOutput.renderScale(0, 0, -this.xOffset, -this.yOffset);
        }
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(IRecipeLayout recipeLayout, IRecipeWrapper recipeWrapper, IIngredients ingredients) {
        if (recipeWrapper instanceof ChemicalOxidizerRecipeWrapper) {
            this.tempRecipe = ((ChemicalOxidizerRecipeWrapper)recipeWrapper).recipe;
        }
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        itemStacks.init(0, true, 25 - this.xOffset, 35 - this.yOffset);
        itemStacks.set(0, ((ItemStackInput)this.tempRecipe.getInput()).ingredient);
    }
}

