/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import java.util.List;
import mekanism.client.gui.GuiMekanism;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiBoilerTab;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.GuiHeatInfo;
import mekanism.client.gui.element.GuiRateBar;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.boiler.SynchronizedBoilerData;
import mekanism.common.inventory.container.ContainerFilter;
import mekanism.common.tile.TileEntityBoilerCasing;
import mekanism.common.util.LangUtils;
import mekanism.common.util.ListUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.UnitDisplayUtils;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiThermoelectricBoiler
extends GuiMekanism {
    public TileEntityBoilerCasing tileEntity;

    public GuiThermoelectricBoiler(InventoryPlayer inventory, TileEntityBoilerCasing tentity) {
        super(tentity, new ContainerFilter(inventory, tentity));
        this.tileEntity = tentity;
        this.guiElements.add(new GuiBoilerTab(this, this.tileEntity, GuiBoilerTab.BoilerTab.STAT, 6, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiThermoelectricBoiler.png")));
        this.guiElements.add(new GuiRateBar(this, new GuiRateBar.IRateInfoHandler(){

            @Override
            public String getTooltip() {
                return LangUtils.localize("gui.boilRate") + ": " + ((SynchronizedBoilerData)GuiThermoelectricBoiler.this.tileEntity.structure).lastBoilRate + " mB/t";
            }

            @Override
            public double getLevel() {
                return (double)((SynchronizedBoilerData)GuiThermoelectricBoiler.this.tileEntity.structure).lastBoilRate / (double)((SynchronizedBoilerData)GuiThermoelectricBoiler.this.tileEntity.structure).lastMaxBoil;
            }
        }, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiThermoelectricBoiler.png"), 24, 13));
        this.guiElements.add(new GuiRateBar(this, new GuiRateBar.IRateInfoHandler(){

            @Override
            public String getTooltip() {
                return LangUtils.localize("gui.maxBoil") + ": " + ((SynchronizedBoilerData)GuiThermoelectricBoiler.this.tileEntity.structure).lastMaxBoil + " mB/t";
            }

            @Override
            public double getLevel() {
                double cap = (double)((SynchronizedBoilerData)GuiThermoelectricBoiler.this.tileEntity.structure).superheatingElements * MekanismConfig.general.superheatingHeatTransfer / SynchronizedBoilerData.getHeatEnthalpy();
                return (double)((SynchronizedBoilerData)GuiThermoelectricBoiler.this.tileEntity.structure).lastMaxBoil / cap;
            }
        }, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiThermoelectricBoiler.png"), 144, 13));
        this.guiElements.add(new GuiHeatInfo(new GuiElement.IInfoHandler(){

            @Override
            public List<String> getInfo() {
                UnitDisplayUtils.TemperatureUnit unit = UnitDisplayUtils.TemperatureUnit.values()[MekanismConfig.general.tempUnit.ordinal()];
                String environment = UnitDisplayUtils.getDisplayShort(((SynchronizedBoilerData)GuiThermoelectricBoiler.this.tileEntity.structure).lastEnvironmentLoss * unit.intervalSize, false, unit);
                return ListUtils.asList(LangUtils.localize("gui.dissipated") + ": " + environment + "/t");
            }
        }, (IGuiWrapper)this, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiThermoelectricBoiler.png")));
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        int xAxis = mouseX - (this.field_146294_l - this.field_146999_f) / 2;
        int yAxis = mouseY - (this.field_146295_m - this.field_147000_g) / 2;
        this.field_146289_q.func_78276_b(LangUtils.localize("container.inventory"), 8, this.field_147000_g - 96 + 4, 0x404040);
        this.field_146289_q.func_78276_b(this.tileEntity.func_70005_c_(), this.field_146999_f / 2 - this.field_146289_q.func_78256_a(this.tileEntity.func_70005_c_()) / 2, 5, 0x404040);
        this.renderScaledText(LangUtils.localize("gui.temp") + ": " + MekanismUtils.getTemperatureDisplay(((SynchronizedBoilerData)this.tileEntity.structure).temperature, UnitDisplayUtils.TemperatureUnit.AMBIENT), 43, 30, 52480, 90);
        this.renderScaledText(LangUtils.localize("gui.boilRate") + ": " + ((SynchronizedBoilerData)this.tileEntity.structure).lastBoilRate + " mB/t", 43, 39, 52480, 90);
        this.renderScaledText(LangUtils.localize("gui.maxBoil") + ": " + ((SynchronizedBoilerData)this.tileEntity.structure).lastMaxBoil + " mB/t", 43, 48, 52480, 90);
        if (xAxis >= 7 && xAxis <= 23 && yAxis >= 14 && yAxis <= 72) {
            this.func_146279_a(((SynchronizedBoilerData)this.tileEntity.structure).waterStored != null ? LangUtils.localizeFluidStack(((SynchronizedBoilerData)this.tileEntity.structure).waterStored) + ": " + ((SynchronizedBoilerData)this.tileEntity.structure).waterStored.amount + "mB" : LangUtils.localize("gui.empty"), xAxis, yAxis);
        }
        if (xAxis >= 153 && xAxis <= 169 && yAxis >= 14 && yAxis <= 72) {
            this.func_146279_a(((SynchronizedBoilerData)this.tileEntity.structure).steamStored != null ? LangUtils.localizeFluidStack(((SynchronizedBoilerData)this.tileEntity.structure).steamStored) + ": " + ((SynchronizedBoilerData)this.tileEntity.structure).steamStored.amount + "mB" : LangUtils.localize("gui.empty"), xAxis, yAxis);
        }
        super.func_146979_b(mouseX, mouseY);
    }

    @Override
    protected void func_146976_a(float partialTick, int mouseX, int mouseY) {
        this.field_146297_k.field_71446_o.func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiThermoelectricBoiler.png"));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int guiWidth = (this.field_146294_l - this.field_146999_f) / 2;
        int guiHeight = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(guiWidth, guiHeight, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.tileEntity.getScaledWaterLevel(58) > 0) {
            this.displayGauge(7, 14, this.tileEntity.getScaledWaterLevel(58), ((SynchronizedBoilerData)this.tileEntity.structure).waterStored);
        }
        if (this.tileEntity.getScaledSteamLevel(58) > 0) {
            this.displayGauge(153, 14, this.tileEntity.getScaledSteamLevel(58), ((SynchronizedBoilerData)this.tileEntity.structure).steamStored);
        }
        super.func_146976_a(partialTick, mouseX, mouseY);
    }

    public void displayGauge(int xPos, int yPos, int scale, FluidStack fluid) {
        int renderRemaining;
        if (fluid == null) {
            return;
        }
        int guiWidth = (this.field_146294_l - this.field_146999_f) / 2;
        int guiHeight = (this.field_146295_m - this.field_147000_g) / 2;
        int start = 0;
        do {
            renderRemaining = 0;
            if (scale > 16) {
                renderRemaining = 16;
                scale -= 16;
            } else {
                renderRemaining = scale;
                scale = 0;
            }
            this.field_146297_k.field_71446_o.func_110577_a(MekanismRenderer.getBlocksTexture());
            this.func_175175_a(guiWidth + xPos, guiHeight + yPos + 58 - renderRemaining - start, MekanismRenderer.getFluidTexture(fluid.getFluid(), MekanismRenderer.FluidType.STILL), 16, 16 - (16 - renderRemaining));
            start += 16;
        } while (renderRemaining != 0 && scale != 0);
        this.field_146297_k.field_71446_o.func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiIndustrialTurbine.png"));
        this.func_73729_b(guiWidth + xPos, guiHeight + yPos, 176, 0, 16, 54);
    }
}

