/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import java.io.IOException;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.client.gui.GuiMekanism;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.sound.SoundHandler;
import mekanism.common.Mekanism;
import mekanism.common.MekanismSounds;
import mekanism.common.content.transporter.TItemStackFilter;
import mekanism.common.inventory.container.ContainerFilter;
import mekanism.common.network.PacketEditFilter;
import mekanism.common.network.PacketLogisticalSorterGui;
import mekanism.common.network.PacketNewFilter;
import mekanism.common.tile.TileEntityLogisticalSorter;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.TransporterUtils;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiTItemStackFilter
extends GuiMekanism {
    public TileEntityLogisticalSorter tileEntity;
    public boolean isNew = false;
    public TItemStackFilter origFilter;
    public TItemStackFilter filter = new TItemStackFilter();
    public String status = (Object)((Object)EnumColor.DARK_GREEN) + LangUtils.localize("gui.allOK");
    public int ticker;
    private GuiTextField minField;
    private GuiTextField maxField;

    public GuiTItemStackFilter(EntityPlayer player, TileEntityLogisticalSorter tentity, int index) {
        super(tentity, new ContainerFilter(player.field_71071_by, tentity));
        this.tileEntity = tentity;
        this.origFilter = (TItemStackFilter)this.tileEntity.filters.get(index);
        this.filter = ((TItemStackFilter)this.tileEntity.filters.get(index)).clone();
    }

    public GuiTItemStackFilter(EntityPlayer player, TileEntityLogisticalSorter tentity) {
        super(tentity, new ContainerFilter(player.field_71071_by, tentity));
        this.tileEntity = tentity;
        this.isNew = true;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int guiWidth = (this.field_146294_l - this.field_146999_f) / 2;
        int guiHeight = (this.field_146295_m - this.field_147000_g) / 2;
        this.field_146292_n.clear();
        this.field_146292_n.add(new GuiButton(0, guiWidth + 47, guiHeight + 62, 60, 20, LangUtils.localize("gui.save")));
        this.field_146292_n.add(new GuiButton(1, guiWidth + 109, guiHeight + 62, 60, 20, LangUtils.localize("gui.delete")));
        if (this.isNew) {
            ((GuiButton)this.field_146292_n.get((int)1)).field_146124_l = false;
        }
        this.minField = new GuiTextField(2, this.field_146289_q, guiWidth + 149, guiHeight + 19, 20, 11);
        this.minField.func_146203_f(2);
        this.minField.func_146180_a("" + this.filter.min);
        this.maxField = new GuiTextField(3, this.field_146289_q, guiWidth + 149, guiHeight + 31, 20, 11);
        this.maxField.func_146203_f(2);
        this.maxField.func_146180_a("" + this.filter.max);
    }

    protected void func_146284_a(GuiButton guibutton) throws IOException {
        super.func_146284_a(guibutton);
        if (guibutton.field_146127_k == 0) {
            if (this.filter.itemType != null && !this.minField.func_146179_b().isEmpty() && !this.maxField.func_146179_b().isEmpty()) {
                int min = Integer.parseInt(this.minField.func_146179_b());
                int max = Integer.parseInt(this.maxField.func_146179_b());
                if (max >= min && max <= 64 && min <= 64) {
                    this.filter.min = Integer.parseInt(this.minField.func_146179_b());
                    this.filter.max = Integer.parseInt(this.maxField.func_146179_b());
                    if (this.isNew) {
                        Mekanism.packetHandler.sendToServer(new PacketNewFilter.NewFilterMessage(Coord4D.get(this.tileEntity), this.filter));
                    } else {
                        Mekanism.packetHandler.sendToServer(new PacketEditFilter.EditFilterMessage(Coord4D.get(this.tileEntity), false, this.origFilter, this.filter));
                    }
                    Mekanism.packetHandler.sendToServer(new PacketLogisticalSorterGui.LogisticalSorterGuiMessage(PacketLogisticalSorterGui.SorterGuiPacket.SERVER, Coord4D.get(this.tileEntity), 0, 0, 0));
                } else if (min > max) {
                    this.status = (Object)((Object)EnumColor.DARK_RED) + "Max<min";
                    this.ticker = 20;
                } else if (max > 64 || min > 64) {
                    this.status = (Object)((Object)EnumColor.DARK_RED) + "Max>64";
                    this.ticker = 20;
                }
            } else if (this.filter.itemType == null) {
                this.status = (Object)((Object)EnumColor.DARK_RED) + "No item";
                this.ticker = 20;
            } else if (this.minField.func_146179_b().isEmpty() || this.maxField.func_146179_b().isEmpty()) {
                this.status = (Object)((Object)EnumColor.DARK_RED) + "Max/min";
                this.ticker = 20;
            }
        } else if (guibutton.field_146127_k == 1) {
            Mekanism.packetHandler.sendToServer(new PacketEditFilter.EditFilterMessage(Coord4D.get(this.tileEntity), true, this.origFilter, null));
            Mekanism.packetHandler.sendToServer(new PacketLogisticalSorterGui.LogisticalSorterGuiMessage(PacketLogisticalSorterGui.SorterGuiPacket.SERVER, Coord4D.get(this.tileEntity), 0, 0, 0));
        }
    }

    public void func_73869_a(char c, int i) throws IOException {
        if (!this.minField.func_146206_l() && !this.maxField.func_146206_l() || i == 1) {
            super.func_73869_a(c, i);
        }
        if (Character.isDigit(c) || GuiTItemStackFilter.isTextboxKey(c, i)) {
            this.minField.func_146201_a(c, i);
            this.maxField.func_146201_a(c, i);
        }
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        int xAxis = mouseX - (this.field_146294_l - this.field_146999_f) / 2;
        int yAxis = mouseY - (this.field_146295_m - this.field_147000_g) / 2;
        this.field_146289_q.func_78276_b((this.isNew ? LangUtils.localize("gui.new") : LangUtils.localize("gui.edit")) + " " + LangUtils.localize("gui.itemFilter"), 43, 6, 0x404040);
        this.field_146289_q.func_78276_b(LangUtils.localize("gui.status") + ": " + this.status, 35, 20, 52480);
        this.field_146289_q.func_78276_b(LangUtils.localize("gui.itemFilter.details") + ":", 35, 32, 52480);
        this.field_146289_q.func_78276_b(LangUtils.localize("gui.itemFilter.min") + ":", 128, 20, 0x404040);
        this.field_146289_q.func_78276_b(LangUtils.localize("gui.itemFilter.max") + ":", 128, 32, 0x404040);
        this.field_146289_q.func_78276_b(LangUtils.localize("gui." + (this.filter.sizeMode ? "on" : "off")), 141, 46, 0x404040);
        this.field_146289_q.func_78276_b(LangUtils.localize("gui." + (this.filter.allowDefault ? "on" : "off")), 24, 66, 0x404040);
        if (this.filter.itemType != null) {
            this.renderScaledText(this.filter.itemType.func_82833_r(), 35, 41, 52480, 89);
        }
        if (this.filter.itemType != null) {
            GlStateManager.func_179094_E();
            RenderHelper.func_74520_c();
            this.field_146296_j.func_180450_b(this.filter.itemType, 12, 19);
            RenderHelper.func_74518_a();
            GlStateManager.func_179121_F();
        }
        if (this.filter.color != null) {
            GlStateManager.func_179094_E();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glEnable((int)2896);
            GL11.glEnable((int)32826);
            this.field_146297_k.func_110434_K().func_110577_a(MekanismRenderer.getBlocksTexture());
            this.drawTexturedRectFromIcon(12, 44, MekanismRenderer.getColorIcon(this.filter.color), 16, 16);
            GL11.glDisable((int)2896);
            GlStateManager.func_179121_F();
        }
        if (xAxis >= 128 && xAxis <= 139 && yAxis >= 44 && yAxis <= 55) {
            this.func_146279_a(LangUtils.localize("gui.sizeMode"), xAxis, yAxis);
        }
        if (xAxis >= 11 && xAxis <= 22 && yAxis >= 64 && yAxis <= 75) {
            this.func_146279_a(LangUtils.localize("gui.allowDefault"), xAxis, yAxis);
        }
        if (xAxis >= 12 && xAxis <= 28 && yAxis >= 44 && yAxis <= 60) {
            if (this.filter.color != null) {
                this.func_146279_a(this.filter.color.getColoredName(), xAxis, yAxis);
            } else {
                this.func_146279_a(LangUtils.localize("gui.none"), xAxis, yAxis);
            }
        }
        super.func_146979_b(mouseX, mouseY);
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.minField.func_146178_a();
        this.maxField.func_146178_a();
        if (this.ticker > 0) {
            --this.ticker;
        } else {
            this.status = (Object)((Object)EnumColor.DARK_GREEN) + LangUtils.localize("gui.allOK");
        }
    }

    @Override
    protected void func_146976_a(float partialTick, int mouseX, int mouseY) {
        this.field_146297_k.field_71446_o.func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiTItemStackFilter.png"));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int guiWidth = (this.field_146294_l - this.field_146999_f) / 2;
        int guiHeight = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(guiWidth, guiHeight, 0, 0, this.field_146999_f, this.field_147000_g);
        int xAxis = mouseX - (this.field_146294_l - this.field_146999_f) / 2;
        int yAxis = mouseY - (this.field_146295_m - this.field_147000_g) / 2;
        if (xAxis >= 5 && xAxis <= 16 && yAxis >= 5 && yAxis <= 16) {
            this.func_73729_b(guiWidth + 5, guiHeight + 5, 176, 0, 11, 11);
        } else {
            this.func_73729_b(guiWidth + 5, guiHeight + 5, 176, 11, 11, 11);
        }
        if (xAxis >= 128 && xAxis <= 139 && yAxis >= 44 && yAxis <= 55) {
            this.func_73729_b(guiWidth + 128, guiHeight + 44, 187, 0, 11, 11);
        } else {
            this.func_73729_b(guiWidth + 128, guiHeight + 44, 187, 11, 11, 11);
        }
        if (xAxis >= 11 && xAxis <= 22 && yAxis >= 64 && yAxis <= 75) {
            this.func_73729_b(guiWidth + 11, guiHeight + 64, 198, 0, 11, 11);
        } else {
            this.func_73729_b(guiWidth + 11, guiHeight + 64, 198, 11, 11, 11);
        }
        this.minField.func_146194_f();
        this.maxField.func_146194_f();
        if (xAxis >= 12 && xAxis <= 28 && yAxis >= 19 && yAxis <= 35) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179140_f();
            GlStateManager.func_179097_i();
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            int x = guiWidth + 12;
            int y = guiHeight + 19;
            this.func_73733_a(x, y, x + 16, y + 16, -2130706433, -2130706433);
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            GlStateManager.func_179145_e();
            GlStateManager.func_179126_j();
            GlStateManager.func_179121_F();
        }
        super.func_146976_a(partialTick, mouseX, mouseY);
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int button) throws IOException {
        super.func_73864_a(mouseX, mouseY, button);
        this.minField.func_146192_a(mouseX, mouseY, button);
        this.maxField.func_146192_a(mouseX, mouseY, button);
        int xAxis = mouseX - (this.field_146294_l - this.field_146999_f) / 2;
        int yAxis = mouseY - (this.field_146295_m - this.field_147000_g) / 2;
        if (button == 0) {
            if (xAxis >= 5 && xAxis <= 16 && yAxis >= 5 && yAxis <= 16) {
                SoundHandler.playSound(SoundEvents.field_187909_gi);
                Mekanism.packetHandler.sendToServer(new PacketLogisticalSorterGui.LogisticalSorterGuiMessage(PacketLogisticalSorterGui.SorterGuiPacket.SERVER, Coord4D.get(this.tileEntity), this.isNew ? 4 : 0, 0, 0));
            }
            if (xAxis >= 12 && xAxis <= 28 && yAxis >= 19 && yAxis <= 35) {
                ItemStack stack = this.field_146297_k.field_71439_g.field_71071_by.func_70445_o();
                if (stack != null && !Keyboard.isKeyDown((int)42)) {
                    this.filter.itemType = stack.func_77946_l();
                    this.filter.itemType.field_77994_a = 1;
                } else if (stack == null && Keyboard.isKeyDown((int)42)) {
                    this.filter.itemType = null;
                }
                SoundHandler.playSound(SoundEvents.field_187909_gi);
            }
            if (xAxis >= 128 && xAxis <= 139 && yAxis >= 44 && yAxis <= 55) {
                SoundHandler.playSound(SoundEvents.field_187909_gi);
                boolean bl = this.filter.sizeMode = !this.filter.sizeMode;
            }
            if (xAxis >= 11 && xAxis <= 22 && yAxis >= 64 && yAxis <= 75) {
                SoundHandler.playSound(SoundEvents.field_187909_gi);
                boolean bl = this.filter.allowDefault = !this.filter.allowDefault;
            }
        }
        if (Keyboard.isKeyDown((int)42) && button == 0) {
            button = 2;
        }
        if (xAxis >= 12 && xAxis <= 28 && yAxis >= 44 && yAxis <= 60) {
            SoundHandler.playSound(MekanismSounds.DING);
            if (button == 0) {
                this.filter.color = TransporterUtils.increment(this.filter.color);
            } else if (button == 1) {
                this.filter.color = TransporterUtils.decrement(this.filter.color);
            } else if (button == 2) {
                this.filter.color = null;
            }
        }
    }
}

