/*
 * Decompiled with CFR 0.152.
 */
package appeng.util.item;

import appeng.api.config.FuzzyMode;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAETagCompound;
import appeng.util.Platform;
import appeng.util.item.AEItemDef;
import appeng.util.item.AESharedNBT;
import appeng.util.item.AEStack;
import appeng.util.item.OreHelper;
import io.netty.buffer.ByteBuf;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.InvalidParameterException;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class AEItemStack
extends AEStack<IAEItemStack>
implements IAEItemStack,
Comparable<AEItemStack> {
    private AEItemDef def;

    private AEItemStack(AEItemStack is) {
        this.setDefinition(is.getDefinition());
        this.setStackSize(is.getStackSize());
        this.setCraftable(is.isCraftable());
        this.setCountRequestable(is.getCountRequestable());
    }

    private AEItemStack(ItemStack is) {
        if (is == null) {
            throw new InvalidParameterException("null is not a valid ItemStack for AEItemStack.");
        }
        Item item = is.func_77973_b();
        if (item == null) {
            throw new InvalidParameterException("Contained item is null, thus not a valid ItemStack for AEItemStack.");
        }
        this.setDefinition(new AEItemDef(item));
        if (this.getDefinition().getItem() == null) {
            throw new InvalidParameterException("This ItemStack is bad, it has a null item.");
        }
        this.getDefinition().setDamageValue(this.def.getDamageValueHack(is));
        if (!is.func_77973_b().func_77645_m()) {
            this.getDefinition().setDisplayDamage(Integer.MAX_VALUE);
        } else {
            this.getDefinition().setDisplayDamage((int)(is.func_77973_b().getDurabilityForDisplay(is) * 2.147483647E9));
        }
        this.getDefinition().setMaxDamage(is.func_77958_k());
        NBTTagCompound tagCompound = is.func_77978_p();
        if (tagCompound != null) {
            this.getDefinition().setTagCompound((AESharedNBT)AESharedNBT.getSharedTagCompound(tagCompound, is));
        }
        this.setStackSize(is.field_77994_a);
        this.setCraftable(false);
        this.setCountRequestable(0L);
        this.getDefinition().reHash();
        this.getDefinition().setIsOre(OreHelper.INSTANCE.isOre(is));
    }

    public static IAEItemStack loadItemStackFromNBT(NBTTagCompound i) {
        if (i == null) {
            return null;
        }
        ItemStack itemstack = ItemStack.func_77949_a((NBTTagCompound)i);
        if (itemstack == null) {
            return null;
        }
        AEItemStack item = AEItemStack.create(itemstack);
        item.setStackSize(i.func_74763_f("Cnt"));
        item.setCountRequestable(i.func_74763_f("Req"));
        item.setCraftable(i.func_74767_n("Craft"));
        return item;
    }

    @Nullable
    public static AEItemStack create(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        return new AEItemStack(stack);
    }

    public static IAEItemStack loadItemStackFromPacket(ByteBuf data) throws IOException {
        byte mask = data.readByte();
        byte stackType = (byte)((mask & 0xC) >> 2);
        byte countReqType = (byte)((mask & 0x30) >> 4);
        boolean isCraftable = (mask & 0x40) > 0;
        boolean hasTagCompound = (mask & 0x80) > 0;
        NBTTagCompound d = new NBTTagCompound();
        short itemNumericId = data.readShort();
        d.func_74778_a("id", String.valueOf(itemNumericId));
        d.func_74777_a("Damage", data.readShort());
        d.func_74774_a("Count", (byte)0);
        if (hasTagCompound) {
            int len = data.readInt();
            byte[] bd = new byte[len];
            data.readBytes(bd);
            ByteArrayInputStream di = new ByteArrayInputStream(bd);
            d.func_74782_a("tag", (NBTBase)CompressedStreamTools.func_74794_a((DataInputStream)new DataInputStream(di)));
        }
        long stackSize = AEItemStack.getPacketValue(stackType, data);
        long countRequestable = AEItemStack.getPacketValue(countReqType, data);
        ItemStack itemstack = ItemStack.func_77949_a((NBTTagCompound)d);
        if (itemstack == null) {
            return null;
        }
        AEItemStack item = AEItemStack.create(itemstack);
        item.setStackSize(stackSize);
        item.setCountRequestable(countRequestable);
        item.setCraftable(isCraftable);
        return item;
    }

    @Override
    public void add(IAEItemStack option) {
        if (option == null) {
            return;
        }
        this.incStackSize(option.getStackSize());
        this.setCountRequestable(this.getCountRequestable() + option.getCountRequestable());
        this.setCraftable(this.isCraftable() || option.isCraftable());
    }

    @Override
    public void writeToNBT(NBTTagCompound i) {
        ResourceLocation resourcelocation = (ResourceLocation)Item.field_150901_e.func_177774_c((Object)this.getItem());
        i.func_74778_a("id", resourcelocation == null ? "minecraft:air" : resourcelocation.toString());
        i.func_74774_a("Count", (byte)0);
        i.func_74772_a("Cnt", this.getStackSize());
        i.func_74772_a("Req", this.getCountRequestable());
        i.func_74757_a("Craft", this.isCraftable());
        i.func_74777_a("Damage", (short)this.getDefinition().getDamageValue());
        if (this.getDefinition().getTagCompound() != null) {
            i.func_74782_a("tag", (NBTBase)this.getDefinition().getTagCompound());
        } else {
            i.func_82580_o("tag");
        }
    }

    @Override
    public boolean fuzzyComparison(Object st, FuzzyMode mode) {
        IAEItemStack o;
        if (st instanceof IAEItemStack) {
            o = (IAEItemStack)st;
            if (this.sameOre(o)) {
                return true;
            }
            if (o.getItem() == this.getItem()) {
                if (this.getDefinition().getItem().func_77645_m()) {
                    ItemStack a = this.getItemStack();
                    ItemStack b = o.getItemStack();
                    try {
                        if (mode == FuzzyMode.IGNORE_ALL) {
                            return true;
                        }
                        if (mode == FuzzyMode.PERCENT_99) {
                            Item ai = a.func_77973_b();
                            Item bi = b.func_77973_b();
                            return ai.getDurabilityForDisplay(a) < (double)0.001f == bi.getDurabilityForDisplay(b) < (double)0.001f;
                        }
                        Item ai = a.func_77973_b();
                        Item bi = b.func_77973_b();
                        float percentDamageOfA = 1.0f - (float)ai.getDurabilityForDisplay(a);
                        float percentDamageOfB = 1.0f - (float)bi.getDurabilityForDisplay(b);
                        return percentDamageOfA > mode.breakPoint == percentDamageOfB > mode.breakPoint;
                    }
                    catch (Throwable e) {
                        if (mode == FuzzyMode.IGNORE_ALL) {
                            return true;
                        }
                        if (mode == FuzzyMode.PERCENT_99) {
                            return a.func_77952_i() > 1 == b.func_77952_i() > 1;
                        }
                        float percentDamageOfA = (float)a.func_77952_i() / (float)a.func_77958_k();
                        float percentDamageOfB = (float)b.func_77952_i() / (float)b.func_77958_k();
                        return percentDamageOfA > mode.breakPoint == percentDamageOfB > mode.breakPoint;
                    }
                }
                return this.getItemDamage() == o.getItemDamage();
            }
        }
        if (st instanceof ItemStack) {
            o = (ItemStack)st;
            OreHelper.INSTANCE.sameOre(this, (ItemStack)o);
            if (o.func_77973_b() == this.getItem()) {
                if (this.getDefinition().getItem().func_77645_m()) {
                    ItemStack a = this.getItemStack();
                    try {
                        if (mode == FuzzyMode.IGNORE_ALL) {
                            return true;
                        }
                        if (mode == FuzzyMode.PERCENT_99) {
                            Item ai = a.func_77973_b();
                            Item bi = o.func_77973_b();
                            return ai.getDurabilityForDisplay(a) < (double)0.001f == bi.getDurabilityForDisplay((ItemStack)o) < (double)0.001f;
                        }
                        Item ai = a.func_77973_b();
                        Item bi = o.func_77973_b();
                        float percentDamageOfA = 1.0f - (float)ai.getDurabilityForDisplay(a);
                        float percentDamageOfB = 1.0f - (float)bi.getDurabilityForDisplay((ItemStack)o);
                        return percentDamageOfA > mode.breakPoint == percentDamageOfB > mode.breakPoint;
                    }
                    catch (Throwable e) {
                        if (mode == FuzzyMode.IGNORE_ALL) {
                            return true;
                        }
                        if (mode == FuzzyMode.PERCENT_99) {
                            return a.func_77952_i() > 1 == o.func_77952_i() > 1;
                        }
                        float percentDamageOfA = (float)a.func_77952_i() / (float)a.func_77958_k();
                        float percentDamageOfB = (float)o.func_77952_i() / (float)o.func_77958_k();
                        return percentDamageOfA > mode.breakPoint == percentDamageOfB > mode.breakPoint;
                    }
                }
                return this.getItemDamage() == o.func_77952_i();
            }
        }
        return false;
    }

    @Override
    public IAEItemStack copy() {
        return new AEItemStack(this);
    }

    @Override
    public IAEItemStack empty() {
        IAEItemStack dup = this.copy();
        dup.reset();
        return dup;
    }

    @Override
    public IAETagCompound getTagCompound() {
        return this.getDefinition().getTagCompound();
    }

    @Override
    public boolean isItem() {
        return true;
    }

    @Override
    public boolean isFluid() {
        return false;
    }

    @Override
    public StorageChannel getChannel() {
        return StorageChannel.ITEMS;
    }

    @Override
    public ItemStack getItemStack() {
        ItemStack is = new ItemStack(this.getDefinition().getItem(), (int)Math.min(Integer.MAX_VALUE, this.getStackSize()), this.getDefinition().getDamageValue());
        if (this.getDefinition().getTagCompound() != null) {
            is.func_77982_d(this.getDefinition().getTagCompound().getNBTTagCompoundCopy());
        }
        return is;
    }

    @Override
    public Item getItem() {
        return this.getDefinition().getItem();
    }

    @Override
    public int getItemDamage() {
        return this.getDefinition().getDamageValue();
    }

    @Override
    public boolean sameOre(IAEItemStack is) {
        return OreHelper.INSTANCE.sameOre(this, is);
    }

    @Override
    public boolean isSameType(IAEItemStack otherStack) {
        if (otherStack == null) {
            return false;
        }
        return this.getDefinition().equals(((AEItemStack)otherStack).getDefinition());
    }

    @Override
    public boolean isSameType(ItemStack otherStack) {
        if (otherStack == null) {
            return false;
        }
        return this.getDefinition().isItem(otherStack);
    }

    public int hashCode() {
        return this.getDefinition().getMyHash();
    }

    @Override
    public boolean equals(Object ia) {
        ItemStack is;
        if (ia instanceof AEItemStack) {
            return ((AEItemStack)ia).getDefinition().equals(this.def);
        }
        if (ia instanceof ItemStack && (is = (ItemStack)ia).func_77973_b() == this.getDefinition().getItem() && is.func_77952_i() == this.getDefinition().getDamageValue()) {
            NBTTagCompound tb;
            AESharedNBT ta = this.getDefinition().getTagCompound();
            if (ta == (tb = is.func_77978_p())) {
                return true;
            }
            if (ta == null && tb == null || ta != null && ta.func_82582_d() && tb == null || tb != null && tb.func_82582_d() && ta == null || ta != null && ta.func_82582_d() && tb != null && tb.func_82582_d()) {
                return true;
            }
            if (ta == null && tb != null || ta != null && tb == null) {
                return false;
            }
            if (AESharedNBT.isShared(tb)) {
                return ta == tb;
            }
            return Platform.itemComparisons().isNbtTagEqual((NBTBase)ta, (NBTBase)tb);
        }
        return false;
    }

    public String toString() {
        return this.getItemStack().toString();
    }

    @Override
    public int compareTo(AEItemStack b) {
        int id = this.getDefinition().getItemID() - b.getDefinition().getItemID();
        if (id != 0) {
            return id;
        }
        int damageValue = this.getDefinition().getDamageValue() - b.getDefinition().getDamageValue();
        if (damageValue != 0) {
            return damageValue;
        }
        int displayDamage = this.getDefinition().getDisplayDamage() - b.getDefinition().getDisplayDamage();
        if (displayDamage != 0) {
            return displayDamage;
        }
        return this.getDefinition().getTagCompound() == b.getDefinition().getTagCompound() ? 0 : this.compareNBT(b.getDefinition());
    }

    private int compareNBT(AEItemDef b) {
        int nbt = this.compare(this.getDefinition().getTagCompound() == null ? 0 : this.getDefinition().getTagCompound().getHash(), b.getTagCompound() == null ? 0 : b.getTagCompound().getHash());
        if (nbt == 0) {
            return this.compare(System.identityHashCode(this.getDefinition().getTagCompound()), System.identityHashCode(b.getTagCompound()));
        }
        return nbt;
    }

    private int compare(int l, int m) {
        return l < m ? -1 : (l > m ? 1 : 0);
    }

    @SideOnly(value=Side.CLIENT)
    public List getToolTip() {
        if (this.getDefinition().getTooltip() != null) {
            return this.getDefinition().getTooltip();
        }
        return this.getDefinition().setTooltip(Platform.getTooltip(this.getItemStack()));
    }

    @SideOnly(value=Side.CLIENT)
    public String getDisplayName() {
        if (this.getDefinition().getDisplayName() == null) {
            this.getDefinition().setDisplayName(Platform.getItemDisplayName(this.getItemStack()));
        }
        return this.getDefinition().getDisplayName();
    }

    @SideOnly(value=Side.CLIENT)
    public String getModID() {
        if (this.getDefinition().getUniqueID() != null) {
            return this.getModName(this.getDefinition().getUniqueID());
        }
        return this.getModName(this.getDefinition().setUniqueID((ResourceLocation)Item.field_150901_e.func_177774_c((Object)this.getDefinition().getItem())));
    }

    private String getModName(ResourceLocation uniqueIdentifier) {
        if (uniqueIdentifier == null) {
            return "** Null";
        }
        return uniqueIdentifier.func_110624_b() == null ? "** Null" : uniqueIdentifier.func_110624_b();
    }

    IAEItemStack getLow(FuzzyMode fuzzy, boolean ignoreMeta) {
        AEItemStack bottom = new AEItemStack(this);
        AEItemDef newDef = bottom.setDefinition(bottom.getDefinition().copy());
        if (ignoreMeta) {
            newDef.setDisplayDamage(newDef.setDamageValue(0));
            newDef.reHash();
            return bottom;
        }
        if (newDef.getItem().func_77645_m()) {
            if (fuzzy == FuzzyMode.IGNORE_ALL) {
                newDef.setDisplayDamage(0);
            } else if (fuzzy == FuzzyMode.PERCENT_99) {
                if (this.getDefinition().getDamageValue() == 0) {
                    newDef.setDisplayDamage(0);
                } else {
                    newDef.setDisplayDamage(1);
                }
            } else {
                int breakpoint = fuzzy.calculateBreakPoint(this.getDefinition().getMaxDamage());
                newDef.setDisplayDamage(breakpoint <= this.getDefinition().getDisplayDamage() ? breakpoint : 0);
            }
            newDef.setDamageValue(newDef.getDisplayDamage());
        }
        newDef.setTagCompound(AEItemDef.LOW_TAG);
        newDef.reHash();
        return bottom;
    }

    IAEItemStack getHigh(FuzzyMode fuzzy, boolean ignoreMeta) {
        AEItemStack top = new AEItemStack(this);
        AEItemDef newDef = top.setDefinition(top.getDefinition().copy());
        if (ignoreMeta) {
            newDef.setDisplayDamage(newDef.setDamageValue(Integer.MAX_VALUE));
            newDef.reHash();
            return top;
        }
        if (newDef.getItem().func_77645_m()) {
            if (fuzzy == FuzzyMode.IGNORE_ALL) {
                newDef.setDisplayDamage(this.getDefinition().getMaxDamage() + 1);
            } else if (fuzzy == FuzzyMode.PERCENT_99) {
                if (this.getDefinition().getDamageValue() == 0) {
                    newDef.setDisplayDamage(0);
                } else {
                    newDef.setDisplayDamage(this.getDefinition().getMaxDamage() + 1);
                }
            } else {
                int breakpoint = fuzzy.calculateBreakPoint(this.getDefinition().getMaxDamage());
                newDef.setDisplayDamage(this.getDefinition().getDisplayDamage() < breakpoint ? breakpoint - 1 : this.getDefinition().getMaxDamage() + 1);
            }
            newDef.setDamageValue(newDef.getDisplayDamage());
        }
        newDef.setTagCompound(AEItemDef.HIGH_TAG);
        newDef.reHash();
        return top;
    }

    public boolean isOre() {
        return this.getDefinition().getIsOre() != null;
    }

    @Override
    void writeIdentity(ByteBuf i) throws IOException {
        i.writeShort(Item.field_150901_e.func_148757_b((Object)this.getDefinition().getItem()));
        i.writeShort(this.getItemDamage());
    }

    @Override
    void readNBT(ByteBuf i) throws IOException {
        if (this.hasTagCompound()) {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            DataOutputStream data = new DataOutputStream(bytes);
            CompressedStreamTools.func_74800_a((NBTTagCompound)((NBTTagCompound)this.getTagCompound()), (DataOutput)data);
            byte[] tagBytes = bytes.toByteArray();
            int size = tagBytes.length;
            i.writeInt(size);
            i.writeBytes(tagBytes);
        }
    }

    @Override
    public boolean hasTagCompound() {
        return this.getDefinition().getTagCompound() != null;
    }

    AEItemDef getDefinition() {
        return this.def;
    }

    private AEItemDef setDefinition(AEItemDef def) {
        this.def = def;
        return def;
    }
}

