/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.networking;

import appeng.api.config.Actionable;
import appeng.api.networking.GridFlags;
import appeng.api.networking.events.MENetworkControllerChange;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.events.MENetworkPowerStorage;
import appeng.api.networking.pathing.ControllerState;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.block.networking.BlockController;
import appeng.me.GridAccessException;
import appeng.tile.grid.AENetworkPowerTile;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.inventory.InvOperation;
import java.util.EnumSet;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class TileController
extends AENetworkPowerTile {
    private static final IInventory NULL_INVENTORY = new AppEngInternalInventory(null, 0);
    private static final int[] ACCESSIBLE_SLOTS_BY_SIDE = new int[0];
    private boolean isValid = false;

    public TileController() {
        this.setInternalMaxPower(8000.0);
        this.setInternalPublicPowerStorage(true);
        this.getProxy().setIdlePowerUsage(3.0);
        this.getProxy().setFlags(GridFlags.CANNOT_CARRY, GridFlags.DENSE_CAPACITY);
    }

    @Override
    public AECableType getCableConnectionType(AEPartLocation dir) {
        return AECableType.DENSE;
    }

    @Override
    public void onReady() {
        this.onNeighborChange(true);
        super.onReady();
    }

    public void onNeighborChange(boolean force) {
        boolean xx = this.checkController(this.field_174879_c.func_177972_a(EnumFacing.EAST)) && this.checkController(this.field_174879_c.func_177972_a(EnumFacing.WEST));
        boolean yy = this.checkController(this.field_174879_c.func_177972_a(EnumFacing.UP)) && this.checkController(this.field_174879_c.func_177972_a(EnumFacing.DOWN));
        boolean zz = this.checkController(this.field_174879_c.func_177972_a(EnumFacing.NORTH)) && this.checkController(this.field_174879_c.func_177972_a(EnumFacing.SOUTH));
        boolean oldValid = this.isValid;
        boolean bl = xx && !yy && !zz || !xx && yy && !zz || !xx && !yy && zz || (xx ? 1 : 0) + (yy ? 1 : 0) + (zz ? 1 : 0) <= 1 ? true : (this.isValid = false);
        if (oldValid != this.isValid || force) {
            if (this.isValid) {
                this.getProxy().setValidSides(EnumSet.allOf(EnumFacing.class));
            } else {
                this.getProxy().setValidSides(EnumSet.noneOf(EnumFacing.class));
            }
            this.updateMeta();
        }
    }

    private void updateMeta() {
        if (!this.getProxy().isReady()) {
            return;
        }
        BlockController.ControllerBlockState metaState = BlockController.ControllerBlockState.offline;
        try {
            if (this.getProxy().getEnergy().isNetworkPowered()) {
                metaState = BlockController.ControllerBlockState.online;
                if (this.getProxy().getPath().getControllerState() == ControllerState.CONTROLLER_CONFLICT) {
                    metaState = BlockController.ControllerBlockState.conflicted;
                }
            }
        }
        catch (GridAccessException e) {
            metaState = BlockController.ControllerBlockState.offline;
        }
        if (this.checkController(this.field_174879_c) && this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b(BlockController.CONTROLLER_STATE) != metaState) {
            this.field_145850_b.func_175656_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a(BlockController.CONTROLLER_STATE, (Comparable)((Object)metaState)));
        }
    }

    @Override
    protected double getFunnelPowerDemand(double maxReceived) {
        try {
            return this.getProxy().getEnergy().getEnergyDemand(8000.0);
        }
        catch (GridAccessException e) {
            return super.getFunnelPowerDemand(maxReceived);
        }
    }

    @Override
    protected double funnelPowerIntoStorage(double power, Actionable mode) {
        try {
            double ret = this.getProxy().getEnergy().injectPower(power, mode);
            if (mode == Actionable.SIMULATE) {
                return ret;
            }
            return 0.0;
        }
        catch (GridAccessException e) {
            return super.funnelPowerIntoStorage(power, mode);
        }
    }

    @Override
    protected void PowerEvent(MENetworkPowerStorage.PowerEventType x) {
        try {
            this.getProxy().getGrid().postEvent(new MENetworkPowerStorage(this, x));
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    @MENetworkEventSubscribe
    public void onControllerChange(MENetworkControllerChange status) {
        this.updateMeta();
    }

    @MENetworkEventSubscribe
    public void onPowerChange(MENetworkPowerStatusChange status) {
        this.updateMeta();
    }

    @Override
    public IInventory getInternalInventory() {
        return NULL_INVENTORY;
    }

    @Override
    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removed, ItemStack added) {
    }

    @Override
    public int[] getAccessibleSlotsBySide(EnumFacing whichSide) {
        return ACCESSIBLE_SLOTS_BY_SIDE;
    }

    private boolean checkController(BlockPos pos) {
        BlockPos ownPos = this.func_174877_v();
        if (this.field_145850_b.func_72863_F().func_186026_b(ownPos.func_177958_n() >> 4, ownPos.func_177952_p() >> 4) != null) {
            return this.field_145850_b.func_175625_s(pos) instanceof TileController;
        }
        return false;
    }
}

